
/*
 *  Copyright (c) 1998 - 1999, 2001 Karel Zak "Zakkr" <zakkr@zf.jcu.cz>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  $Id: input.c,v 1.2 2001/01/02 14:16:15 zakkr Exp $
 */


#include <ctype.h>

#include "aca.h"
#include "aca_widget.h"
#include "widget_utils.h"


   void input_to_str(Winput *i, int key)
   {
      int	a;
   
   #ifdef HAVE_MOUSE
      if (key == K_MOUSE_L || key == K_MOUSE_M || key ==K_MOUSE_R || 
          key == K_STAY) 
      		return;
      else 
   #endif    
   
      if (key == XCTRL('a') || key == KEY_HOME)
         i->poz = 0;
      else if (key == KEY_END)
         i->poz = i->a_size; 
      else if (key == KEY_LEFT && i->poz > 0) 
         --i->poz;
      else if (key == KEY_RIGHT && i->poz < i->max && i->poz < i->a_size) 
         ++i->poz; 
      else if (key == KEY_BACKSPACE && i->poz > 0) {
         for(a=--i->poz; a < i->a_size; a++) 
            i->str[a] = i->str[a+1];
         --i->a_size;	
      }
      else if (key == KEY_DC && i->poz < i->a_size ) {
         for(a=i->poz; a < i->a_size; a++) 
            i->str[a] = i->str[a+1];
         --i->a_size;	
      }
      else {
         if (key == '\t') 
            return;
         if (isfunckey( key )) 
            return;
         if (aca.output_7bit_only && !isascii(key))  
            key = ' ';
         if (i->poz < i->a_size) 
            for(a=++i->a_size; a>=i->poz+1; a--) 
               i->str[a] = i->str[a-1];
         i->str[i->poz] = key;
         if (i->poz < i->max) ++i->poz;
         if (i->poz > i->a_size) i->a_size = i->poz;			
      }
      i->str[i->a_size] = '\0';
   }

   int input_fn(SessW *s, Widget *w, void *data, int key, int Msg)
   {
      Winput	*i;
      int	a=0;			
      i = (Winput *) data;
   
      _D(" input_fn()");
      DEBUG_WIDGET(w,s);
      
      if (i->flag & Wi_TOP) a=1;
   
      ubold;
   
      switch(Msg) {
      case WIDGET_DRAW:
         if (w->id == s->actual) {
            W_mvaddastr(w, w->y, w->x, i->astr, TplC->input.title_sel_astr, TplC->input.title_sel); 
            curs_set(TRUE);
            clean_hline(w->y+a, w->x +i->astr_size, i->max, TplC->input.sel);	 
            mvaddstr(w->y+a, w->x+i->astr_size, i->str);
            move(w->y+a, w->x + i->astr_size + i->poz);
            s->lock = HOTKEY_LOCK;
         } 
         else if (!(w->flag & Wf_NOTVISIBLE)) {	
            W_mvaddastr(w, w->y, w->x, i->astr, TplC->input.title_nsel_astr, TplC->input.title_nsel);
            curs_set(FALSE);
            clean_hline(w->y+a, w->x + i->astr_size, i->max, TplC->input.nsel);	 
            mvaddstr(w->y+a, w->x + i->astr_size, i->str);
         }
         return Wr_OK;
      case WIDGET_KEY:
         if (w->id == s->actual) {
            if (key==KEY_DOWN || key==KEY_UP || key=='\n' || key=='\t') {
               s->lock = UN_LOCK;
               return Wr_OK;
            } 
            else 
               s->lock = HOTKEY_LOCK;	
         
         #ifdef HAVE_MOUSE            
            if (key == K_MOUSE_L && is_mouse_in_widget(w, s)) {   
            	if (aca.mouse_x >= w->x+i->astr_size && aca.mouse_x <= i->max+i->astr_size+w->x)
            		i->poz = (aca.mouse_x - w->x - i->astr_size) > i->a_size ?
            				i->a_size : aca.mouse_x - w->x -i->astr_size;
            }
         #endif    
         
            input_to_str(i, key);
         
            clean_hline(w->y+a, w->x + i->astr_size, i->max, TplC->input.sel);	 
            mvaddstr(w->y+a, w->x + i->astr_size, i->str);
            move(w->y+a, w->x + i->poz + i->astr_size);
            return Wr_INPUT_CHANGE;
         } 
         else
            widget_keys(key, w, s);	 
         return Wr_OK;
      }
      return Wr_ERROR;
   }

/*
	Input func. for M_EDIT flag
*/	
   int input_to_line(Wmenu *m, Edata *e, Widget *w, int key)
   {
      int	a, 
      item=0;
   
   #ifdef HAVE_MOUSE
      if (key == K_MOUSE_L || key == K_MOUSE_M || key ==K_MOUSE_R || 
          key == K_STAY) 
      		return FALSE;
      else 
   #endif    
   
      if (key == KEY_BACKSPACE || key == KEY_DC)
         item = get_linepoz(e->str, m->item_act, e->c_poz);
   
      if (key == KEY_BACKSPACE && item > 0) {
         for(a=item-1; a < e->bufsiz; a++) 
            e->str[a] = e->str[a+1];
         --e->a_size;
         e->str[e->a_size] = '\0';	   
         if (e->c_poz == 0) {
            int old_len = e->line_act_len;
            menu_seek(m, w, KEY_UP, DUMMY_GO); 
            init_edit(m, e);
            clean_menu(m, w);	
            e->c_poz = e->line_act_len - old_len; 
         } 
         else {
            --e->c_poz;
            --e->line_act_len;
         } 	
      }
      else if (key == KEY_DC && e->c_poz < e->bufsiz ) {
         for(a=item; a < e->bufsiz; a++) 
            e->str[a] = e->str[a+1];
         --e->a_size;
         e->str[e->a_size] = '\0';	
         if (e->c_poz == e->line_act_len) {
            init_edit(m, e);
            clean_menu(m, w);
         } 
         else 
            --e->line_act_len;
      }
      else {
         if (e->a_size + 1 >= e->bufsiz)
            return FALSE;
         if (key == '\t') 
            return FALSE;
         if (isfunckey( key )) 
            return FALSE;
         if (aca.output_7bit_only && !isascii(key))  
            key = ' ';
      
         item = get_linepoz(e->str, m->item_act, e->c_poz);
      
         if (item < e->a_size) {
            for(a=e->a_size+1; a >= item+1; a--) 
               e->str[a] = e->str[a-1];
         }
         e->str[item] = key;
         ++e->a_size;
         e->str[e->a_size] = '\0';	
         if (key == '\n') { 
            init_edit(m, e);	
            menu_seek(m, w, KEY_HOME, DUMMY_GO); 
            menu_seek(m, w, KEY_DOWN, DUMMY_GO); 
         } 
         else {
            ++e->line_act_len;
            if (m->sht_max < e->line_act_len) 
            	m->sht_max = e->line_act_len;
            if (e->c_poz < w->cols-1)	
            	++e->c_poz;
            else if (m->sht_act <  m->sht_max - e->c_poz) 
            	++m->sht_act;	
         } 	
      }
      return TRUE;
   }
