
/*
 *  Copyright (c) 1998 - 1999, 2001 Karel Zak "Zakkr" <zakkr@zf.jcu.cz>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  $Id: menu.c,v 1.2 2001/01/02 14:16:15 zakkr Exp $
 */

#include <ctype.h>

#include "aca.h"
#include "aca_widget.h"
#include "widget_utils.h"

#define	SCR_MAX	 	(m->flag & M_DESCRIPT ? m->scr_max-1 : m->scr_max)
#define MENU_LOCK	(s->lock = (m->flag & M_EDIT  ? HOTKEY_LOCK : SOFT_LOCK))
#define MENU_UNLOCK	(s->lock = UN_LOCK)
/*
	Set actual item and menu line if one item (line) in menu erase
	! not set menu scr_max and item_max >>> you must set it before
	  this function <<< !  
*/
   void decrease_item(Wmenu *m) 
   {
      _D( " decrease_item()");
   
      if (m->fios > 0) { 
         if (m->item_max - m->fios - m->scr_max < 0) {
            --m->fios;
            --m->item_act; 
         }	
      } 
      else {
         if (m->item_act > m->item_max)
            m->item_act = m->scr_act = m->scr_last = m->item_max;
      }
      m->scr_last = m->scr_act;
   }

   void clean_menu(Wmenu *m, Widget *w)
   {
      int 		add_title=0, add_border=0;   
      WidgetColor	*color;
   
      _D( " clean_menu()" );
   
      if      (m->flag & M_COLORDIRECT)		color = &TplC->menu_direct;
      else if (m->flag & M_COLORIN)		color = &TplC->menu_in;
      else					color = &TplC->menu_out;
   
      if (m->flag & M_TOPTITLE)		add_title 	= 1;
      if (m->flag & M_BORDER)		add_border 	= 1;
      else if (m->flag & M_TITLE)	add_title 	= 1;	
      
      clean_box(w->y+add_border+add_title,       
         w->x - (!add_border ? : 0),       
         m->scr_max,       
         w->cols, color->nsel);       
   }


   void draw_menu(Wmenu *m, Widget *w, int redraw)
   {
      int add_title=0, add_border=0;   
   
      if (m->flag & M_TOPTITLE)		add_title 	= 1;
      if (m->flag & M_BORDER)		add_border 	= 1;
      else if (m->flag & M_TITLE)	add_title 	= 1;	
   
      if (!redraw) {
            /* Redraw (only) old */					
         m->line_printer(m, w, w->y+m->scr_last+add_border+add_title,       
            w->x+add_border, m->item_last);
      } 
      else {
         int	i, a;
            /* Set lios */  
         m->lios = m->item_max > SCR_MAX + m->fios ? SCR_MAX + m->fios  :  m->item_max;	
            /* Redraw all line in menu */            	
         for (i=m->fios, a=0; i<=m->lios; i++, a++) {	
            if ((m->flag & M_DESCRIPT) && a==0 ) { 
               m->descript_printer(m, w, w->y+a+add_border+add_title,       
                  	w->x+add_border); 
               --i; 
               continue; 
            }
            if (i!=m->item_act) 
               m->line_printer(m, w, w->y+a+add_border+add_title,       
                  w->x+add_border, i);
         } 	
      }
         /* Last print actual item */ 
      m->line_printer(m, w, w->y+m->scr_act+add_border+add_title,       
         w->x+add_border, m->item_act);	
   }

static int seek_upward(Wmenu *m, int key, int redraw)
{
 	_D( " seek_upward()");

	switch (key) {
   	case KEY_PPAGE:
		if (m->fios - SCR_MAX > 0) {
               		m->item_act -= SCR_MAX;
               		m->fios -= SCR_MAX; 
               		return redraw;
            	}     			
	case KEY_HOME: 
            	if ((m->flag & M_EDIT) && key == KEY_HOME) {
               		m->sht_act = 0; 
               		((Edata *) m->list)->c_poz = 0;
               		return redraw; 
            	}
            	m->scr_act = m->item_act = 0;
            	if (m->fios > 0) redraw = TRUE;
            	m->fios = 0; 		
            	return redraw;
	case KEY_UP:   	        
   	        if (m->item_act > 0) { 
               		--m->item_act;
               		if (m->scr_act == 0 || ((m->flag & M_DESCRIPT) && 
                  					(m->scr_act == 1))) 
               			--m->fios;
               		else 
               			redraw=FALSE; 
               		if (m->scr_act  > 0) --m->scr_act;
               		if (m->flag & M_DESCRIPT)
                		m->scr_act = m->scr_act != 0 ? m->scr_act :
                     			(m->scr_act - 1 > 0 ? --m->scr_act : ++m->scr_act);
            	}
            	return redraw;
   	}   	
   	return redraw;
}

static int seek_downward(Wmenu *m, Widget *w, int key, int redraw)
{
	_D(" seek_downward()");
	
	switch(key) {
        case KEY_NPAGE:
            if (m->fios + SCR_MAX < m->item_max && 
            			m->lios + SCR_MAX < m->item_max) {
               m->item_act += SCR_MAX; 
               m->fios = m->lios; redraw = TRUE;
               return redraw; 		
            }		
         case KEY_END:
            if ((m->flag & M_EDIT) && key == KEY_END) {
               Edata *e = (Edata *) m->list;
               if (e->line_act_len > w->cols-1) {
                  e->c_poz = w->cols-1;
                  m->sht_act = e->line_act_len - e->c_poz;
               } 
               else {
                  e->c_poz = e->line_act_len;
                  m->sht_act = 0;	   
               }
               return redraw;  
            }
            if (m->fios == m->item_max - SCR_MAX) 
               redraw = FALSE;
            if (m->flag & M_DESCRIPT)
            	m->scr_act = m->scr_max > m->item_max+1 ? m->item_max+1 : m->scr_max;
            else
            	m->scr_act = m->scr_max > m->item_max ? m->item_max : m->scr_max;	
            m->fios 	= (m->item_max - SCR_MAX) <0 ? 0 : m->item_max - SCR_MAX; 
            m->item_act = m->item_max;
            return redraw;
         case KEY_DOWN: 
            if (m->item_act < m->item_max) {
               ++m->item_act;
               if (m->scr_act < m->scr_max) { 
                  ++m->scr_act; redraw=FALSE; 
                  if (m->flag & M_DESCRIPT)
                     m->scr_act = m->scr_act != 0 ? m->scr_act :
                        (m->scr_act + 1 > m->scr_max ? --m->scr_act : ++m->scr_act);
               } 
               else { 
                  ++m->fios; redraw=TRUE; 
               }
            }
            return redraw;
   	}
   	return redraw;
   }

   static int seek_sideward(Wmenu *m, Widget *w, int key, int redraw)
   {
   	_D( " seek_sideward()");
   
   	switch(key) {
   	case KEY_LEFT:
            if (!(m->flag & M_EDIT)) {
               if (m->sht_act > 0) 
                  --m->sht_act;
            } 
            else {
               Edata *e = (Edata *) m->list;
               if (e->c_poz > 0)	
                  --e->c_poz;
               else if (m->sht_act > 0) 
                  --m->sht_act;
               else if (m->item_act > 0) {
                  menu_seek(m, w, KEY_UP,	DUMMY_GO); 
                  menu_seek(m, w, KEY_END,	DUMMY_GO); 
               }	
            }		
            return redraw;
         case KEY_RIGHT:
            if (!(m->flag & M_EDIT)) {
               if (m->sht_act <  m->sht_max) 
                  ++m->sht_act;
            } 
            else {
               Edata *e = (Edata *) m->list;
               if (m->sht_act + e->c_poz < e->line_act_len) {
                  if (e->c_poz < w->cols-1)	
                     ++e->c_poz;
                  else if (m->sht_act <  m->sht_max - e->c_poz) 
                     ++m->sht_act;
               } 
               else if (m->item_act < m->item_max) {
                  menu_seek(m, w, KEY_DOWN, 	DUMMY_GO); 
                  menu_seek(m, w, KEY_HOME, 	DUMMY_GO); 
               }	
            }
            return redraw;
         }
        return redraw; 
   }

   void menu_seek(Wmenu *m, Widget *w, int key, int flag) 
   {      
      int	redraw=TRUE; 
   
      _D( " menu_seek()");
   
      if (m->item_max < 0) 
         return;
   
      if (key==KEY_UP  || key==KEY_DOWN  || key==KEY_HOME  || key==K_STAY   || 
      	  key==KEY_END || key==KEY_NPAGE || key==KEY_PPAGE || key==KEY_LEFT || 
          key==KEY_RIGHT) {
      
         if (key!=K_STAY || key!=KEY_LEFT || key!=KEY_RIGHT || (flag & DUMMY_GO)) { 	
         /* If K_STAY redraw only, don't go */		
            m->scr_last  = m->scr_act;
            m->item_last = m->item_act; 
         }

	 if (key==KEY_HOME || key==KEY_PPAGE || key==KEY_UP) 
	 	redraw = seek_upward(m, key, redraw);

	 else if (key==KEY_END || key==KEY_NPAGE || key==KEY_DOWN) 
	 	redraw = seek_downward(m, w, key, redraw);	 
      
	 else if (key==KEY_LEFT || key==KEY_RIGHT) 
	 	redraw = seek_sideward(m, w, key, redraw);	 
                 
      /* Check */

         if (m->scr_last < 0 && m->item_max >= 0) m->scr_last = 0; 
         if (m->scr_act  < 0 && m->item_max >= 0) m->scr_act  = 0; 
         if (m->item_act < 0 && m->item_max >= 0) m->item_act = 0;
         if ((m->flag & M_DESCRIPT) && (m->scr_act==0))
            m->scr_act=1;
         if ((m->flag & M_DESCRIPT) && (0 == m->scr_max) && (m->scr_act==m->scr_max))
            m->scr_act=SCR_MAX;	

         if (m->flag & M_EDIT) 
            if (m->item_last != m->item_act) {
               Edata *e = (Edata *) m->list;
               e->line_act 	= get_line(e->str, m->item_act);
               e->line_act_len	= line_len(e->line_act);
            }
         if (!(flag & DUMMY_GO)) 
            draw_menu(m, w, redraw);         
      }   	
   }

   void menu_dummy_go(Widget *w, Wmenu *m, int key, int num)
   {
      register int	a;
   
      _D( " menu_dummy_go()");
   
      for(a=0; a<=num; a++) 
         menu_seek(m, w, key, DUMMY_GO); 
   }

   static int check_dummy_go(Wmenu *m, int key, int num)
   {
      _D( " check_dummy_go()");
   
      if (m->flag & M_DESCRIPT) {
         if (key == KEY_DOWN && m->item_act <= 0 && 
         m->item_act+num >= 0) {
            --num;
         } 
         else if (key == KEY_UP && m->item_act >= 0 && 
         m->item_act-num <= 0) {
            --num;
         }	
      }
      return num;
   }

   static void alist_seek(Wmenu *m, Widget *w, int key)
   {
      register int	i;
   
      _D( " alist_seek() ");
   
      for(i=0; i<=m->item_max; i++) {     
         if (tolower(key) == gethotkey(m->alist[i])) {
            ACA_RESET_MENU(m);
            menu_dummy_go(w, m, KEY_DOWN, i-1);  
            key = K_STAY;
            break;
         }
      }
      menu_seek(m, w, key, 0); 
   }

   void mpr_astr(Wmenu *m, Widget *w, int line, int cols, int item)
   {  	
      WidgetColor	*color;
   
      _D( " mpr_astr()" );
   
      if      (m->flag & M_COLORDIRECT)	color = &TplC->menu_direct;
      else if (m->flag & M_COLORIN)	color = &TplC->menu_in;
      else				color = &TplC->menu_out;
   
      if (m->item_act == item) {
         clean_hline(line, cols-1, m->flag & M_BORDER ? w->cols+1 : w->cols, color->sel); 
         mvaddastr(line, cols, m->alist[item], 
            color->sel_astr, color->sel);
      } 
      else {
         clean_hline(line, cols-1, m->flag & M_BORDER ? w->cols+1 : w->cols, color->nsel);  
         mvaddastr(line, cols, m->alist[item], 
            color->nsel_astr, color->nsel);			
      }      
   }

   void mpr_str(Wmenu *m, Widget *w, int line, int cols, int item)
   {  	
      int		color;
   
      _D( " mpr_str()");
   
      if (m->flag & M_COLORDIRECT)	
      		color = m->item_act == item ? TplC->menu_direct.sel : TplC->menu_direct.nsel;
      else if (m->flag & M_COLORIN)	
      		color = m->item_act == item ? TplC->menu_in.sel : TplC->menu_in.nsel;
      else				
      		color = m->item_act == item ? TplC->menu_out.sel : TplC->menu_out.nsel;
   
      clean_hline(line, cols-1, m->flag & M_BORDER ? w->cols+1 : w->cols, color); 
      mvaddstr(line, cols, m->alist[item]);
   }

   void init_view(Wmenu *m)
   {
      _D( " init_view()");
   
      m->item_max	= linesize_instr((char *) m->list, &m->sht_max);
   }

   void mpr_descript (Wmenu *m, Widget *w, int line, int cols)
   {
      int	color;
   
      _D( "  mpr_view()");
   
      if      (m->flag & M_COLORDIRECT)		color = TplC->menu_direct.descript;
      else if (m->flag & M_COLORIN)		color = TplC->menu_in.descript;
      else					color = TplC->menu_out.descript;
   
      clean_hline(line, cols-1, m->flag & M_BORDER ? w->cols+1 : w->cols, color); 
      if (m->flag & M_SHTMENU) 
         mvaddline_nstr_sht(line, cols, m->descript, 0, w->cols-2, m->sht_act);			
      else
         mvaddline_nstr(line, cols, m->descript, 0, w->cols-2);			
   }

   void mpr_view (Wmenu *m, Widget *w, int line, int cols, int item)
   {
      int	color;
   
      _D( "  mpr_view()");
   
      if      (m->flag & M_COLORDIRECT)		color = TplC->menu_direct.nsel;
      else if (m->flag & M_COLORIN)		color = TplC->menu_in.nsel;
      else					color = TplC->menu_out.nsel;
   
      clean_hline(line, cols-1, m->flag & M_BORDER ? w->cols+1 : w->cols, color); 
      if (m->item_act == item)  {
         mvaddch(line, cols-1, ACA_RARROW);
         mvaddch(line, cols + w->cols-1, ACA_LARROW);
      }	
      if (m->flag & M_SHTMENU) 
         mvaddline_nstr_sht(line, cols, (char *) m->list, item, 
            w->cols-2, m->sht_act);			
      else
         mvaddline_nstr(line, cols, (char *) m->list, item, w->cols-2);			
   }

   void init_edit(Wmenu *m, Edata *e)
   {
      _D( " init_edit()");
   
      m->item_max	= linesize_instr(e->str, &m->sht_max);
      e->line_act 	= get_line(e->str, m->item_act);
      e->line_act_len	= line_len(e->line_act);
      e->a_size	= strlen(e->str);
   }

   void mpr_edit(Wmenu *m, Widget *w, int line, int cols, int item)
   {
      int	color;
   
      _D( "  mpr_edit()");
   
      if      (m->flag & M_COLORDIRECT)		color = TplC->menu_direct.nsel;
      else if (m->flag & M_COLORIN)		color = TplC->menu_in.nsel;
      else					color = TplC->menu_out.nsel;
   
      clean_hline(line, cols-1, m->flag & M_BORDER ? w->cols+1 : w->cols, color); 
      mvaddline_nstr_sht(line, cols, ((Edata *) m->list)->str, item, 
         w->cols-2, m->sht_act);			
   }

   int is_mouse_in_menu(SessW *s, Widget *w, Wmenu *m) 
   {   
   #ifdef HAVE_MOUSE   	
   int		add_title=0, add_border=0;
   
   	_D( " is_mouse_in_menu()");
   
      	if (m->flag & M_TOPTITLE)	add_title 	= 1;
      	if (m->flag & M_BORDER)		add_border 	= 1;
      	else if (m->flag & M_TITLE)	add_title 	= 1;	
   
   	if (!aca.mouse)			return FALSE;
   
      	/* title */
      	if ( ((m->flag & M_TITLE) || (m->flag & M_TOPTITLE)) && 
      	    aca.mouse_x >= w->x && 
      	    aca.mouse_x <= w->x + m->astr_size &&
   	    aca.mouse_y == w->y)
   		return TRUE;
      	
      	/* still open */
      	if ( (m->flag & M_OPEN) && 
      	    aca.mouse_x >= w->x - add_border &&
      	    aca.mouse_x <= w->cols + w->x + add_border &&
      	    aca.mouse_y >= w->y + add_title &&
      	    aca.mouse_y <= m->scr_max + w->y + add_title+add_border+add_border)
      	    	return TRUE; 
      	    	
   	/* if active and open */
   	else if (w->id == s->actual && 
      	    aca.mouse_x >= w->x - add_title &&
      	    aca.mouse_x <= w->cols + w->x + add_border &&
      	    aca.mouse_y >= w->y + add_title &&
      	    aca.mouse_y <= m->scr_max + w->y + add_title+add_border+add_border)
      	    	return TRUE; 
   #endif   		
      return FALSE;	
   } 

#ifdef HAVE_MOUSE
   static void mouse_reposition_line(Widget *w, Wmenu *m, int add_line)
   {
      int 	i = aca.mouse_y - w->y - add_line - m->scr_act; 
   
      _D( " mouse_reposition_line()");
   
      if ((i>0) && (m->flag & M_DESCRIPT) && m->item_act == 0)
      	i++; 
   
      if (i>0) 
         menu_dummy_go(w, m, KEY_DOWN, check_dummy_go(m, KEY_DOWN, --i));
      else 	
         menu_dummy_go(w, m, KEY_UP, check_dummy_go(m, KEY_UP, i * -1 - 1));
      menu_seek(m, w, K_STAY, 0);	/* redraw menu */
      
      if (m->flag & M_EDIT) {
               Edata	*e = m->list;
               int	add_border = m->flag & M_BORDER ? 1 : 0;
               
               if (aca.mouse_x >= w->x+add_border 
                  && aca.mouse_x <= e->line_act_len+w->x+add_border)
            		e->c_poz = (aca.mouse_x - w->x - add_border) > e->line_act_len ?
            				e->line_act_len : aca.mouse_x - w->x - add_border;
               
               curs_set(1);
               move(w->y + m->scr_act + add_line, 
                  w->x + e->c_poz + add_border);
      }
   }
#endif

   int menu_fn(SessW *s, Widget *w, void *data, int key, int Msg)
   {
      Wmenu		*m;
      WidgetColor	*color;
      int		add_title=0, add_border=0;
      int		mouse_is = FALSE;
      Edata		*edata = NULL;
   
      _D( " menu_fn()");
      DEBUG_WIDGET(w,s);
   
      m = (Wmenu *) data;
   
      if      (m->flag & M_COLORDIRECT)	color = &TplC->menu_direct;
      else if (m->flag & M_COLORIN)	color = &TplC->menu_in;
      else				color = &TplC->menu_out;
   
      if (m->flag & M_TOPTITLE)		add_title 	= 1;
      if (m->flag & M_BORDER)		add_border 	= 1;
      else if (m->flag & M_TITLE)	add_title 	= 1;	
   
      if ((key == K_MOUSE_L || key == K_MOUSE_R) && is_mouse_in_widget(w, s)) 
         mouse_is = TRUE;
   
      if (m->flag & M_EDIT) 
         edata = (Edata *) m->list;
   
      switch(Msg) {
      case WIDGET_DRAW:
         ubold;
         if ((m->flag & M_BORDER) && ((m->flag & M_OPEN) || w->id == s->actual)) 
            draw_linebox(w->y+add_title, w->x-1, m->scr_max+1+add_border, 
               w->cols+2, (w->id == s->actual ? color->border_sel : color->border_nsel));
      
         if (((m->flag & M_OPEN) || w->id == s->actual)
         || (m->item_max < m->scr_max ||  m->item_max < w->lines))
            clean_menu(m, w);
      
         if (w->id == s->actual) {
         
            if ((m->flag & M_TITLE) || (m->flag & M_TOPTITLE)) {
               if (m->flag & M_TITLE_NSEL) 
                  W_mvaddastr (w, w->y, w->x, m->astr, 
                     color->title_nsel_astr, color->title_nsel);	
               else		          
                  W_mvaddastr (w, w->y, w->x, m->astr, 
                     color->title_sel_astr, color->title_sel);	
            } 
          #ifdef HAVE_MOUSE            
            if (mouse_is) {
            	mouse_reposition_line(w, m, add_border+add_title);
            	MENU_LOCK;
            	return Wr_MENU_CHANGE;		
            } else 
          #endif    
            menu_seek(m, w, K_STAY, 0);	     

            if (m->flag & M_EDIT) {
               curs_set(1);
               move(w->y + m->scr_act + add_title + add_border, 
                  w->x + edata->c_poz + add_border);
            }
            MENU_LOCK;
         } 
         else if (!(w->flag & Wf_NOTVISIBLE)) {
            if ((m->flag & M_TITLE) || (m->flag & M_TOPTITLE))
               W_mvaddastr(w, w->y, w->x, m->astr, 
                  color->title_nsel_astr, color->title_nsel);			
            if (m->flag & M_OPEN) { 
               if (!(m->flag & M_STILLV)) {	
                  int	a, i;
               	/* invisible cursor line */
                  i 		= color->sel;
                  a 		= color->sel_astr;
                  color->sel	= color->nsel;
                  color->sel_astr	= color->nsel_astr;
                  menu_seek(m, w, K_STAY, 0);
                  color->sel 	= i;	
                  color->sel_astr	= a;
               } 
               else
                  menu_seek(m, w, K_STAY, 0);	
            }
            if (m->flag & M_EDIT) 
               curs_set(0);
         }
         return Wr_OK;
      case WIDGET_KEY:
         if (w->id == s->actual) {
         
            /* spec. for SHTMENU */
            if ((!(m->flag & M_SHTMENU)) || (key!=KEY_LEFT && key!=KEY_RIGHT) ) {
               int	akey=1, ahot=2;
            
            /* spec. for EDIT */
               if ((!(m->flag & M_EDIT)) || ( key!='\n' && !mouse_is)) {
               
               /* go out of menu */
                  if (key==KEY_LEFT || key==KEY_RIGHT || key=='\t' || key == '\n'
                  
                  	|| ((m->flag & M_ALIST) && 
                  	((akey = tolower(key)) == (ahot = gethotkey(m->alist[m->item_act]))))
                  
                  #ifdef HAVE_MOUSE	
                  	/* press mouse over actual menu item */
                  	|| (mouse_is &&
                  	 aca.mouse_y-w->y-add_title-add_border == m->scr_act)
                  #endif	
                  
                  ) {
                     if ((m->flag & M_ALIST) && (akey == ahot))
                        key = '\n';
                  
                     if (key == K_MOUSE_L ) key = '\n';
                     if ((!(m->flag & M_NOTOUT)) || key!='\n') {
                        MENU_UNLOCK;
                        if (key == '\n') s->key = KEY_DOWN;
                     }
                     return (key == '\n' ? 
                        ((m->flag & M_OPEN) ? Wr_MENU_PRESS : Wr_MENU_PRESS | Wr_NEED_REDRAW) : 
                        ((m->flag & M_OPEN) ? Wr_MENU_OUT   : Wr_MENU_OUT   | Wr_NEED_REDRAW));	      
                  } 
                  else 
                     MENU_LOCK;	
               
               } 
               else /*	EDIT 	*/
                  MENU_LOCK;
            
            } 
            else /*  	SHTMENU */ 
               MENU_LOCK;
         
            if((m->flag & M_TITLE) || (m->flag & M_TOPTITLE)) {
               if (m->flag & M_TITLE_NSEL) 
                  W_mvaddastr (w, w->y, w->x, m->astr, 
                     color->title_nsel_astr, color->title_nsel);	
               else		          
                  W_mvaddastr (w, w->y, w->x, m->astr, 
                     color->title_sel_astr, color->title_sel);
            }    
         
         #ifdef HAVE_MOUSE            
            if (mouse_is) {
            	mouse_reposition_line(w, m, add_border+add_title);
            	return Wr_MENU_CHANGE;		
            }
         #endif    
         
            if ((m->flag & M_EDIT) && 
            input_to_line(m, (Edata *) m->list, w, s->key))
               menu_seek(m, w, K_STAY, 0);
            else {
            	/* standard keys */ 
               if (m->flag & M_ALIST)	
                  alist_seek(m, w, key);
               else	
                  menu_seek(m, w, key, 0);
            }
         
            if (m->flag & M_EDIT) {
               curs_set(1);
               move(w->y + m->scr_act + add_title + add_border, 
                  w->x + edata->c_poz + add_border);
            }  
            return Wr_MENU_CHANGE;	
         
         /* not actual */
         } 
         else 
         	widget_keys(key, w, s);
         return Wr_OK;
         
      } /* switch() */
      return Wr_ERROR;
   }

