
/*
 *  Copyright (c) 1998 - 1999, 2001 Karel Zak "Zakkr" <zakkr@zf.jcu.cz>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  $Id: session.c,v 1.2 2001/01/02 14:16:15 zakkr Exp $
 */

#include "aca.h"
#include "aca_widget.h"

#include "widget_utils.h"

#include <stdarg.h>

/*
	Set widget 'x' position for more widgets which go to follow first
	widget. Format string set interspace between widgets and x position 
	of next widget, x position is always set as a:
	
	 'x position of previous widget' + 'astr_size of previous widget'
	 + 'interspace between 'w' in format string'. 
	 
	Example:
	~~~~~~~
	set_widgets_progression(20, "w w    w", &A, &B, &C);
				      ^ ^^^^
		    - interspace:    1	4
	
	is --> 	A.x = 20;
		B.x = 20 + A.astr_size + 1;
		C.x = 20 + A.astr_size + B.astr_size + 1 + 4;
	
	&A is pointer to Widget A
	
        - interspace you can set with 'i' :
        
        set_widgets_progression(20, "w wiw", &A, &B, 4, &C);
	(is equivalent to first example) 

	Note: this func. is need for locale (size of strings is floating 
	      between differet translation) - strings size (value astr_size 
	      in Widget struct) is set in init_sessw().
	
*/

   int set_widgets_progression(int first_x, char *format, ...)
   {
      va_list	ap;
      int	poz=0;
      Widget	*w;

      _D( "set_widgets_progression()");
   
      va_start(ap, format);
      while(*format) {
         if (*format == 'w') {
            w = va_arg(ap, Widget *);
            w->x = first_x + poz;
            poz += (get_astr_size(w)+1);  
         } 
         else if (*format == 'i') 
            poz += va_arg(ap, int);
         else if (*format == ' ') 
            poz++;
         format++;
      }	
      va_end(ap);
      return poz+first_x;	
   }

   int size_widgets_progression(char *format, ...)
   {
      va_list	ap;
      int	size=0;
      Widget	*w;
   
      _D( "size_widgets_progression()");
   
      va_start(ap, format);
      while(*format) {
         if (*format == 'w') {
            w = va_arg(ap, Widget *);
            size += (get_astr_size(w)+1);	/* astr size is astrlen()-1 */  
         } 
         else if (*format == 'i') 
            size += va_arg(ap, int);
         else if (*format == ' ') 
            size++;
         format++;
      }	
      va_end(ap);
      return size;
   }

   void set_widget(Widget *wtab, SessW *s, int new_actual)
   {
      int	old = s->actual;
   
      _D( " set_widget()");

      if (s->count == 0) 
         return;
      s->actual	= new_actual;	
      if (s->lock) {
         s->lock = UN_LOCK;
         W_redraw_session(s);
      }
      curs_set(0);
      wtab[ old ].widget_fn (s, &wtab[ old ], 
         wtab[old].widget_data,	s->key, WIDGET_DRAW);  
      wtab[ s->actual ].widget_fn (s, &wtab[s->actual], 
         wtab[s->actual].widget_data, s->key, WIDGET_DRAW);  				
   }

#define SET_ASTR(wed,data)	{					\
	if ((data)->astr) {						\
		(data)->astr  = dgettext((wed)->text_domain, (data)->astr); \
		if ((wed)->hotkey==TRUE) 				\
			(wed)->hotkey = gethotkey((data)->astr);	\
	} 								\
}									\

   void init_sessw(SessW *s, int actual, int lock, Widget *wtab, 
		   void (*bgr_redraw)(), int flag)
   {
      Widget 	*w;
      int	i=0;
   
      _D(" init_sessw()");
   
      s->actual 	= actual;
      s->lock		= lock;
      s->wtab		= wtab;
      s->key		= K_STAY;
      s->bgr_redraw	= bgr_redraw;
      s->flag		= flag;
   
      for(w=s->wtab; w->widget_fn != NULL; w++, i++) {
         w->id = i;		
         if (w->widget_fn == button_fn) {
            Wbutton	*b;
            b = (Wbutton *) w->widget_data;
            SET_ASTR(w, b);
            if ((b->astr_size = astrlen(b->astr)-1) > 0) 
               w->cols = b->astr_size;
         } 
         else if (w->widget_fn == radio_fn) {
            Wradio	*r;
            r = (Wradio *) w->widget_data;
            SET_ASTR(w, r);
            if ((r->astr_size = astrlen(r->astr)-1) > 0)
               w->cols = r->astr_size + 4;
         } 
         else  if (w->widget_fn == input_fn) {
            Winput	*inp;
            inp = (Winput *) w->widget_data;
            SET_ASTR(w,inp);
            if ((inp->astr_size = astrlen(inp->astr)) > 0)
               w->cols = inp->astr_size + inp->max;
         } 
         else  if (w->widget_fn == menu_fn) {
            Wmenu	*m;
            m = (Wmenu *) w->widget_data;
            if((m->flag & M_TITLE) || (m->flag & M_TOPTITLE)) {
               SET_ASTR(w,m);
               m->astr_size = astrlen(m->astr)-1;
            } 
            if((m->flag & M_ALIST) || (m->flag & M_SLIST)) 
               w->cols = init_str_list(m->alist, m->item_max, m->flag, w->text_domain)+1;
         } 
      }	
      s->count = --i;
   }

   int W_go_down(SessW *s)
   {
      Widget	*w;
      int	jump=1;
   
      _D(" W_go_down()");
   
      for(w=(s->wtab+s->actual+1); w->widget_fn != NULL; w++) {
         if (w->flag & Wf_NOTVISIBLE)	++jump;
         else 				
            break;	
      }
      if (s->actual+jump > s->count) {
         if ((*s->wtab).flag & Wf_NOTVISIBLE) {
            s->actual = 0;
            W_go_down(s);
            W_redraw_session(s);
            return RE_OK;
         } 
         else
            set_widget(s->wtab, s, 0);
         return RE_OK;	
      }
      set_widget(s->wtab, s, s->actual+jump);
      return RE_OK;
   }

   int W_go_up(SessW *s)
   {
      int	i, jump=1;
   
   
      _D(" W_go_up()");
   
      for(i=s->actual-1; i>=0; i--) {
         if (s->wtab[i].flag & Wf_NOTVISIBLE) 
            ++jump;
         else 
            break;	
      }
      if (s->actual-jump < 0 ) {
         if ((*(s->wtab+s->count)).flag & Wf_NOTVISIBLE) {
            s->actual = s->count;
            W_go_up(s);
            W_redraw_session(s);
            return RE_OK;
         } 
         else
            set_widget(s->wtab, s, s->count);
         return RE_OK;	
      }
      set_widget(s->wtab, s, s->actual-jump);
      return RE_OK;
   }

   void W_default_go(SessW *s)
   {
      _D(" W_default_go()");
   
      if (!s->lock) {
         if (s->key==KEY_DOWN || s->key==KEY_RIGHT || s->key=='\t') 
            W_go_down(s);
         if (s->key==KEY_UP   || s->key==KEY_LEFT)  
            W_go_up(s);
      }
   }

   void W_redraw_session(SessW *s)
   {
      Widget	*w;
      
      _D(" W_redraw_session()");
      
      curs_set(0);
      if (!(s->flag & Sf_NOT_BGR))
         s->bgr_redraw(s);
   
      for(w=s->wtab; w->widget_fn != NULL; w++) {
         if (w != s->wtab+s->actual)
            w->widget_fn(s, w, w->widget_data, K_STAY, WIDGET_DRAW); 
      }
   
      if (s->actual >= 0)
         (*(s->wtab+s->actual)).widget_fn(s, s->wtab+s->actual, 
            (*(s->wtab+s->actual)).widget_data, K_STAY, WIDGET_DRAW); 
   }

   int W_key_to_widgets(SessW *s)
   {	
      int	re = Wr_OK;
      Widget	*w;
 
      _D(" W_redraw_session()");
   
      for(w=s->wtab; w->widget_fn != NULL; w++) {
         if (w != s->wtab+s->actual) {
            if ((re = w->widget_fn(s, w, w->widget_data, s->key, WIDGET_KEY)) != Wr_OK)
            	return re; 
         } else
         	continue;
      }
      return Wr_OK;
   }


/* was in W_redraw_session() 
            if ((*(s->wtab+s->actual)).flag & Wf_TYPE_INPUT)
               if (s->key != K_MOUSE_L) 
                  continue;
 */