/* -*- C++ -*- */

//=============================================================================
/**
 *  @file    QoS_Session_Factory.h
 *
 *  QoS_Session_Factory.h,v 1.2 2001/03/30 01:03:19 crodrigu Exp
 *
 *  @author Vishal Kachroo <vishal@cs.wustl.edu>
 */
//=============================================================================


#ifndef ACE_QOS_SESSION_FACTORY_H
#define ACE_QOS_SESSION_FACTORY_H
#include "ace/pre.h"

#include "ace/QoS/QoS_Session.h"

#if !defined (ACE_LACKS_PRAGMA_ONCE)
# pragma once
#endif /* ACE_LACKS_PRAGMA_ONCE */

#include "ace/Containers_T.h"
#include "ACE_QoS_Export.h"

/**
 * @class ACE_QoS_Session;
 Forward declare this, so the factory uses only references to this.
 */
class ACE_QoS_Session;

/**
 * @class ACE_QoS_Session_Factory
 *
 * @brief Concrete factory for the QoS Session objects.
 *
 * This class manages the life cycle of QoS Session objects. These
 * objects are currently either RAPI session objects or GQoS session
 * objects. It stores the sessions in an unbounded set.
 */
class ACE_QoS_Export ACE_QoS_Session_Factory
{

public :

  // = Initialization and termination methods.
  /// Default constructor.
  ACE_QoS_Session_Factory (void);

  /// Default destructor.
  ~ACE_QoS_Session_Factory (void);

  /// Types of sessions for this factory to manage.
  enum ACE_QoS_Session_Type
  {
    ACE_RAPI_SESSION,
    ACE_GQOS_SESSION
  };

  /// Create a QoS session of the given type (RAPI or GQoS).
  ACE_QoS_Session * create_session (ACE_QoS_Session_Type qos_session_type);

  /// Destroy the QoS Session.
  int destroy_session (ACE_QoS_Session *qos_session);

private:

  /// Used by the create_session () to add new sessions to the
  /// set of sessions created by this factory.
  int add_session (ACE_QoS_Session *qos_session);

  /// Used by the destroy_session () to remove a session from the set
  /// of sessions created by this factory.
  int remove_session (ACE_QoS_Session *qos_session);

  /// Unordered set of QoS Sessions.
  typedef ACE_Unbounded_Set <ACE_QoS_Session *> QOS_SESSION_SET;
  QOS_SESSION_SET qos_session_set_;

};

#include "ace/post.h"
#endif /* ACE_QOS_SESSION_FACTORY_H */
