/**
 * @author Johnny Willemsen <jwillemsen@remedy.nl>
 *
 * $Id: PartitionQosPolicy.h 89203 2010-02-24 15:05:08Z msmit $
 *
 * Wrapper facade for NDDS.
 */

#ifndef DDS4CCM_PARTITIONQOSPOLICY_H
#define DDS4CCM_PARTITIONQOSPOLICY_H

#include "dds4ccm/impl/ndds/StringSeq.h"

#if defined (CIAO_DDS4CCM_OPENDDS) && (CIAO_DDS4CCM_OPENDDS==1)
typedef ::DDS::PartitionQosPolicy DDS_PartitionQosPolicy;
#endif

#if defined (CIAO_DDS4CCM_NDDS) && (CIAO_DDS4CCM_NDDS==1)
inline void
operator<<= (::DDS::PartitionQosPolicy &ddsqos, const ::DDS_PartitionQosPolicy & qos)
{
  ddsqos.name <<= qos.name;
}

inline void
operator<<= (::DDS_PartitionQosPolicy &ddsqos, const ::DDS::PartitionQosPolicy & qos)
{
  ddsqos.name <<= qos.name;
}

inline void
operator>>= (const ::DDS_PartitionQosPolicy &qos, ::DDS::PartitionQosPolicy & ddsqos)
{
  ddsqos.name <<= qos.name;
}

inline void
operator>>= (const ::DDS::PartitionQosPolicy &qos, ::DDS_PartitionQosPolicy & ddsqos)
{
  ddsqos.name <<= qos.name;
}
#endif

#endif /* DDS4CCM_PARTITIONQOSPOLICY_H */
