// $Id: XML_Schema_Resolver.tpp 85403 2009-05-20 01:55:39Z wotte $
#ifndef XML_SCHEMA_RESOLVER_TPP
#define XML_SCHEMA_RESOLVER_TPP

#include "XML/XML_Schema_Resolver.h"
#include "XML/XercesString.h"

#include <xercesc/framework/LocalFileInputSource.hpp>
#include <xercesc/framework/Wrapper4InputSource.hpp>

using xercesc::Wrapper4InputSource;
using xercesc::LocalFileInputSource;


namespace CIAO
{
  namespace XML
  {
    template<typename Resolver>
    XML_Schema_Resolver<Resolver>::XML_Schema_Resolver (void)
      : resolver_ ()
    {
    }

    template<typename Resolver>
    XML_Schema_Resolver<Resolver>::XML_Schema_Resolver (Resolver &res)
      : resolver_ (res)
    {
    }

    /// This function is called by the Xerces infrastructure to
    /// actually resolve the location of a schema.
    template<typename Resolver>
    InputSource *
    XML_Schema_Resolver<Resolver>::resolveEntity (const XMLCh *const publicId,
                                                    const XMLCh *const systemId)
    {
      XStr path = resolver_ (publicId, systemId);
      if (path.begin () == 0)
        return 0;
      
      // Ownership of these objects is given to other people.
      return /*new Wrapper4InputSource*/ (new LocalFileInputSource (path.begin ()));
    }    
  }
}

#endif /*XML_SCHEMA_RESOLVER_TPP*/
