// $Id: server.cpp 82836 2008-09-25 20:52:21Z johnnyw $

#include "Payload_Receiver.h"
#include "ace/Get_Opt.h"
#include "ace/OS_NS_stdio.h"

ACE_RCSID(Big_Request_Muxing, server, "$Id: server.cpp 82836 2008-09-25 20:52:21Z johnnyw $")

const ACE_TCHAR *ior_output_file = ACE_TEXT("server.ior");

int
parse_args (int argc, ACE_TCHAR *argv[])
{
  ACE_Get_Opt get_opts (argc, argv, ACE_TEXT("o:"));
  int c;

  while ((c = get_opts ()) != -1)
    switch (c)
      {
      case 'o':
        ior_output_file = get_opts.opt_arg ();
        break;
      case '?':
      default:
        ACE_ERROR_RETURN ((LM_ERROR,
                           "usage:  %s "
                           "-o <iorfile>"
                           "\n",
                           argv [0]),
                          -1);
      }
  // Indicates sucessful parsing of the command line
  return 0;
}

int
ACE_TMAIN(int argc, ACE_TCHAR *argv[])
{
  int status = 0;
  try
    {
      CORBA::ORB_var orb =
        CORBA::ORB_init (argc, argv);

      CORBA::Object_var poa_object =
        orb->resolve_initial_references("RootPOA");

      if (CORBA::is_nil (poa_object.in ()))
        ACE_ERROR_RETURN ((LM_ERROR,
                           " (%P|%t) Unable to initialize the POA.\n"),
                          1);

      PortableServer::POA_var root_poa =
        PortableServer::POA::_narrow (poa_object.in ());

      PortableServer::POAManager_var poa_manager =
        root_poa->the_POAManager ();

      if (parse_args (argc, argv) != 0)
        return 1;

      Payload_Receiver *payload_receiver_impl;
      ACE_NEW_RETURN (payload_receiver_impl,
                      Payload_Receiver (orb.in ()),
                      1);
      PortableServer::ServantBase_var receiver_owner_transfer(payload_receiver_impl);

      PortableServer::ObjectId_var id =
        root_poa->activate_object (payload_receiver_impl);

      CORBA::Object_var object = root_poa->id_to_reference (id.in ());

      Test::Payload_Receiver_var payload_receiver =
        Test::Payload_Receiver::_narrow (object.in ());

      CORBA::String_var ior =
        orb->object_to_string (payload_receiver.in ());

      // If the ior_output_file exists, output the ior to it
      FILE *output_file= ACE_OS::fopen (ior_output_file, "w");
      if (output_file == 0)
        ACE_ERROR_RETURN ((LM_ERROR,
                           "Cannot open output file for writing IOR: %s",
                           ior_output_file),
                              1);
      ACE_OS::fprintf (output_file, "%s", ior.in ());
      ACE_OS::fclose (output_file);

      poa_manager->activate ();

      orb->run ();

      if (payload_receiver_impl->get_count () != 20)
        {
          ACE_ERROR ((LM_ERROR,
                      "ERROR: %d is not the correct "
                      "number of calls\n",
                      payload_receiver_impl->get_count ()));
          ++status;
        }

      root_poa->destroy (1, 1);

      orb->destroy ();
    }
  catch (const CORBA::Exception& ex)
    {
      ex._tao_print_exception ("Exception caught:");
      ++status;
    }

  return status;
}
