#! /bin/ksh
##############################################################
#	Nom    : acg_ext_cpu.sh
#	Auteur : ACGCENTER -
#
#       But    :extraction mem et cpu
#	         Code retour = 0 si OK, -1 sinon
#
#############################################################
# Affichage de sortie
#
#       xxx = tauxcpu d occupation global + 100
#

###############################################################
# Variables globale

	#. /etc/ACGVISION.sh
#DAT="/home/remi/NetBeansProjects/AgentSOAP/dat"
########################################

#----------------------------------------------------------------
# Traitement du type unix

	export OS=`uname`
	export ind=1
#----------------------------------------------------------------


case $OS in
HP-UX)
	exit -1 ;;
AIX)
        mem_tot=`lsattr -El sys0 | grep realmem |awk '{print $2}'`
        mem_free=`vmstat | tail -n1 | awk '{print $4}'`
        let mem_free=mem_free*4
        let tauxmem=mem_tot-mem_free
        let tauxmem=tauxmem*100/mem_tot
        ;;

Linux)
        mem_tot=`grep "MemTotal" /proc/meminfo|awk '{print $2}'`
        mem_cached=`grep "Cached:" /proc/meminfo|grep -v "SwapCached:" |awk '{print $2}'`
        mem_free=`grep "MemFree" /proc/meminfo|awk '{print $2}'`
        let tauxmem=mem_tot-mem_cached
        let tauxmem=tauxmem-mem_free
        let tauxmem=tauxmem*100/mem_tot
	;;

SCO|SCO_SV)
	stat=`vmstat | tail -n1 `
        mem_tot=`sar -r 1 1 | tail -n1 | awk '{print $4}'`
        mem_free=`sar -r 1 1 | tail -n1 | awk '{print $2}'`
        let tauxmem=mem_tot-mem_free
        let tauxmem=tauxmem*100/mem_tot
	;;
Solaris)
	exit -1 ;;

*)
	exit -1 ;;
    esac
exit $tauxmem

##############################################################
# Fin de la procedure
