/*
 * This file is part of ACGVision, SaaS system-monitoring software
 * Copyright (C) 2009 ACGCenter
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.acgvision.agent.action;

import com.acgvision.core.ws.*;
import java.util.Date;
import java.util.GregorianCalendar;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import static org.junit.Assert.*;

/**
 *
 * @author Rémi Debay <remi.debay@acgcenter.com>
 */
public class ServiceActionsTest {

    public ServiceActionsTest() {
    }

    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    /**
     * Test of validate method, of class ServiceActions.
     */
    @Test
    public void testValidate() {
        System.out.println("validate");
        Production production = null;

        boolean expResult = false;
        System.out.println("test null production");
        boolean result = ServiceActions.validate(production, null);
        assertEquals(expResult, result);

        
        System.out.println("test null date");
        result = ServiceActions.validate(production, new Date());
        assertTrue("La prod devrait etre autorisé", result);

        Period d = new Period();
        d.setYear(-1);
        d.setMonth(-1);
        d.setDay(-1);
        d.setHour(8);
        d.setMinute(00);

        Period f = new Period();
        f.setYear(-1);
        f.setMonth(-1);
        f.setDay(-1);
        f.setHour(18);
        f.setMinute(00);

        production = new Production();
        production.setStarting(d);
        production.setEndding(f);

        GregorianCalendar gc = new GregorianCalendar();
  

      gc.set(GregorianCalendar.HOUR_OF_DAY, 11);
        result = ServiceActions.validate(production, gc.getTime());
        System.out.println("test working hours");
        assertTrue("La prod devrait etre autorisée", result);
        gc.set(GregorianCalendar.HOUR_OF_DAY, 23);
        System.out.println("test non-working hours");
        result = ServiceActions.validate(production, gc.getTime());
        assertFalse("La prod devrait etre interdite", result);

        //prod de nuit
        production.setStarting(f);
        production.setEndding(d);
              gc.set(GregorianCalendar.HOUR_OF_DAY, 11);
        result = ServiceActions.validate(production, gc.getTime());
        System.out.println("test working hours");
        assertFalse("La prod devrait etre interdite", result);
        gc.set(GregorianCalendar.HOUR_OF_DAY, 23);
        System.out.println("test non-working hours");
        result = ServiceActions.validate(production, gc.getTime());
        assertTrue("La prod devrait etre autorisée", result);
    }

    @Test
    public void testNullCompare() {
        assertFalse(ServiceActions.compare(null, (Date)null));
        assertFalse( ServiceActions.compare(null, (Period)null));
     }

        @Test
    public void testCompare() {
        Period p1 = new Period();
        Period p2= new Period();
        p1.setDay(00);
        p2.setDay(02);
        assertTrue(ServiceActions.compare(p1, p2));
        assertFalse(ServiceActions.compare(p2, p1));
        
        p1.setMinute(00);
        p2.setMinute(00);
        assertTrue(ServiceActions.compare(p1, p2));
        assertFalse(ServiceActions.compare(p2, p1));
        assertFalse(ServiceActions.compare(p1, p1));
    }



    /**
     * Test of getNextTime method, of class ServiceActions.
     */
    @Test
    public void testGetNextTimeWithNullValues() {
        System.out.println("getNextTime with null values");
        Period p = new Period();
        long result = ServiceActions.getNextTime(p, null);
        assertEquals(result, -1);
        result = ServiceActions.getNextTime(null, new GregorianCalendar());
        assertEquals(result, -1);
        result = ServiceActions.getNextTime(null,null);
        assertEquals(result, -1);
    }

    private Period set(Period p ,int Y, int M ,int D, int h,int m){
        p.setYear(Y);
        p.setMonth(M);
        p.setDay(D);
        p.setHour(h);
        p.setMinute(m);
        return p;
    }

    @Test
    public void testGetNextTimeWithNonNullValues() {
        System.out.println("getNextTime with null values");
        Period p = new Period();
        long result = ServiceActions.getNextTime(p, null);
        //on teste un masque à 1 minute
        p = set(p,-1,-1,-1,-1,5);

        GregorianCalendar lastControl= new GregorianCalendar();//maintenant
        System.out.println("Tests de dates avec masque + ajout");
        lastControl.set(2001, GregorianCalendar.DECEMBER, 12, 12, 12);

        System.out.println("avant      = "+lastControl.getTimeInMillis());
        result = ServiceActions.getNextTime(p, lastControl);
        System.out.println(lastControl.getTime().toString());
        System.out.println("Maintenant = " + lastControl.getTimeInMillis());
        System.out.println("Resultat   = " + result);
        assertTrue("Invalid null result",result>0);
        assertTrue("Invalid value, should be in the future", result>lastControl.getTimeInMillis());
        GregorianCalendar expected= (GregorianCalendar) lastControl.clone();//maintenant
        expected.add(GregorianCalendar.MINUTE, p.getMinute());
        assertEquals("Invalid value, should be in one minute", result ,expected.getTimeInMillis());
        p = set(p,-1,-1,-1,5,5);
        expected= (GregorianCalendar) lastControl.clone();//maintenant
        expected.set(GregorianCalendar.MINUTE,p.getMinute());
        expected.add(GregorianCalendar.HOUR_OF_DAY,p.getHour());
        result = ServiceActions.getNextTime(p, lastControl);
        assertEquals("Invalid value, should be in one minute", result ,expected.getTimeInMillis());
        p = set(p,-1,-1,5,5,5);
        expected= (GregorianCalendar) lastControl.clone();//maintenant
        expected.set(GregorianCalendar.MINUTE,p.getMinute());
        expected.set(GregorianCalendar.HOUR_OF_DAY,p.getHour());
        expected.add(GregorianCalendar.DAY_OF_MONTH,p.getDay());
        result = ServiceActions.getNextTime(p, lastControl);
        assertEquals("Invalid value, should be in one minute", result ,expected.getTimeInMillis());
        p = set(p,-1,5,5,5,5);
        expected= (GregorianCalendar) lastControl.clone();//maintenant
        expected.set(GregorianCalendar.MINUTE,p.getMinute());
        expected.set(GregorianCalendar.HOUR_OF_DAY,p.getHour());
        expected.set(GregorianCalendar.DAY_OF_MONTH,p.getDay());
        expected.add(GregorianCalendar.MONTH,p.getMonth());
        result = ServiceActions.getNextTime(p, lastControl);
        assertEquals("Invalid value, should be in one minute", result ,expected.getTimeInMillis());
        p = set(p,5,5,5,5,5);
        expected= (GregorianCalendar) lastControl.clone();//maintenant
        expected.set(GregorianCalendar.MINUTE,p.getMinute());
        System.out.println("Expected   = " +expected.getTime().toString());
        expected.set(GregorianCalendar.HOUR_OF_DAY,p.getHour());
        System.out.println("Expected   = " +expected.getTime().toString());
        expected.set(GregorianCalendar.DAY_OF_MONTH,p.getDay());
        System.out.println("Expected   = " +expected.getTime().toString());
        expected.set(GregorianCalendar.MONTH,p.getMonth());
        System.out.println("Expected   = " +expected.getTime().toString());
        expected.add(GregorianCalendar.YEAR,p.getYear());
        System.out.println("Expected   = " +expected.getTime().toString());
        result = ServiceActions.getNextTime(p, lastControl);
        System.out.println("Maintenant = " + lastControl.getTimeInMillis());
        System.out.println("Resultat   = " + result);
        System.out.println("Resultat   = " + new Date(result));
        System.out.println("Expected   = " +expected.getTime().toString());
        assertEquals("Invalid value, should be in one minute", result ,expected.getTimeInMillis());

        
        lastControl.set(2001, GregorianCalendar.JANUARY, 1, 1, 1);
        p = set(p,-1,-1,-1,-1,5);
        System.out.println("avant      = "+lastControl.getTimeInMillis());
        result = ServiceActions.getNextTime(p, lastControl);
        System.out.println(lastControl.getTime().toString());
        System.out.println("Maintenant = " + lastControl.getTimeInMillis());
        System.out.println("Resultat   = " + result);
        assertTrue("Invalid null result",result>0);
        assertTrue("Invalid value, should be in the future", result>lastControl.getTimeInMillis());
        expected= (GregorianCalendar) lastControl.clone();//maintenant
        expected.add(GregorianCalendar.MINUTE, p.getMinute());
        assertEquals("Invalid value, should be in one minute", result ,expected.getTimeInMillis());
        p = set(p,-1,-1,-1,5,5);
        expected= (GregorianCalendar) lastControl.clone();//maintenant
        expected.set(GregorianCalendar.MINUTE,p.getMinute());
        //expected.add(GregorianCalendar.HOUR_OF_DAY,p.getHour());
        result = ServiceActions.getNextTime(p, lastControl);
        assertEquals("Invalid value, should be in one minute", result ,expected.getTimeInMillis());
        p = set(p,-1,-1,5,5,5);
        expected= (GregorianCalendar) lastControl.clone();//maintenant
        expected.set(GregorianCalendar.MINUTE,p.getMinute());
        expected.set(GregorianCalendar.HOUR_OF_DAY,p.getHour());
        //expected.add(GregorianCalendar.DAY_OF_MONTH,p.getDay());
        result = ServiceActions.getNextTime(p, lastControl);
        assertEquals("Invalid value, should be in one minute", result ,expected.getTimeInMillis());
        p = set(p,-1,5,5,5,5);
        expected= (GregorianCalendar) lastControl.clone();//maintenant
        expected.set(GregorianCalendar.MINUTE,p.getMinute());
        expected.set(GregorianCalendar.HOUR_OF_DAY,p.getHour());
        expected.set(GregorianCalendar.DAY_OF_MONTH,p.getDay());
        //expected.add(GregorianCalendar.MONTH,p.getMonth());
        result = ServiceActions.getNextTime(p, lastControl);
        assertEquals("Invalid value, should be in one minute", result ,expected.getTimeInMillis());
        p = set(p,5,5,5,5,5);
        expected= (GregorianCalendar) lastControl.clone();//maintenant
        expected.set(GregorianCalendar.MINUTE,p.getMinute());
        System.out.println("Expected   = " +expected.getTime().toString());
        expected.set(GregorianCalendar.HOUR_OF_DAY,p.getHour());
        System.out.println("Expected   = " +expected.getTime().toString());
        expected.set(GregorianCalendar.DAY_OF_MONTH,p.getDay());
        System.out.println("Expected   = " +expected.getTime().toString());
        expected.set(GregorianCalendar.MONTH,p.getMonth());
        System.out.println("Expected   = " +expected.getTime().toString());
        //expected.add(GregorianCalendar.YEAR,p.getYear());
        System.out.println("Expected   = " +expected.getTime().toString());
        result = ServiceActions.getNextTime(p, lastControl);
        System.out.println("Maintenant = " + lastControl.getTimeInMillis());
        System.out.println("Resultat   = " + result);
        System.out.println("Resultat   = " + new Date(result));
        System.out.println("Expected   = " +expected.getTime().toString());
        assertEquals("Invalid value, should be in one minute", result ,expected.getTimeInMillis());

    }

}