;;;***************************************************************
;;;An ACL2 Library of Floating Point Arithmetic

;;;David M. Russinoff
;;;Advanced Micro Devices, Inc.
;;;February, 1998
;;;***************************************************************

(in-package "ACL2")

(include-book "trunc")
(include-book "log")


(local
 (defthm bt-hack
    (implies (and (integerp e)
		  (integerp n)
		  (integerp k)
		  (= e (1- n)))
	     (= (expt 2 (- (1- k) e))
		(expt 2 (- k n))))
  :rule-classes ()))

(local
 (defthm bits-trunc-1
    (implies (and (integerp x) (> x 0)
		  (integerp n) (> n k)
		  (integerp k) (> k 0)
		  (= (expo x) (1- n)))
	     (= (trunc x k)
		(* (fl (/ x (expt 2 (- n k))))
		   (expt 2 (- n k)))))
  :rule-classes ()
  :hints (("goal" :in-theory (enable trunc-rewrite))
	  ("subgoal 1" :use ((:instance bt-hack (e (expo x))))))))

(local
 (defthm bt-hack-2
    (implies (and (integerp n) (integerp k))
	     (not (and (<= (expt 2 n) x) (< x (expt 2 (+ 1 -1 n))))))
  :rule-classes ()))

(local
(defthm bt-hack-3
    (implies (and (integerp n) (integerp x)
		  (equal e (+ -1 n))
		  (equal (rem x (expt 2 n)) x))
	     (= (rem x (expt 2 (+ 1 e)))
		x))
  :rule-classes ()))

(local
(defthm bits-trunc-2-local
    (implies (and (integerp x) (> x 0)
		  (integerp n) (> n k)
		  (integerp k) (> k 0)
		  (= (expo x) (1- n)))
	     (= (trunc x k)
		(* (bits x (1- n) (- n k))
		   (expt 2 (- n k)))))
  :rule-classes ()
  :hints (("goal" :use ((:instance bits-trunc-1)
			(:instance rem< (m x) (n (expt 2 n)))
			(:instance expo-upper-bound)))
	  ("subgoal 2'''" :use ((:instance bt-hack-2)))
	  ("subgoal 1'6'" :use ((:instance bt-hack-3 (e (expo x))))))))

(local
(defthm crap444
    (implies (integerp n)
             (equal (* 2 (expt 2 (+ -1 n)))
                    (expt 2 n)))))

(local (in-theory (disable crap444)))

(local
(defthm bits-trunc-3
    (implies (and (integerp x) (> x 0)
		  (integerp n) (> n k)
		  (integerp k) (> k 0)
		  (= (expo x) (1- n)))
	     (= (trunc x k)
		(logand x (- (expt 2 n) (expt 2 (- n k))))))
  :rule-classes ()
  :hints (("goal" :use ((:instance bits-trunc-2-local)
			(:instance and-bits-c (k (- n k)))))
          ("Subgoal 1'5'" :use (:instance crap444)))))

(local
(defthm hack-78
    (implies (and (integerp n)
		  (integerp k)
		  (> k 0)
		  (>= n k))
	     (integerp (+ (expt 2 n)
			  (* -1 (expt 2 (+ n (* -1 k)))))))
  :hints (("goal" :in-theory (disable expt integerp-expt-type)
		  :use ((:instance integerp-expt-type (n (- n k)))
			(:instance integerp-expt-type))))))

(local
(defthm hack-79
    (implies (and (integerp n)
		  (integerp m)
		  (>= m n))
	     (integerp (+ -1 (expt 2 (+ m (* -1 n))))))
  :hints (("goal" :in-theory (disable expt integerp-expt-type)
		  :use ((:instance integerp-expt-type (n (- m n))))))))

(local
(defthm hack-80
    (implies (and (integerp n)
		  (integerp m)
		  (>= m n))
	     (not (< (+ -1 (expt 2 (+ m (* -1 n)))) 0)))
  :hints (("goal" :in-theory (disable expt-pos hack-79)
		  :use ((:instance expt-pos (x (- m n)))
			(:instance hack-79))))))

(local
(defthm rem-2m-2n-k-1
    (implies (and (integerp m) (>= m n)
		  (integerp n) (> n k)
		  (integerp k) (> k 0))
	     (= (rem (- (expt 2 m) (expt 2 (- n k)))
		     (expt 2 n))
		(rem (- (expt 2 n) (expt 2 (- n k)))
		     (expt 2 n))))
  :rule-classes ()
  :hints (("goal" :use ((:instance rem+
				   (m (- (expt 2 n) (expt 2 (- n k))))
				   (n (expt 2 n))
				   (a (1- (expt 2 (- m n)))))
			(:instance expt-monotone (n (- n k)) (m n)))))))

(local
(defthm rem-2m-2n-k-2
    (implies (and (integerp n) (> n k)
		  (integerp k) (> k 0))
	     (= (rem (- (expt 2 n) (expt 2 (- n k)))
		     (expt 2 n))
		(- (expt 2 n) (expt 2 (- n k)))))
  :rule-classes ()
  :hints (("goal" :use ((:instance rem< (m (- (expt 2 n) (expt 2 (- n k)))) (n (expt 2 n)))
			(:instance expt-monotone (n (- n k)) (m n))))
	  ("subgoal 1" :in-theory (disable expt-pos)
		       :use ((:instance expt-pos (x (- n k))))))))

(local
(defthm rem-2m-2n-k
    (implies (and (integerp m) (>= m n)
		  (integerp n) (> n k)
		  (integerp k) (> k 0))
	     (= (rem (- (expt 2 m) (expt 2 (- n k)))
		     (expt 2 n))
		(- (expt 2 n) (expt 2 (- n k)))))
  :rule-classes ()
  :hints (("goal" :use ((:instance rem-2m-2n-k-1)
			(:instance rem-2m-2n-k-2))))))

(local
(defthm bits-trunc-4
    (implies (and (integerp x) (> x 0)
		  (integerp n) (> n k)
		  (integerp k) (> k 0)
		  (>= x (expt 2 (1- n)))
		  (< x (expt 2 n)))
	     (= (trunc x k)
		(logand x (- (expt 2 n) (expt 2 (- n k))))))
  :rule-classes ()
  :hints (("goal" :use ((:instance bits-trunc-3)
			(:instance expo-unique (n (1- n))))))))

(local
(defthm bits-trunc-5
    (implies (and (integerp x) (> x 0)
		  (integerp m) (>= m n)
		  (integerp n) (> n k)
		  (integerp k) (> k 0)
		  (>= x (expt 2 (1- n)))
		  (< x (expt 2 n)))
	     (= (trunc x k)
		(logand x (rem (- (expt 2 m) (expt 2 (- n k))) (expt 2 n)))))
  :rule-classes ()
  :hints (("goal" :use ((:instance bits-trunc-4)
			(:instance rem-2m-2n-k))))))

(local
(defthm hack-81
    (implies (and (integerp n)
		  (integerp m)
		  (>= m 0)
		  (integerp k)
		  (> k 0)
		  (>= n k))
	     (integerp (+ (expt 2 m)
			  (* -1 (expt 2 (+ n (* -1 k)))))))
  :hints (("goal" :in-theory (disable expt integerp-expt-type)
		  :use ((:instance integerp-expt-type (n (- n k)))
			(:instance integerp-expt-type (n m))
			(:instance integerp-expt-type))))))

(local
(defthm hack-82
    (implies (and (integerp x)
		  (integerp n)
		  (< x (expt 2 n)))
	     (not (<= (* 2 (expt 2 (+ -1 n))) x)))
  :rule-classes ()))

(defthm bits-trunc
    (implies (and (integerp x) (> x 0)
		  (integerp m) (>= m n)
		  (integerp n) (> n k)
		  (integerp k) (> k 0)
		  (>= x (expt 2 (1- n)))
		  (< x (expt 2 n)))
	     (= (trunc x k)
		(logand x (- (expt 2 m) (expt 2 (- n k))))))
  :rule-classes ()
  :hints (("goal" :use ((:instance bits-trunc-5)
			(:instance expt-monotone (n (- n k)))
			(:instance and-dist-d (y (- (expt 2 m) (expt 2 (- n k)))))))
          ("Goal'''" :in-theory (enable crap444))  ;; RBK:
          ))
;;	  ("subgoal 1" :use ((:instance hack-82)))))  RBK:


(defthm bits-trunc-2
    (implies (and (integerp x) (> x 0)
		  (integerp n) (> n k)
		  (integerp k) (> k 0)
		  (= n (1+ (expo x))))
	     (= (trunc x k)
		(* (expt 2 (- n k))
		   (bits x (1- n) (- n k)))))
  :rule-classes ()
  :hints (("Goal" :in-theory (enable natp)
		  :use ((:instance bits-trunc (m n))
			(:instance logand-expt-3 (k (- n k)))
			expo-lower-bound
			expo-upper-bound))))





















