(in-package "ACL2")

(include-book "ground-zero") ;?
(include-book "negative-syntaxp")
(local (include-book "bitn-proofs"))

(include-book "rtl")

(DEFUN BVECP (X K)
  (AND (INTEGERP X)
       (>= X 0)
       (< X (EXPT 2 K))))

(defun fl (x)
  (floor x 1))
(in-theory (disable fl))

(defun bits (x i j)
  (if (or (not (integerp i))
          (not (integerp j)))
      0
  (fl (/ (mod x (expt 2 (1+ i))) (expt 2 j)))))
(in-theory (disable bits))

(defun bitn (x n)
  (bits x n n))
(in-theory (disable bitn))

(defthm bitn-nonnegative-integer-type
  (and (<= 0 (bitn x n))
       (integerp (bitn x n)))
  :rule-classes (:type-prescription))

;this rule is no better than bitn-nonnegative-integer-type and might be worse
(in-theory (disable (:type-prescription bitn)))

(defthm bitn-natp
  (natp (bitn x n)))

(defthm bitn-upper-bound
  (<= (bitn x n) 1))

(defthm bitn-upper-bound-linear
  (<= (bitn x n) 1)
  :rule-classes ((:LINEAR :TRIGGER-TERMS ((bitn x n)))))

;include separate cases?
(defthm bitn-minus
  (implies (and (syntaxp (negative-syntaxp x))
                (case-split (rationalp x)) ;gen?
                (case-split (integerp n))
                )
           (equal (bitn x n)
                  (if (integerp (/ x (expt 2 (+ 1 n))))
                      (- (bitn (- x) n))
                    (if (integerp (/ x (expt 2 n)))
                        (- 2 (bitn (- x) n))
                      (- 1 (bitn (- x) n)))))))
;1 rewrite to odd?
(defthm bitn-0-rewrite-to-even
  (implies (integerp x)
           (equal (equal (bitn x 0) 0)
                  (integerp (* 1/2 x)))))

;this one should remain last?
(theory-invariant (incompatible (:rewrite bits-n-n-rewrite-to-bitn)
                                (:definition bitn)
                                )
                  :key bitn-and-bits-n-n-shouldnt-alternate)

(defthm bits-n-n-rewrite-to-bitn
  (equal (BITS X n n)
         (bitn x n)))
(in-theory (disable bits-n-n-rewrite-to-bitn))

(defthm bitn-0-1
  (or (equal (bitn x n) 0)
      (equal (bitn x n) 1))
  :rule-classes nil)


;my strategey with the rules below is to rewrite prefer (not (equal (bitn x n) 0)) over (equal (bitn x n) 1)
;this allows subsumption to ...

;bad to have both?
(defthm bitn-not-0-means-1
  (equal (not (equal (bitn x n) 0))
         (equal (bitn x n) 1)))

(defthm bitn-not-1-means-0
  (equal (not (equal (bitn x n) 1))
         (equal (bitn x n) 0)))

;these are bad rules?
(in-theory (disable bitn-not-1-means-0 bitn-not-0-means-1))

(defthm bitn-bitn
  (equal (bitn (bitn x n) 0)
         (bitn x n)))

(defthm bitn-known-not-0-replace-with-1
  (implies (not (equal (bitn x n) 0)) ; backchain-limit?
           (equal (bitn x n)
                  1))
  :rule-classes ((:rewrite :backchain-limit-lst (1)))
  )

;needed?
(defthm bitn->-0
  (equal (< 0 (bitn x n))
         (not (equal 0 (bitn x n)))))

(defthm bitn-<-1
  (equal (< (BITN X n) 1)
         (equal (BITN X n) 0)))

;useful if bitn-upper-bound and bitn-upper-bound-2 are disabled
(defthm bitn-not->-1
  (implies (and (syntaxp (quotep k))
                (<= 1 k))
           (equal (< k (bitn x n))
                  nil)))


;useful if bitn-upper-bound and bitn-upper-bound-2 are disabled
(defthm bitn-<=-1
  (implies (and (syntaxp (quotep k))
                (< 1 k))
           (equal (< (bitN x n) k)
                  t)))

(defthm bitn-def-mod
  (implies (case-split (integerp n))
           (equal (bitn x n)
                  (mod (fl (/ x (expt 2 n)))
                       2))))
(in-theory (disable bitn-def-mod))

;make bit-not, bit-and, etc.
(defun not-eric (x)
  (if (equal x 0)
      1
    0))



(defthm bitn-drop-crucial-bit-and-flip-result
  (implies (and (case-split (rationalp x))
                (case-split (integerp n)) ;drop?
                )
           (and (equal (bitn (+ (expt 2 n) x) n)
                       (not-eric (bitn x n)))
                (equal (bitn (+ x (expt 2 n)) n)
                       (not-eric (bitn x n)))))
)

(defthm bitn-drop-crucial-bit-and-flip-result-alt-gen
  (implies (and (syntaxp (and (quotep j) 
                              (< (cadr j) (expt 2 (+ 1 (cadr n)))) ;bitn-sum-lowbits does most of the work
                              (>= (cadr j) (expt 2 (cadr n)))))
                (rationalp j)
                (rationalp x)
                (integerp n)
                )
           (equal (bitn (+ j x) n)
                  (not-eric (bitn (+ (- j (expt 2 n)) x) n))))
)

;for negative constants j
;might be slow if the negative constant has a large absolute value
;make a negative version of bitn-sum-lowbits
(defthm bitn-add-crucial-bit-and-flip-result
  (implies (and (syntaxp (and (quotep j) 
                              (quotep n)
                              (< (cadr j) 0)))
                (rationalp j)
                (rationalp x)
                (integerp n)
                )
           (equal (bitn (+ j x) n)
                  (not-eric (bitn (+ (+ j (expt 2 n)) x) n))))
)



(defthm bitn-equal-to-silly-value
  (implies (and (syntaxp (quotep k))
                (not (or (equal 0 k) (equal 1 k)))
                )
           (equal (equal k (bitn x n))
                  nil)))
                         

;(local (in-theory (disable bits-rewrite-to-bits)))


(defthm bitn-split-around-zero
  (implies (and (<= (- (expt 2 n)) x)
                (< x (expt 2 n))
                (rationalp x)
                (integerp n)
                )
           (equal (equal (bitn x n) 0)
                  (<= 0 x)))

  )


;drop silly hyps like: (<= -128 (BITN (*::EX1_SRC_RECIP) 24))
(defthm bitn-drop-silly-bound
  (implies (and (syntaxp (quotep k))
                (<= k 0)
                )
  (equal (< (bitn x n) k)
         nil)))

(defthm bitn-drop-silly-bound-2
  (implies (and (syntaxp (quotep k))
                (< k 0)
                )
  (equal (< k (bitn x n))
         t)))


(defthm bitn-even-means-0
  (equal (INTEGERP (* 1/2 (BITN x n)))
         (equal (bitn x n) 0)))

;(in-theory (disable bits-rewrite-to-bits))

;new - export disabled?
;back-chain-limit?
;new - export disabled?
(defthm bitn-too-small
  (implies (and (< x (expt 2 n))
                (<= 0 x)
                (case-split (rationalp x))
                (case-split (integerp n))
                )
           (equal (bitn x n)
                  0))
  :rule-classes ((:rewrite :backchain-limit-lst (1 nil nil nil)))
  )

(defthm bitn-normal-form
  (equal (equal (bitn x n) 1)
         (not (equal (bitn x n) 0))))


(defthm bitn-of-non-rational
  (implies (not (rationalp x))
           (equal (bitn x n)
                  0)))

(defthm bitn-bvecp
  (implies (and (<= 1 k)
                (case-split (integerp k)))
           (bvecp (bitn x n) k)))

(defthm bitn-times-fraction-integerp 
  (implies (and (not (integerp k))
                (case-split (acl2-numberp k))
                )
           (equal (INTEGERP (* k (BITN x n)))
                  (equal (BITN x n) 0))))



(defthm bitn-in-product-split-cases
  (and (implies (case-split (acl2-numberp k))
                (equal (* (bitn x n) k)
                       (if (equal (bitn x n) 0)
                           0
                         k)))
       (implies (case-split (acl2-numberp k))
                (equal (* k (bitn x n))
                       (if (equal (bitn x n) 0)
                           0
                         k)))))
;(in-theory (disable bitn-in-product-split-cases))

(defthm bitn-in-sum-split-cases
  (and (implies (case-split (acl2-numberp k))
                (equal (+ k (bitn x n))
                       (if (equal (bitn x n) 0)
                           k
                         (+ k 1))))
  
       (implies (case-split (acl2-numberp k))
                (equal (+ (bitn x n) k)
                       (if (equal (bitn x n) 0)
                           k
                         (+ k 1))))))
;(in-theory (disable bitn-in-sum-split-cases))

(defthm bitn-0
  (equal (bitn 0 k) 0))
