(in-package "ACL2")

;(include-book "include-book-macros")
(include-book "power2p")
(include-book "arith2")
(include-book "integerp")
(include-book "expo")
(include-book "expt")
;(include-book "type")

;does this book disable expt?
;there's a distinction between expt and expt-2 rules

;add expt-monotone rules

;todo: 
; make consistent names
;  expt vs. expt2   


;generalize?  use arith books?
;this event is copied in irepsproofs.lisp
(defthm expt-2-positive-rational-type
  (and (rationalp (expt 2 i))
       (< 0 (expt 2 i)))
  :rule-classes ((:type-prescription :typed-term (expt 2 i))))

;generalize these like a14?
(defthm expt-2-type
  (implies (<= 0 i)
           (and (integerp (expt 2 i))
                (< 0 (expt 2 i))))
  :rule-classes (:type-prescription))

(defthm expt-2-type-linear
  (implies (<= 0 i)
           (<= 1 (expt 2 i)))
  :rule-classes ((:linear :trigger-terms ((expt 2 i)))))

;remove this!
(local (include-book "fp2"))

(in-theory (disable expt))

(defthm expt-0-i
  (implies (and (case-split (integerp i))
                (case-split (not (equal 0 i))))
           (equal (expt 0 i)
                  0))
  :hints (("Goal" :in-theory (enable expt)))
)

(defthm expt-r-0
  (equal (expt r 0)
         1)
  :hints (("Goal" :in-theory (enable expt)))
)

(defthm a15
  (implies (and (rationalp i)
                (not (equal i 0))
                (integerp j1)
                (integerp j2))
           (and (equal (* (expt i j1) (expt i j2))
                       (expt i (+ j1 j2)))
                (equal (* (expt i j1) (* (expt i j2) x))
                       (* (expt i (+ j1 j2)) x)))))
(in-theory (disable a15))

(in-theory (disable expt-split))

;We could disable this if it causes problems (but it seems okay).
;should always use case-split n hyps that say exponents are integers
(defthm expt-with-i-non-integer
  (implies (not (integerp i))
           (equal (expt r i)
                  1))
  :hints (("Goal" :in-theory (enable expt)))
)

;loops with expt-inverse. which is better?
;i'd rather have the inverting outside expt since most rules don't look inside expt???
;disable this since have -gen version below
(defthm expt-pull-negation-out-of-power-helper
  (equal (expt r (* -1 i))
         (/ (expt r i)))
  :otf-flg t
  :hints (("Goal" :cases ((integerp i) (and (not (integerp i)) (acl2-numberp i)))
           :in-theory (enable expt)))
)

(in-theory (disable expt-pull-negation-out-of-power-helper)) ;this gets enabled somewhere (WHY?)

;make the opposite of this, disable, and add to theory-invariant table




;(local (in-theory (disable integerp-expt-type))) ; the above is better?

;(in-theory (disable expo)) ;move up?

(local (in-theory (disable expt)))

;when you disable either of the two rules below, you might have to disable expt-compare?
;took these rules out of :rewrite since we have expt-compare?
;are these bad :linear rules because they have free vars?
(defthm expt-monotone-1
    (implies (and (integerp n)
		  (integerp k)
		  (>= k 0))
	     (<= (expt 2 n) (expt 2 (+ n k))))
    :hints (("Goal" :in-theory (set-difference-theories
                                (enable expt-split)
                                '(a15))))
  :rule-classes ())


(defthm expt-monotone
    (implies (and (integerp n)
		  (integerp m)
		  (<= n m))
	     (<= (expt 2 n) (expt 2 m)))
  :rule-classes ()
  :hints (("Goal" :use ((:instance expt-monotone-1 (k (- m n)))))))




(defthm expt-strong-monotone-1
    (implies (and (integerp n)
		  (integerp k)
		  (> k 0))
	     (< (expt 2 n) (expt 2 (+ n k))))
        :hints (("Goal" :in-theory (set-difference-theories
                                (enable expt-split)
                                '(a15))))
  :rule-classes ())

(defthm expt-strong-monotone-2
    (implies (and (integerp n)
		  (integerp m)
		  (< n m))
	     (< (expt 2 n) (expt 2 m)))
  :rule-classes ()
  :hints (("Goal" :use ((:instance expt-strong-monotone-1 (k (- m n)))))))

(defthm expt-strong-monotone
    (implies (and (integerp n)
		  (integerp m))
	     (iff (< n m) (< (expt 2 n) (expt 2 m))))
  :rule-classes ()
  :hints (("Goal" :use ((:instance expt-strong-monotone-2)
			(:instance expt-strong-monotone-2 (n m) (m n))))))

(defthm expt-weak-monotone
    (implies (and (integerp n)
		  (integerp m))
	     (iff (<= n m)
		  (<= (expt 2 n) (expt 2 m))))
  :rule-classes ()
  :hints (("Goal" :use (expt-strong-monotone
			(:instance expt-strong-monotone (m n) (n m))))))

(DEFTHM EXPT-MONOTONE-linear-eric
  (IMPLIES (AND (<= i j)
                (case-split (INTEGERP i))
                (case-split (INTEGERP j))
                )
           (<= (EXPT 2 i) (EXPT 2 j)))
  :RULE-CLASSES nil
;(;:rewrite 
 ;(:linear :trigger-terms ((expt 2 i))))
  :HINTS
  (("Goal" :USE
    ((:INSTANCE EXPT-MONOTONE-1 (n i) (K (- j i)))))))

(DEFTHM EXPT-strong-MONOTONE-linear-eric
  (IMPLIES (AND  (< i j)
                 (case-split (INTEGERP i))
                 (case-split (INTEGERP j)))
           (< (EXPT 2 i) (EXPT 2 j)))
  :RULE-CLASSES NIL
  ;(;:rewrite 
   ;              (:linear :trigger-terms ((expt 2 i))))
  :HINTS
  (("Goal" :USE
    ((:INSTANCE EXPT-strong-monotone (n i) (M j))))))



;rename monotone?
(encapsulate
 ()
 (local
  (defthm fw
    (implies (and (integerp i1)
                  (integerp i2))
             (implies (< (EXPT 2 i1) (expt 2 i2))
                      (< i1 i2)))
    :hints (("Goal" :use (:instance expt-strong-monotone (n i2) (m i1))))))


 (local
  (defthm bk
    (implies (and (integerp i1)
                  (integerp i2))
             (implies (< i1 i2)
                      (< (EXPT 2 i1) (expt 2 i2))))
    :hints (("Goal" :use (:instance expt-strong-monotone (n i1) (m i2))))
    ))
             
 (defthm expt-compare-old
   (implies (and (case-split (integerp i1))
                 (case-split (integerp i2)))
            (equal (< (EXPT 2 i1) (expt 2 i2))
                   (< i1 i2)))
   :hints (("Goal" :in-theory (disable bk fw)
            :use (bk fw)))))

#|
(defthm expt-next
  (implies (and (integerp i1)
                (integerp i2)
                (< (expt 2 i1) (expt 2 i2)))
           (<= (expt 2 i1) (expt 2 (+ -1 i2)))))

(in-theory (disable expt-next))
|#

(local (include-book "expt"))








;could gen? move hyps to concl?
(defthm expt-even
  (implies (and (case-split (integerp i))
                (< 0 i))
           (INTEGERP (* 1/2 (EXPT 2 i))))
  :hints (("Goal" :in-theory (enable expt)))
)


;generalize rules like this with a power2-syntaxp (not power2p!) ?
;make conclusion an equality?
(defthm expt-quotient-integerp
  (implies (and (case-split (integerp i))
                (case-split (integerp j))
                (<= j i))
           (integerp (* (expt 2 i) (/ (expt 2 j)))))
  :rule-classes (:rewrite :type-prescription)
  :hints (("Goal" :in-theory (set-difference-theories
                              (enable expt-split
                                      expt-pull-negation-out-of-power-helper
)
                              '( expt-2-type a15))
           :use (:instance expt-2-type (i (- i j))))))

(defthm expt-quotient-integerp-alt
  (implies (and (case-split (integerp i))
                (case-split (integerp j))
                (<= j i))
           (integerp (* (/ (expt 2 j)) (expt 2 i))))
  :rule-classes (:rewrite :type-prescription)
  :hints (("Goal" :in-theory (set-difference-theories
                              (enable expt-split
                                      expt-pull-negation-out-of-power-helper
)
                              '(expt-quotient-integerp
                                expt-2-type 
                                a15))
           :use (:instance expt-2-type (i (- i j))))))


#|
(include-book
 "factor-2")


;which way do we want to do this?
;disable later?
;add a "can have a 2 multiplied in" hyp to this series?
(defthm expt-2-combine-like-is
  (implies (and (syntaxp (should-have-a-2-factor-multiplied-in i))
                (integerp i))
           (equal (* (expt 2 i) (expt 2 i))
                  (expt 2 (* 2 i))))
  :hints (("Goal" :in-theory (disable expt-split)
           :use (:instance expt-split (r 2) (i1 i) (i2 i)))))

(defthm expt-2-combine-like-is-3-and-4-of-6
  (implies (and (syntaxp (should-have-a-2-factor-multiplied-in i))
                (integerp i)
                (rationalp a)
                (rationalp b)
                (rationalp c)
                (rationalp d)
                )
           (equal (* a b (expt 2 i) (expt 2 i) c d )
                  (* a b c d (expt 2 (* 2 i)))))
  :hints (("Goal" :in-theory (disable expt-split)
           :use (:instance expt-split (r 2) (i1 i) (i2 i)))))

(defthm expt-2-combine-like-is-4-and-5-of-6
  (implies (and (syntaxp (should-have-a-2-factor-multiplied-in i))
                (integerp i)
                (rationalp a)
                (rationalp b)
                (rationalp c)
                (rationalp d)
                )
           (equal (* a b c (expt 2 i) (expt 2 i) d )
                  (* a b c d (expt 2 (* 2 i)))))
  :hints (("Goal" :in-theory (disable expt-split)
           :use (:instance expt-split (r 2) (i1 i) (i2 i)))))
|#

(include-book "negative-syntaxp")

(defthm expt-pull-negation-out-of-power
  (implies (syntaxp (negative-syntaxp i))
           (equal (expt r i)
                  (/ (expt r (* -1 i)))))
  :hints (("Goal" :in-theory (enable expt-pull-negation-out-of-power-helper
                                     expt-split))))

#|
(defthm expt-2-combine-like-is-inverted
  (implies (and (syntaxp (should-have-a-2-factor-multiplied-in i))
                (integerp i))
           (equal (* (/ (EXPT 2 i))
                     (/ (EXPT 2 i)))
                  (/ (expt 2 (* 2 i)))))
  :hints (("Goal" :in-theory (disable 
                              expt-2-combine-like-is
                              expt-split)
           :use (:instance  expt-split (r 2) (i1 (* 1/2 i)) (i2 (* 1/2 i))))))

|#

(in-theory (disable expt))

(defthm expt-inverse
    (implies (integerp n)
	     (equal (/ (expt 2 n))
		    (expt 2 (- n)))))

(in-theory (disable expt-inverse))

;from sse-div proof

;is there a 2 term version?
(defthm expt-prod-integer-3-terms
  (implies (and (integerp i)
                (integerp j)
                (<= 0 (+ i j))
                (integerp n))
           (integerp (* (expt 2 i) (expt 2 j) n)))
  :hints (("Goal" :in-theory (enable a15)))
)

;drop these?
;generalize to comparisons to any constant (any power of 2)?


;disable since atypical?
;should always use case-split n hyps that say exponents are integers
(defthm expt-with-i-non-integer
  (implies (not (integerp i))
           (equal (expt r i)
                  1))
  :hints (("Goal" :in-theory (enable expt))))

;perhaps disable since we expect i rarely to be a non-int
;(in-theory (disable expt-with-i-non-integer))



;handle constants as args?
(defthm expt2-1-to-1
  (implies (and (integerp i1)
                (integerp i2))
           (equal (equal (expt 2 i1) (expt 2 i2))
                  (equal i1 i2)))
  :hints (("Goal" :in-theory (disable expt-compare)
           :use ((:instance EXPT-strong-MONOTONE (n i1) (m i2))
                 (:instance EXPT-strong-MONOTONE (n i2) (m i1))))))

;This rule, together with expt-compare allows any comparison using <, >, <=, or >= of two terms which have the
;form of powers of 2 to be rewritten to a claim about the exponents
;can kill more specialized rules
;without the :induct hint, bad things happen (why?)
(DEFTHM EXPO-EXPT2-I
  (EQUAL (EXPO (EXPT 2 I))
         (IF (INTEGERP I) I 0))
  :HINTS
  (("Goal" :induct (expt 2 i)
    :IN-THEORY (set-difference-theories
                       (ENABLE expt expo power2p)
                       '(a15)))))


;(include-book "even-odd")

;improve to handle n non-integer?
(defthm expt2-integer
  (implies (case-split (integerp i))
           (equal (integerp (expt 2 i))
                  (<= 0 i)))
  :hints (("Goal" :in-theory (enable expt; even-int-implies-int
                                     ))))

;bad name?
(defthm expt2-inverse-integer
  (implies (case-split (integerp i))
           (equal (INTEGERP (/ (EXPT 2 i)))
                  (<= i 0)))
  :hints (("Goal" :in-theory (disable expt2-integer)
           :use (:instance expt2-integer (i (- i))))))


#|
(defthm expt-prod-integer-4-terms
  (implies (and (integerp i)
                (integerp j)
                (integerp l)
                (<= 0 (+ i (- j) l))
                (integerp n))
           (integerp (* (expt 2 i) (/ (expt 2 j)) (expt 2 l) n)))
  :hints (("Goal" :in-theory (set-difference-theories (enable a15 expt-inverse)
                                                      '(expt-pull-negation-out-of-power))))
  )
|#

;figure out a better solution to this problem
;perhaps say if a term is a power of 2, then it's an integer iff its expo is >=0
(defthm expt-prod-integer-3-terms-2
  (implies (and (integerp i)
                (integerp j)
                (integerp l)
                (<= 0 (+ i (- j) (- l)))
                )
           (integerp (* (expt 2 i) (/ (expt 2 j)) (/ (expt 2 l)))))
  :hints (("Goal" :in-theory (set-difference-theories (enable a15 expt-inverse)
                                                      '(expt-pull-negation-out-of-power))))
  )

#| would be nice (use expt2-1-to-1)?
(defthm expt2-equal-1
  (implies (integerp i)
           (equal (EQUAL (EXPT 2 i) 1)
                  (equal i 0)))
;  :rule-classes nil
  :hints (("Goal" :in-theory (enable expt-split)))
)
|#

(defthm expt2-inverse-even
  (implies (case-split (integerp i))
           (equal (INTEGERP (* 1/2 (/ (EXPT 2 i))))
                  (<= (+ 1 i) 0)))
  :otf-flg t
  :hints (("Goal" :in-theory (set-difference-theories
                              (enable expt-split)
                              '(expt2-integer  EXPT2-INVERSE-INTEGER))
           :use (:instance expt2-integer (i (+ -1 (- i)))))))




;==== A scheme for preventing massively expensive calls to expt =======

#|
When ACL2 encounters a function call with constant arguments, the simplifier just evaluates the function on
those arguments.  However, calls of (expt r i) with huge i can be very expensive to compute.  (I suppose calls
with huge r might be very expensive too, but in my work, r is almost always 2.)  The scheme below prevents
(expt r i) from being evaluated when i is too large (but allows evaluation in the case of small i).

|#

(in-theory (disable (:executable-counterpart expt)))

(set-compile-fns t)
(defun expt-execute (r i) (expt r i))

;Allows expt calls with small exponents to be computed  
;You can change 1000 to your own desired bound.
(defthm expt-execute-rewrite
  (implies (and (syntaxp (and (quotep r) (quotep i) (< (abs (cadr i)) 1000))))
           (equal (expt r i)
                  (expt-execute r i))))


#|
The rules below are not complete, I proved them as needed to simplify terms like:
(* x
   (EXPT 2 1000001)
   (/ (EXPT 2 1000000))
   y)
|#

(defthm expt2-constants-collect-special-1
  (implies (and (syntaxp (and (quotep i1) (quotep i2))) 
                (case-split (rationalp x))
                (case-split (rationalp y))
                (case-split (integerp i1))
                (case-split (integerp i2)))
           (equal  (* x
                      (EXPT 2 i1)
                      (/ (EXPT 2 i2))
                      y)
                   (* (expt 2 (- i1 i2)) x y)))
 :hints (("Goal" :in-theory (set-difference-theories
                              (enable expt-split)
                              '(a15))))
)

(defthm expt2-constants-collect-special-2
  (implies (and (syntaxp (and (quotep i1) (quotep i2))) 
                (case-split (rationalp x))
                (case-split (integerp i1))
                (case-split (integerp i2)))
           (equal  (* x
                      (EXPT 2 i1)
                      (/ (EXPT 2 i2))
                      )
                   (* (expt 2 (- i1 i2)) x)))
 :hints (("Goal" :in-theory (set-difference-theories
                              (enable expt-split)
                              '(a15))))
)

(defthm expt2-constants-collect-special-3
  (implies (and (syntaxp (and (quotep i1) (quotep i2))) 
                (case-split (rationalp x))
                (case-split (integerp i1))
                (case-split (integerp i2)))
           (equal (equal (* x (EXPT 2 i1)) (EXPT 2 i2))
                  (equal x (expt 2 (- i2 i1)))))
  
  :hints (("Goal" :in-theory (set-difference-theories
                              (enable expt-split)
                              '(a15))))
)

(defthm expt2-constants-collect-special-4
  (implies (and (syntaxp (and (quotep i1) (quotep i2))) 
                (case-split (rationalp x))
                (case-split (rationalp y))
                (case-split (integerp i1))
                (case-split (integerp i2)))
           (equal  (* x (/ (EXPT 2 i2)) (EXPT 2 i1) y)
                   (* (expt 2 (- i1 i2)) x y)))
  
  :hints (("Goal" :in-theory (set-difference-theories
                              (enable expt-split)
                              '(a15)))))

(defthm expt2-constants-collect-special-5
  (implies (and (syntaxp (and (quotep i1) (quotep i2))) 
                (case-split (rationalp x))
                (case-split (integerp i1))
                (case-split (integerp i2)))
           (equal  (* x (/ (EXPT 2 i2)) (EXPT 2 i1))
                   (* (expt 2 (- i1 i2)) x)))
  
  :hints (("Goal" :in-theory (set-difference-theories
                              (enable expt-split)
                              '(a15)))))

;==================================================================

#|
;remove?
(defthm expt-simp
  (implies (integerp x)
           (equal (* 2 (EXPT 2 (+ -1 x)))
                  (expt 2 x)))
  :hints (("Goal" :use (:instance a15 (i 2) (j1 1) (j2 (+ -1 x))))))
|#



;loops with a15?
; (expt (* 2 i)) was matching with (expt 2 0) (booo!) so I added the syntaxp hyp
(defthm expt-2-split-product-index
  (implies (and (syntaxp (not (quotep i)))
                (case-split (rationalp r))
                (case-split (integerp i)))
           (equal (expt r (* 2 i))
                  (* (expt r i) (expt r i))))
  :hints (("Goal" :in-theory (disable expt-split)
           :use (:instance expt-split (i1 i) (i2 i)))))

(defthm expt-pull-negation-into-power
  (equal (/ (expt r i))
         (expt r (* -1 i)))
  :hints (("Goal" :in-theory (enable  expt-pull-negation-out-of-power)))
)
(in-theory (disable expt-pull-negation-into-power))


(defthm expt-bigger-than-i
  (implies (integerp i)
           (< i (expt 2 i)))
  :hints (("Goal" :in-theory (enable expt)))
  )


;this might loop with expt-split
(defthm expt-compare-with-double
  (implies (and (integerp x)
                (integerp i))
           (equal (< (* 2 x) (expt 2 i))
                  (< x (expt 2 (+ -1 i)))))
  :hints (("Goal" :in-theory (enable expt-split)))
)

(in-theory (disable expt-compare-with-double))

(include-book "ground-zero") ;move up?

(defthm expt-2-reduce-leading-constant-gen
  (implies (case-split (integerp (+ k d)))
           (equal (expt 2 (+ k d))
                  (* (expt 2 (fl k)) (expt 2 (+ (mod k 1) d)))))
    :hints (("Goal" :in-theory (set-difference-theories
                                (enable mod)
                                '(expt-split))
             :use (:instance expt-split (r 2) (i1 (fl k)) (i2 (+ (mod k 1) d))))))
(in-theory (disable expt-2-reduce-leading-constant-gen))

(defthm expt-2-reduce-leading-constant
  (implies (and (syntaxp (and (quotep k)
                         (or (>= (cadr k) 1) (< (cadr k) 0))))
                (case-split (integerp (+ k d)))
                )
           (equal (expt 2 (+ k d))
                  (* (expt 2 (fl k)) (expt 2 (+ (mod k 1) d)))))
    :hints (("Goal" :in-theory (set-difference-theories
                                (enable)
                                '(expt-split))
             :use (expt-2-reduce-leading-constant-gen
                   (:instance expt-split (r 2) (i1 (fl k)) (i2 (+ (mod k 1) d)))))))
(in-theory (disable expt-2-reduce-leading-constant))

;better than a15
(DEFTHM expt-combine
  (IMPLIES (AND (case-split (RATIONALP r))
                (case-split (NOT (EQUAL r 0)))
                (case-split (INTEGERP i1))
                (case-split (INTEGERP i2)))
           (AND (EQUAL (* (EXPT r i1) (EXPT r i2))
                       (EXPT r (+ i1 i2)))
                (EQUAL (* (EXPT r i1) (* (EXPT r i2) X))
                       (* (EXPT r (+ i1 i2)) X))))
  :hints (("Goal" :in-theory (enable a15))))
(in-theory (disable expt-combine))

(defthm expt-with-small-n
  (implies (<= n 0)
           (<= (expt 2 n) 1))
  :rule-classes (:linear)
)
