# Unit specification of C type models.
#
# Author::    Yutaka Yanoh <mailto:yanoh@users.sourceforge.net>
# Copyright:: Copyright (C) 2010-2012, OGIS-RI Co.,Ltd.
# License::   GPLv3+: GNU General Public License version 3 or later
#
# Owner::     Yutaka Yanoh <mailto:yanoh@users.sourceforge.net>

#--
#     ___    ____  __    ___   _________
#    /   |  / _  |/ /   / / | / /__  __/           Source Code Static Analyzer
#   / /| | / / / / /   / /  |/ /  / /                   AdLint - Advanced Lint
#  / __  |/ /_/ / /___/ / /|  /  / /
# /_/  |_|_____/_____/_/_/ |_/  /_/   Copyright (C) 2010-2012, OGIS-RI Co.,Ltd.
#
# This file is part of AdLint.
#
# AdLint is free software: you can redistribute it and/or modify it under the
# terms of the GNU General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any later
# version.
#
# AdLint is distributed in the hope that it will be useful, but WITHOUT ANY
# WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
# A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along with
# AdLint.  If not, see <http://www.gnu.org/licenses/>.
#
#++

require "spec_helper"

module AdLint
module C

  describe Type do
    before(:all) { Traits.instance.read_from($default_traits) }

    let(:type_table) { TypeTable.new }
    let(:int_ptr) { pointer_type(int_type) }
    let(:const_int_ptr) { pointer_type(qualified_type(int_type, :const)) }
    let(:const_int) { qualified_type(int_type, :const) }
    let(:volatile_int) { qualified_type(int_type, :volatile) }
    let(:const_volatile_int) { qualified_type(int_type, :const, :volatile) }

    describe ArrayType do
      context "detecting W0583" do
        subject { array_type(int_type, 3) }
        it { should be_convertible(const_int_ptr) }
      end

      context "detecting W0583" do
        subject { array_type(int_type, 3) }
        it { should be_convertible(int_ptr) }
      end

      context "detecting W0583" do
        subject { array_type(int_type) }
        it { should be_convertible(const_int_ptr) }
      end

      context "detecting W0583" do
        subject { array_type(int_type) }
        it { should be_convertible(int_ptr) }
      end
    end

    describe PointerType do
      context "detecting W0583" do
        subject { const_int_ptr }
        it { should_not be_convertible(array_type(int_type)) }
      end

      context "detecting W0583" do
        subject { int_ptr }
        it { should be_convertible(array_type(int_type)) }
      end

      context "more cv-qualified check of `const > none'" do
        subject { const_int }
        it { should be_more_cv_qualified(int_type) }
      end

      context "more cv-qualified check of `volatile > none'" do
        subject { volatile_int }
        it { should be_more_cv_qualified(int_type) }
      end

      context "more cv-qualified check of `const volatile > none'" do
        subject { const_volatile_int }
        it { should be_more_cv_qualified(int_type) }
      end

      context "more cv-qualified check of `const volatile > const'" do
        subject { const_volatile_int }
        it { should be_more_cv_qualified(const_int) }
      end

      context "more cv-qualified check of `const volatile > volatile'" do
        subject { const_volatile_int }
        it { should be_more_cv_qualified(volatile_int) }
      end
    end

    include TypeTableMediator
  end

end
end
