/*
   --------------------------------------------------------------
   File LUsolver.C of ADOL-C version 1.8.5        as of Nov/22/99
   --------------------------------------------------------------

   Example:  * Solution of a linear equation system 
               by LU-decomposition of the system matrix without pivoting 
             * Computation of the determinant of a matrix
             * application of tapedoc to observe taping of
               the new op_codes for the elementary operations
                  
                     y += x1 * x2;
                     y -= x1 * x2;           

   Last changes:
     990922 olvo    first version 

   --------------------------------------------------------------
*/

/****************************************************************************/
/*                                                                 INCLUDES */
#include "adolc.h"           // use of ALL ADOL-C interfaces


/****************************************************************************/
/*                                                          ADOUBLE ROUTINE */
/* Simple LU-factorization according to Crout's algorithm without pivoting */
void LUfact(int n, adouble **A)
{ int i, j, k;
  adouble dum;
  for (k=0; k<n; k++)
  { for (i=0; i<j; i++)
      for (k=0; k<i; k++) 
        A[i][j] -= A[i][k] * A[k][j];
    for (i=j; i<n; i++)
      for (k=0; k<j; k++)
        A[i][j] -= A[i][k] * A[k][j];
    if (A[j][j] != 0)   
    { dum = 1.0 / A[j][j];
      for (i=j+1; i<n; i++)
        A[i][j] *= dum; 
    }
    else
    { fprintf(stderr,"Error in LUfact(..): pivot is zero\n");
      exit(-99);
    } 
  }  
}

/* Solution of A*x=b by forward and backward substitution */
void LUsolve(int n, adouble **A, adouble *bx)
{ int i, j;
  /* forward substitution */
  for (i=0; i<n; i++)
    for (j=0; j<i-1; j++)
      bx[i] -= A[i][j] * bx[j];
  /* backward substitution */
  for (i=n-1; i>=0; i--)
  { for (j=i+1; j<n; j++)
      bx[i] -= A[i][j] * bx[j];
    bx[i] /= A[i][i];
  }  
}


/****************************************************************************/
/*                                                             MAIN PROGRAM */
int main() 
{ const int tag = 1;                       
  const int size  = 5;
  const int indep = size*size+size;
  const int depen = size;
  int i,j;

  double **A, *a, *b;

  double* arguments = new double[indep];
  double* taylors   = new double[depen];
  double yp[size],xp[size*size+size];     // passive variable


  cout << "LU - DECOMPOSITION (ADOL-C Example)\n\n";

  /* Allocation and initialization */
  A = myalloc2(size,size);
  a = myalloc1(size);
  b = myalloc1(size);                      

  for(i=0; i<size; i++)
  { a[i] = i*0.25;
    b[i] = i*0.33;
  }
  for(i=0; i<size; i++) 
  { for(j=0; j<size; j++) 
      A[i][j] = a[i]*b[j];
    A[i][i] += i+1;
  }

  adoublem A(size,size);
  adoublev bv(size);                      // active variables
  int N = size*size; 
  trace_on(tag,dum);                      // Begin taping all calculations 
    for(i=0; i<size; i++)                 // with 'adoubles'
    { for(j=0; j<size; j++)
      {  A[i][j] <<= A_1[i][j];           // indep. vars 
         arguments[i*size+j] = A_1[i][j]; // args for forward 
      } // end for 
    } // end for 
    for(i=0; i<size; i++)
    { bv[i] <<= -i-1;                     // indep. vars 
      arguments[N+i] = -i-1;              // args for forward 
    }
    gausselim(size,A,bv);
    bv >>= yp;
  trace_off(); 
    
  forward(tag,depen,indep,0,1,arguments,taylors);

  cout << "Compare the calculated solution components of the\n";
  cout << "forward sweep and the direct evaluation: forward - direct = 0 ?\n";
  for(i=0; i<depen; i++)
    cout << taylors[i] << " - " << yp[i] << " = " << taylors[i] - yp[i] << "\n";

     // use the same tape for an other system matrix:
  for(i=0; i<size; i++)
  { for(j=0; j<size; j++)
    { arguments[j*size+i] = A_2[i][j];    // new args for forward 
      A[i][j] = A_2[i][j];                // new args for gausselim 
    } // end for 
    bv[i] = -i-1;                         // old indep. vars 
  } // end for 
  gausselim(size,A,bv);                   // calculation without taping

  forward(tag,depen,indep,0,1,arguments,taylors);

  cout << "\nThe same comparison for a different system matrix: \n";

  for(i=0; i<depen; i++)
    cout << taylors[i] << " - " << value(bv[i]) << " = "
         << taylors[i] - value(bv[i]) << "\n";
 
  return 1;
} // end main

