/*
 * iconmenu.cc
 * Copyright (C) 2000 Frank Hale
 * frankhale@yahoo.com
 * http://sapphire.sourceforge.net/
 *
 * Updated: 1 Nov 2001
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
 
#include "aewm.hh"

IconMenu::IconMenu() : GenericMenu()
{
	updateIconMenu();
}

IconMenu::~IconMenu()
{
}

void IconMenu::updateIconMenu()
{
	updateMenu();
	
	addToMenuList(this);
}

void IconMenu::handle_button_release_event(XButtonEvent *e)
{
	GenericMenu::handle_button_release_event(e);

	switch (e->button) 
	{
		case Button1:
			if (curr) 
			{
				switch(	curr->function )
				{
					case UNICONIFY:
						curr->client->unhide();
						hideAllVisibleSubmenus();
					break;
				
				}										
			}	
		break;
	} 
}

void IconMenu::addThisClient(Client *c)
{
	BaseMenuItem *item = new BaseMenuItem();

	if(c)
	{
		item->client = c;
		item->name=c->getClientIconName(); // name showing on menu.
		item->function=UNICONIFY;
	
		insert(item);
	}
}

void IconMenu::removeClientFromIconMenu(Client *c)
{
	LinkedListIterator<BaseMenuItem> mit(getMenuItemList());
	
	BaseMenuItem *item = NULL;
	
	for(; mit.current(); mit++)
	{
		if(mit.current()->client == c) 
		{
			item = mit.current();
			break;
		}
	}
	
	if(item) remove(item);
}
