/*
 * windowmenu.hh 
 * Copyright (C) 2002 Frank Hale
 * frankhale@yahoo.com
 * http://sapphire.sourceforge.net/
 *
 * Updated: 16 Jan 2002
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
#ifndef _WINDOWMENU_HH
#define _WINDOWMENU_HH

#include "aewm.hh"

class WindowMenu : public GenericMenu
{
private:
	Client *client;
	
public:
	WindowMenu();
	virtual ~WindowMenu();

	virtual void handle_button_release_event(XButtonEvent *e);

	void handle_enter_menu();
	void handle_leave_menu();

	void updateWindowMenu();
	
	void setThisClient(Client *c) { client = c; }
};

#endif 
