#
# DEVICE SPECIFICATION
#
# The device name (No-Rewind-Version !)
Backup-Device:		/dev/rmt0.1
#
# The blocksize of the device
Tape-Blocksize:		1024
#
# Flag, whether the device is a robot / cartridge handling system (0 or 1)
Cartridge-Handler:	1
#
# Insert your number of cartridges, whether you have a robot or not
Number Of Cartridges:	10
#
# The last cartridges of different cartridge sets, if requested.
# Default is 1 set with cartridges ranging from 1 up to the
# previous parameter. If e.g. 3 cartridge sets are requested:
# 1-3, 4-8, 9-10, supply here: 3 8 10
# If not all cartridges should be used, the last number may be
# smaller than the previous parameter.
#Last Cartridges:	10

#
# The maximum number of bytes per file on tape
Max Bytes Per File:	50000000
#
# Time to wait from the moment, a new cartridge has been inserted
Cart-Insert-Gracetime:	70
#
# Time to wait, while the device is unavailable, until a mail is
# sent to the user in charge (see below)
Dev Unavail Send mail after min:	6
#
# Time to wait, while the device is unavailable, until abort
Device Unavail give up after min:	45

#
# SHELL-COMMANDS FOR TAPE HANDLING
#
# In these commands %d is replaced by the device name,
# %n by the number, if within the command the count starts with 1,
# %m by the number, if the count starts with 0.
#
# Command to set the file # on tape
SetFile-Command:	mt -f %d rewind ; #BASEDIR#/server/bin/__mt -f %d fsf %m
#
# If there is a command to set the cartridge directly, use it here
#Setcart-Command:	
#
# If the cartridges can only by changed successively, insert the
# command to change them here. This is also the command, that unloads
# the tape, if you have no cartridge handler.
Changecart-Command:	mt -f %d rewoffl
#
# The command to erase the tape. This is necessary on some systems.
#Erasetape-Command:	exit 0

#
# CONFIGURATION FOR NON-EXISTING CARTRIDGE HANDLING SYSTEM
#
# The user to inform, if a cartridge should be changed manually
User To Inform: 	sysadmin
#
# The mail-program to use.
# Insert %u for the position, where the username has to appear.
Mail-Program:		mail -s "[Afbackup]: Backup Service Information" %u

#
# FILES TO SAVE THE STATE AND LOGGINGS
#
# Filename to save the actual tape position
Tape-Pos-File:		#BASEDIR#/server/var/tapepos
#
# Filename for error loggings etc.
Logging-file:		#BASEDIR#/server/var/backup.log
#
# Locking file to prevent several server starts
Locking-file:		#BASEDIR#/server/var/backup.lock

#
# Filename with encryption key for authentication
Encryption-Key-File:	#BASEDIR#/server/lib/cryptkey

#
# SPECIFICATIONS FOR REMOTE_EXECUTION
#
# Directory, where remotely started programs must reside
Program-Directory:	#BASEDIR#/server/rexec

#
# SERVER-STARTUP AND SHUTDOWN ACTIONS
#
# shell-command to perform, when the server starts
#Init-Command:		echo backup-daemon starting.
#
# shell-command to perform, when the server exits
#Exit-Command:		echo backup-daemon exiting.
