/*******************************************************************************
 *  PROJECT: GNOME Colorscheme
 *
 *  AUTHOR: Jonathon Jongsma
 *
 *  Copyright (c) 2005 Jonathon Jongsma
 *
 *  License:
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the 
 *    Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
 *    Boston, MA  02111-1307  USA
 *
 *******************************************************************************/

#ifndef __GCS_COLOR_GROUP_H
#define __GCS_COLOR_GROUP_H

#include "gcs-types.h"
#include <vector>

namespace gcs
{

    /** A group of colors which can be used as a base class for a color scheme,
     * a color palette, a list of favorite colors, etc.
     */
    class ColorGroup : public std::vector<ColorPtr>
    {
        public:
            void print(void);
    };


} // namespace gcs

#endif // __GCS_COLOR_GROUP_H
