#ifndef CalendarEvent_h
#define CalendarEvent_h

#include <Foundation/Foundation.h>

#include "CalendarDomain.h"
#include "CalendarUser.h"
#include "CalendarGroup.h"
#include "CalendarManager.h"

@protocol CalendarEvent
- (NSString *) name;
- (id <CalendarUser>) owner;
- (id <CalendarGroup>) calendarGroup;
- (NSString *) summaryString;
- (void) setSummaryString:(NSString *)string;
- (NSDate *) startDate;
- (NSDate *) stopDate;
- (void) setStartDate:(NSDate *)date;
- (void) setStopDate:(NSDate *)date;
- (void) setCalendarGroup:(id <CalendarGroup>)group;
@end

@interface CalendarEvent:NSObject <CalendarOwner>
{
	NSString *_name;
	CalendarUser *__owner;
	CalendarGroup *__group;
	NSDate *_startDate;
	NSDate *_stopDate;
	NSString *_summary;
	NSMutableArray *_knownHosts;
}

+ (CalendarEvent *) calendarEventWithName:(NSString *)name
							 calendarUser:(CalendarUser *)owner
							calendarGroup:(CalendarGroup *)group
								startDate:(NSDate *)startDate
								 stopDate:(NSDate *)stopDate
							summaryString:(NSString *)summary;

- (id) initWithName:(NSString *)name
	   calendarUser:(CalendarUser *)owner
	  calendarGroup:(CalendarGroup *)group
		  startDate:(NSDate *)startDate
		   stopDate:(NSDate *)stopDate
	  summaryString:(NSString *)summary;

- (NSString *) name;
- (CalendarGroup *) calendarGroup;
- (NSString *) summaryString;
- (void) setSummaryString:(NSString *)string;
- (NSDate *) startDate;
- (NSDate *) stopDate;
- (void) setStartDate:(NSDate *)date;
- (void) setStopDate:(NSDate *)date;
- (void) setCalendarGroup:(CalendarGroup *)group;

@end

@interface CalendarEventManager:NSObject <CalendarEvent>
{
	CalendarEvent *_event;
	CalendarUser *_manager;
}

- (id) initWithCalendarEvent:(CalendarEvent *)event
		manageByCalendarUser:(CalendarUser *)manager;
@end
#endif
