#ifndef CalendarEventView_h
#define CalendarEventView_h

#include <Foundation/NSCalendarDate.h>
#include <AppKit/AppKit.h>
#include "Agenda.h"
#include "CalendarEventCell.h"

@protocol CalendarEventView
- (void) calendarEventView:(id)view
			didSelectEvent:(CalendarEventCell *)event;
- (void) calendarEventView:(id)view
			  updatedEvent:(CalendarEventCell *)event;
@end

@interface CalendarEventView:NSView
{
	id <CalendarEventView> _delegate;
	float _stepHeight;
	float _cevOffset;
	float _minutesInStep;
	float _stepsInUnit;
	float _unitsInView;

	NSMutableArray *_timeStr;
	NSCalendarDate *_date;

	id tint;
	/* these 2 helpers is for forcing views to create events
	 * for improving layout when putting many views in matrix
	 * -- TODO
	 */
	NSCalendarDate *_rangeDateStart;
	NSCalendarDate *_rangeDateStop;

	id _selectedCell;
//	NSMutableArray *_eventList;

	NSTimeInterval _startTimeInterval;
	NSTimeInterval _endTimeInterval;

	NSTimeInterval _workTimeStart;
	NSTimeInterval _workTimeStop;

	BOOL _showIndex;
}

- (float) stepHeight;
- (float) numberOfMinutesInStep;
- (float) numberOfStepsInUnit;
- (float) numberOfUnits;

- (void) setDate:(NSCalendarDate *)aDate;
- (void) viewSelectedCell;
- (void) viewCell:(CalendarEventCell *)cell;
- (NSView *) hitView:(NSEvent *)event;
- (NSTimeInterval) hitTime:(NSEvent *)event;
- (void) removeEvent:(id)cell;
- (id) selectedCell;
- (void) selectCell:(id)cell;

- (NSCalendarDate *) startDate;
- (NSCalendarDate *) stopDate;
- (void) setDelegate:(id)del;
- (id) delegate;
@end

#endif
