/**********************************************************************
 * prefix.h                                                  April 2001
 * Horms                                             horms@verge.net.au
 *
 * aggregate
 * CIDR network aggregation and filtering
 * Copyright (C) 1999-2002  Horms
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 * 02111-1307  USA
 *
 **********************************************************************/


#ifndef CIDR_PREFIX_FRUB
#define CIDR_PREFIX_FRUB

#include "int.h"

typedef int8 prefix_t;

#define PREFIX_STR_LEN 3

#define PREFIX_MIN (prefix_t) 0
#define PREFIX_MAX (prefix_t) 32


/**********************************************************************
 * prefix_a_to_decimal
 * Convert an prefix given as a string into decimal
 * pre: alleged_prefix: string representing ip address
 *      decimal_prefix: Pointer to a prefix_t to store result in
 * post: 0 on success, decimal_prefix contains value
 *       -1 on error
 **********************************************************************/

int prefix_a_to_decimal(char *alleged_prefix, prefix_t *decimal_prefix);


/**********************************************************************
 * prefix_decimal_to_a
 * Turn an IP given as a decimal to a dotted quad
 * pre: ip_address: string representing IP address
 *      result: prealocated string to place result in
 * post: NULL if an error occurs
 *       dotted quad representation of IP address otherwise
 *       Note: result is rendered into a static buffer
 **********************************************************************/

char *prefix_decimal_to_a(prefix_t prefix);

#endif
