#ifndef _MOVEABLE_H
#define _MOVEABLE_H

#ifdef USE_PTHREAD
#include <pthread.h>
#endif
#include "strings.h"
#include "item.h"

class Builder;

class Moveable : public Item
{
public:

   Moveable(char *the_name, char *the_area);
   virtual ~Moveable();

   virtual void describe(Builder *the_builder);
   virtual void describe(Player *the_player);
   virtual int set_attrib(Builder *the_builder, Parse *the_parsed);
   virtual int copy_object(Entity *copy_obj);

   int      set_brief(char *the_desc, int the_brief);
   char     *get_brief();
   char     *get_brief(int the_brief);
   int      set_size(int new_size);
   int      get_size();
   int      set_weight(int new_weight);
   int      get_weight();
   void     set_num_allowed(int new_val);
   int      get_num_allowed();
   void     set_percent_allowed(int new_val);
   int      get_percent_allowed();
   void     set_moved();
   int      is_moved();
   Moveable *operator = (Moveable *copy_from);

   int set_attrib_weight(Parse *the_parsed, Builder *the_builder);
   int set_attrib_size(Parse *the_parsed, Builder *the_builder);
   int set_attrib_brief(Builder *the_builder, int brief_no);
   int set_attrib_num_allow(Parse *the_parsed, Builder *the_builder);
   int set_attrib_percent_allow(Parse *the_parsed, Builder *the_builder);
   int write_moveable_attrib(FILE *the_file);
   int read_moveable_attrib(FILE *read_file, ErrLog *error_log);
   int copy_moveable_attrib(Moveable *copy_from);

   virtual void write_object(FILE *the_file, int build_format);
   int get_mem_size_moveable();

 protected:

   Moveable();

   Strings brief_desc0;
   Strings brief_desc1;
   int     size;
   int     weight;

   int     num_allowed;
   int     percent_allowed;
};

#endif
