#ifndef _SPECIAL_FUNC_H
#define _SPECIAL_FUNC_H

#include "specials.h"
#include "code.h"
#include "player.h"
#include "config.h"

/****************************
 * communications functions
 ****************************/


params *send_actor(params *the_params, Specials *the_special, 
     Player *the_player, in_params *player_params, special_env *environment, 
                                                               int *results);
params *send_all_room(params *the_params, Specials *the_special, 
     Player *the_player, in_params *player_params, special_env *environment, 
                                                               int *results);
params *send_all_room_except(params *the_params, Specials *the_special, 
     Player *the_player, in_params *player_params, special_env *environment, 
                                                               int *results);
params *send_room_except_dual(params *the_params, Specials *the_special, 
   Player *the_player, in_params *player_params, special_env *environment, 
                                                             int *results);
params *send_obj_room(params *the_params, Specials *the_special, 
     Player *the_player, in_params *player_params, special_env *environment, 
                                                               int *results);
params *send_to(params *the_params, Specials *the_special, 
   Player *the_player, in_params *player_params, special_env *environment, 
                                                             int *results);
params *send_holder(params *the_params, Specials *the_special, 
     Player *the_player, in_params *player_params, special_env *environment, 
                                                               int *results);
params *tell_ind(params *the_params, Specials *the_special, 
   Player *the_player, in_params *player_params, special_env *environment, 
                                                             int *results);
params *send_all_except(params *the_params, Specials *the_special, 
   Player *the_player, in_params *player_params, special_env *environment, 
                                                             int *results);
params *send_all(params *the_params, Specials *the_special, 
   Player *the_player, in_params *player_params, special_env *environment, 
                                                             int *results);

/****************************************
 * flow control functions
 ****************************************/

params *goto_spec(params *the_params, Specials *the_special, 
     Player *the_player, in_params *player_params, special_env *environment, 
                                                               int *results);
params *goto_if_eq(params *the_params, Specials *the_special, 
     Player *the_player, in_params *player_params, special_env *environment, 
                                                               int *results);
params *goto_if_neq(params *the_params, Specials *the_special, 
     Player *the_player, in_params *player_params, special_env *environment, 
                                                               int *results);
params *goto_if_less(params *the_params, Specials *the_special, 
     Player *the_player, in_params *player_params, special_env *environment, 
                                                               int *results);
params *ret_inv_crit(params *the_params, Specials *the_special, 
     Player *the_player, in_params *player_params, special_env *environment, 
                                                               int *results);
params *force_termination(params *the_params, Specials *the_special, 
     Player *the_player, in_params *player_params, special_env *environment, 
                                                               int *results);
params *force_failure(params *the_params, Specials *the_special, 
     Player *the_player, in_params *player_params, special_env *environment, 
                                                               int *results);
params *force_success(params *the_params, Specials *the_special, 
     Player *the_player, in_params *player_params, special_env *environment, 
                                                               int *results);

/****************************************
 * comparison functions
 ****************************************/


params *is_string_eq(params *the_params, Specials *the_special, 
     Player *the_player, in_params *player_params, special_env *environment, 
                                                               int *results);

/****************************
 * functions for all objects
 ****************************/

params *set(params *the_params, Specials *the_special, 
     Player *the_player, in_params *player_params, special_env *environment, 
                                                               int *results);
params *get(params *the_params, Specials *the_special, 
     Player *the_player, in_params *player_params, special_env *environment, 
                                                               int *results);
params *destroy_this_obj(params *the_params, Specials *the_special, 
     Player *the_player, in_params *player_params, special_env *environment, 
                                                               int *results);
params *get_parent_name(params *the_params, Specials *the_special, 
     Player *the_player, in_params *player_params, special_env *environment, 
                                                             int *results);
params *is_individual(params *the_params, Specials *the_special, 
     Player *the_player, in_params *player_params, special_env *environment, 
                                                               int *results);
params *clone_object(params *the_params, Specials *the_special, 
     Player *the_player, in_params *player_params, special_env *environment, 
                                                               int *results);
params *spec_add_status(params *the_params, Specials *the_special, 
     Player *the_player, in_params *player_params, special_env *environment, 
                                                               int *results);
params *remove_status(params *the_params, Specials *the_special, 
     Player *the_player, in_params *player_params, special_env *environment, 
                                                               int *results);
params *has_status(params *the_params, Specials *the_special, 
     Player *the_player, in_params *player_params, special_env *environment, 
                                                               int *results);
params *move_object(params *the_params, Specials *the_special, 
     Player *the_player, in_params *player_params, special_env *environment, 
                                                               int *results);
params *object_exists(params *the_params, Specials *the_special, 
     Player *the_player, in_params *player_params, special_env *environment, 
                                                               int *results);
params *attach_special(params *the_params, Specials *the_special, 
     Player *the_player, in_params *player_params, special_env *environment, 
                                                               int *results);
params *detach_special(params *the_params, Specials *the_special, 
     Player *the_player, in_params *player_params, special_env *environment, 
                                                               int *results);


/****************************
 * item functions
 ****************************/

params *is_itemflag_set(params *the_params, Specials *the_special, 
     Player *the_player, in_params *player_params, special_env *environment, 
                                                               int *results);
params *set_itemflag(params *the_params, Specials *the_special, 
     Player *the_player, in_params *player_params, special_env *environment,
                                                               int *results);
params *clr_itemflag(params *the_params, Specials *the_special, 
     Player *the_player, in_params *player_params, special_env *environment, 
                                                               int *results);
params *light_all_room(params *the_params, Specials *the_special, 
     Player *the_player, in_params *player_params, special_env *environment, 
                                                               int *results);


/****************************
 * individual functions
 ****************************/

params *ambush_individual(params *the_params, Specials *the_special, 
     Player *the_player, in_params *player_params, special_env *environment, 
                                                               int *results);
params *damage_individual(params *the_params, Specials *the_special, 
     Player *the_player, in_params *player_params, special_env *environment, 
                                                               int *results);
params *damage_all_room(params *the_params, Specials *the_special, 
     Player *the_player, in_params *player_params, special_env *environment, 
                                                               int *results);
params *fight_player(params *the_params, Specials *the_special, 
     Player *the_player, in_params *player_params, special_env *environment, 
                                                               int *results);
params *is_indflag_set(params *the_params, Specials *the_special, 
     Player *the_player, in_params *player_params, special_env *environment, 
                                                               int *results);
params *set_indflag(params *the_params, Specials *the_special, 
     Player *the_player, in_params *player_params, special_env *environment,
                                                               int *results);
params *clr_indflag(params *the_params, Specials *the_special, 
     Player *the_player, in_params *player_params, special_env *environment,
                                                               int *results);
params *ind_holds(params *the_params, Specials *the_special, 
     Player *the_player, in_params *player_params, special_env *environment,
                                                               int *results);



/****************************
 * player functions
 ****************************/


params *trans_player(params *the_params, Specials *the_special, 
     Player *the_player, in_params *player_params, special_env *environment, 
                                                               int *results);
params *add_ability(params *the_params, Specials *the_special, 
     Player *the_player, in_params *player_params, special_env *environment, 
                                                               int *results);
params *remove_ability(params *the_params, Specials *the_special, 
     Player *the_player, in_params *player_params, special_env *environment, 
                                                               int *results);
params *has_ability(params *the_params, Specials *the_special, 
     Player *the_player, in_params *player_params, special_env *environment, 
                                                               int *results);
params *boot_off(params *the_params, Specials *the_special, 
     Player *the_player, in_params *player_params, special_env *environment, 
                                                               int *results);
params *award_quest(params *the_params, Specials *the_special, 
     Player *the_player, in_params *player_params, special_env *environment, 
                                                               int *results);
params *advance_experience(params *the_params, Specials *the_special, 
   Player *the_player, in_params *player_params, special_env *environment, 
                                                             int *results);
params *push_prompt(params *the_params, Specials *the_special, 
   Player *the_player, in_params *player_params, special_env *environment, 
                                                             int *results);
params *pop_prompt(params *the_params, Specials *the_special, 
   Player *the_player, in_params *player_params, special_env *environment, 
                                                             int *results);
params *start_busy(params *the_params, Specials *the_special, 
     Player *the_player, in_params *player_params, special_env *environment, 
                                                               int *results);
params *end_busy(params *the_params, Specials *the_special, 
     Player *the_player, in_params *player_params, special_env *environment, 
                                                               int *results);


/****************************
 * functions for mergers
 ****************************/

params *decrement_number_of(params *the_params, Specials *the_special, 
   Player *the_player, in_params *player_params, special_env *environment, 
                                                             int *results);
params *increment_number_of(params *the_params, Specials *the_special, 
   Player *the_player, in_params *player_params, special_env *environment, 
                                                             int *results);
params *get_number_of(params *the_params, Specials *the_special, 
   Player *the_player, in_params *player_params, special_env *environment, 
                                                             int *results);


/****************************
 * functions for doors
 ****************************/

params *set_door_state(params *the_params, Specials *the_special, 
   Player *the_player, in_params *player_params, special_env *environment, 
                                                             int *results);
params *get_door_state(params *the_params, Specials *the_special, 
   Player *the_player, in_params *player_params, special_env *environment, 
                                                             int *results);


/****************************
 * functions for locations
 ****************************/

params *get_loc_by_dir(params *the_params, Specials *the_special, 
   Player *the_player, in_params *player_params, special_env *environment, 
                                                             int *results);
params *display_loc(params *the_params, Specials *the_special, 
   Player *the_player, in_params *player_params, special_env *environment, 
                                                             int *results);
params *display_objects(params *the_params, Specials *the_special, 
   Player *the_player, in_params *player_params, special_env *environment, 
                                                             int *results);



/**********************************
 * Functions to read and manipulate
 * specials attributes
 **********************************/

params *decrement_counter(params *the_params, Specials *the_special, 
     Player *the_player, in_params *player_params, special_env *environment, 
                                                               int *results);
params *increment_counter(params *the_params, Specials *the_special, 
     Player *the_player, in_params *player_params, special_env *environment, 
                                                               int *results);
params *get_counter(params *the_params, Specials *the_special, 
     Player *the_player, in_params *player_params, special_env *environment, 
                                                               int *results);
params *set_counter(params *the_params, Specials *the_special, 
     Player *the_player, in_params *player_params, special_env *environment, 
                                                               int *results);
params *set_param(params *the_params, Specials *the_special, 
     Player *the_player, in_params *player_params, special_env *environment, 
                                                               int *results);
params *set_store_int(params *the_params, Specials *the_special, 
     Player *the_player, in_params *player_params, special_env *environment, 
                                                               int *results);
params *get_store_int(params *the_params, Specials *the_special, 
     Player *the_player, in_params *player_params, special_env *environment, 
                                                               int *results);
params *get_target_str(params *the_params, Specials *the_special, 
     Player *the_player, in_params *player_params, special_env *environment, 
                                                               int *results);


/**********************************
 * Functions to manipulate a number
 * and return a new value
 **********************************/

params *increment_number(params *the_params, Specials *the_special, 
     Player *the_player, in_params *player_params, special_env *environment, 
                                                               int *results);
params *decrement_number(params *the_params, Specials *the_special, 
     Player *the_player, in_params *player_params, special_env *environment, 
                                                               int *results);


/**********************************
 * Functions to get and use a
 * random number
 **********************************/

params *get_random(params *the_params, Specials *the_special, 
     Player *the_player, in_params *player_params, special_env *environment, 
                                                               int *results);
params *select_rand_param(params *the_params, Specials *the_special, 
     Player *the_player, in_params *player_params, special_env *environment, 
                                                               int *results);


/**********************************
 * Miscellaneous Functions
 **********************************/

params *test_for_success(params *the_params, Specials *the_special, 
     Player *the_player, in_params *player_params, special_env *environment, 
                                                               int *results);
params *exit_tutorial(params *the_params, Specials *the_special, 
     Player *the_player, in_params *player_params, special_env *environment, 
                                                               int *results);
params *apply_special_loc(params *the_params, Specials *the_special, 
     Player *the_player, in_params *player_params, special_env *environment, 
                                                               int *results);


/************************************
 * Functions to manage an assignment
 ************************************/

params *assign(params *the_params, Specials *the_special, 
     Player *the_player, in_params *player_params, special_env *environment, 
                                                               int *results);

#endif



