/***************************************************************************
 *   Copyright (C) 2004 by Teemu Rytilahti                                 *
 *   tpr@d5k.net                                                           *
 *                                                                         *
 *   Licensed under GPL.                                                   *
 ***************************************************************************/

#include <kurl.h>
#include <kprocess.h>
#include <dcopref.h>
#include <khtml_part.h>
#include <klocale.h>

#include "feeddetector.h"
#include "pluginbase.h"
#include <qstringlist.h>

#include <kdebug.h>

using namespace Akregator;

PluginBase::PluginBase()
{}

PluginBase::~PluginBase()
{}

bool PluginBase::akregatorRunning()
{
    DCOPRef akr("akregator", "akregator");
    DCOPReply reply = akr.call("interfaces"); // FIXME hackish but works :) -tpr 20041203
    return reply.isValid();
}

void PluginBase::addFeedsViaDCOP(const QStringList& urls)
{
    kdDebug() << "PluginBase::addFeedsViaDCOP" << endl;
    DCOPRef akr("akregator", "AkregatorIface");
    akr.send("addFeedsToGroup", urls, i18n("Imported Feeds") );
    /*if(!reply.isValid()) {
    KMessageBox::error( 0, i18n( "aKregator feed icon - DCOP Call failed" ),
    i18n( "The DCOP call addFeedToGroup failed" ));
}*/
}

void PluginBase::addFeedViaCmdLine(QString url)
{
    KProcess *proc = new KProcess;
    *proc << "akregator" << "-g" << i18n("Imported Feeds");
    *proc << "-a" << url;
    proc->start(KProcess::DontCare);
    delete proc;
}

// handle all the wild stuff that KURL doesn't handle
QString PluginBase::fixRelativeURL(const QString &s, const KURL &baseurl)
{
    QString s2=s;
    KURL u;
    if (KURL::isRelativeURL(s2))
    {
        if (s2.startsWith("//"))
        {
            s2=s2.prepend(baseurl.protocol()+":");
            u=s2;
        }
        else if (s2.startsWith("/"))
        {
            u=baseurl;
            u.setPath(s2);
        }
        else
        {
            u=baseurl;
            u.addPath(s2);
        }
        u.cleanPath();
    }
    else
        u=s2;

    u.cleanPath();
    return u.url();
}
