#!/usr/bin/env python

from distutils.core import setup
import glob, os, commands, sys

data_files = []
if sys.argv[1] == 'install':
	if not os.path.isdir('build'):
		os.makedirs('build')
	os.system('intltool-merge -d po src/alacarte.desktop.in build/alacarte.desktop')
	data_files += [('share/applications', ['build/alacarte.desktop'])]
	for name in os.listdir(os.path.join(os.path.realpath('.'), 'po')):
		if name[-2:] == 'po':
			if not os.path.isdir('build/locale/' + name[:-3]):
				os.makedirs('build/locale/' + name[:-3])
			os.system('msgfmt -o build/locale/' + name[:-3] + '/alacarte.mo po/' + name[:-3] + '.po')
			data_files.append(('share/locale/' + name[:-3] + '/LC_MESSAGES', ['build/locale/' + name[:-3] + '/alacarte.mo']))

setup(
	name = 'alacarte',
	version = '0.8',
	description = 'Simple fd.o Compliant Menu Editor',
	author = 'Travis Watkins',
	author_email = 'alleykat@gmail.com',
	url = 'http://www.realistanew.com/projects/alacarte/',
	packages = ['Alacarte'],
	package_dir = {'Alacarte': 'src/Alacarte'},
	package_data = {'Alacarte': ['alacarte.glade', 'images/*.svg']},
	scripts = ['src/alacarte'],
	data_files = data_files,
	license = 'GNU LGPL',
	platforms = 'posix',
	)

if sys.argv[1] == 'clean':
	for root, dirs, files in os.walk('build', topdown=False):
		for name in files:
			os.remove(os.path.join(root, name))
		for name in dirs:
			os.rmdir(os.path.join(root, name))
	if os.path.isdir('build'):
		os.rmdir('build')
