#   Alacarte Menu Editor - Simple fd.o Compliant Menu Editor
#   Copyright (C) 2005  Travis Watkins
#
#   This library is free software; you can redistribute it and/or
#   modify it under the terms of the GNU Library General Public
#   License as published by the Free Software Foundation; either
#   version 2 of the License, or (at your option) any later version.
#
#   This library is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#   Library General Public License for more details.
#
#   You should have received a copy of the GNU Library General Public
#   License along with this library; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import os, cgi
import pygtk
pygtk.require('2.0')
import gtk, gtk.glade, gobject
from config import *

class DialogHandler:
	def __init__(self, tree, icon=None):
		self.tree = tree
		self.icon = icon
		signals = {}
		for attr in dir(self):
			signals[attr] = getattr(self, attr)
		self.tree.signal_autoconnect(signals)
		self.completion = gtk.EntryCompletion()
		self.completion.set_property('popup-completion', False)
		self.completion.set_inline_completion(True)
		self.full_store = gtk.ListStore(str)
		self.used_store = gtk.ListStore(str)
		self.completion.set_text_column(0)
		paths = os.getenv('PATH')
		for path in paths.split(':'):
			if os.path.isdir(path):
				for name in os.listdir(path):
					self.full_store.append([name,])
		self.completion.set_model(self.used_store)

	def newMenuDialog(self):
		menuDialog = self.tree.get_widget('newmenudialog')
		menuDialog.set_icon(self.icon)
		nameEntry = self.tree.get_widget('mnewnameentry')
		commentEntry = self.tree.get_widget('mnewcommententry')
		iconButton = self.tree.get_widget('mnewiconbutton')
		menuDialog.show()
		def checkResponse(response):
			if response == gtk.RESPONSE_OK:
				if len(nameEntry.get_text()) == 0:
					self.showError(menuDialog, _('A name is required.'))
					return False
				if nameEntry.get_text() == 'Other':
					self.showError(
						menuDialog, _('A menu can\'t be named "Other".')
						)
					return False
				return True
			elif response == gtk.RESPONSE_CANCEL:
				return None
		code = False
		while code == False:
			response = menuDialog.run()
			code = checkResponse(response)
		if code == True:
			returnValue = (
				nameEntry.get_text(), commentEntry.get_text(),
				iconButton.get_filename()
				)
		else:
			returnValue = (None, None, None)
		self.resetNewMenuDialog()
		return returnValue

	def resetNewMenuDialog(self):
		menuDialog = self.tree.get_widget('newmenudialog')
		nameEntry = self.tree.get_widget('mnewnameentry')
		commentEntry = self.tree.get_widget('mnewcommententry')
		iconButton = self.tree.get_widget('mnewiconbutton')
		nameEntry.set_text('')
		commentEntry.set_text('')
		iconButton.set_filename('')
		menuDialog.hide()

	def editMenuDialog(self, item):
		self.resetMenu = False
		self.count = 0
		self.item = item
		menuDialog = self.tree.get_widget('menudialog')
		menuDialog.set_icon(self.icon)
		nameEntry = self.tree.get_widget('mnameentry')
		commentEntry = self.tree.get_widget('mcommententry')
		iconButton = self.tree.get_widget('miconbutton')
		iconButton.set_pixmap_subdir(item.iconPath)
		originalValues = (
			item.getKey('Name'), item.getKey('Comment'), item.iconPath
			)
		nameEntry.set_text(item.getKey('Name'))
		commentEntry.set_text(item.getKey('Comment'))
		iconButton.set_filename(item.iconPath)
		menuDialog.show()
		def checkResponse(response):
			if response == gtk.RESPONSE_OK:
				if len(nameEntry.get_text()) == 0:
					self.showError(menuDialog, _('A name is required.'))
					return False
				if nameEntry.get_text() == 'Other':
					self.showError(
						menuDialog, _('A menu can\'t be named "Other".')
						)
					return False
				return True
			elif response == gtk.RESPONSE_REJECT:
				nameEntry.set_text(originalValues[0])
				commentEntry.set_text(originalValues[1])
				iconButton.set_filename(originalValues[2])
				self.saveMenu(originalValues)
				self.tree.get_widget('mrevertbutton').set_sensitive(False)
				return False
		code = False
		while code == False:
			response = menuDialog.run()
			code = checkResponse(response)
		self.resetMenu = True
		self.resetMenuDialog()
		self.resetMenu = False
		self.count = 0
		self.item = None

	def resetMenuDialog(self):
		self.tree.get_widget('mrevertbutton').set_sensitive(False)
		menuDialog = self.tree.get_widget('menudialog')
		nameEntry = self.tree.get_widget('mnameentry')
		commentEntry = self.tree.get_widget('mcommententry')
		iconButton = self.tree.get_widget('miconbutton')
		nameEntry.set_text('')
		commentEntry.set_text('')
		iconButton.set_filename('')
		menuDialog.hide()

	def newEntryDialog(self):
		self.setupEntry = True
		entryDialog = self.tree.get_widget('newentrydialog')
		entryDialog.set_icon(self.icon)
		nameEntry = self.tree.get_widget('enewnameentry')
		commentEntry = self.tree.get_widget('enewcommententry')
		commandEntry = self.tree.get_widget('enewcommandentry')
		commandEntry.gtk_entry().connect(
			'key-press-event', self.on_ecommandentry_event
			)
		commandEntry.gtk_entry().set_completion(self.completion)
		iconButton = self.tree.get_widget('enewiconbutton')
		termCheck = self.tree.get_widget('etermcheck')
		self.setupEntry = False
		entryDialog.show()
		def checkResponse(response):
			if response == gtk.RESPONSE_OK:
				if len(nameEntry.get_text()) == 0:
					self.showError(entryDialog, _('A name is required.'))
					return False
				if len(commandEntry.gtk_entry().get_text()) == 0:
					self.showError(entryDialog, _('A command is required.'))
					return False
				return True
			elif response == gtk.RESPONSE_CANCEL:
				return None
		code = False
		while code == False:
			response = entryDialog.run()
			code = checkResponse(response)
		if code == True:
			returnValue = (
				nameEntry.get_text(), commentEntry.get_text(),
				commandEntry.gtk_entry().get_text(), iconButton.get_filename(),
				termCheck.get_active()
				)
		else:
			returnValue = (None, None, None, None, None)
		self.resetNewEntryDialog()
		return returnValue

	def resetNewEntryDialog(self):
		entryDialog = self.tree.get_widget('newentrydialog')
		nameEntry = self.tree.get_widget('enewnameentry')
		commentEntry = self.tree.get_widget('enewcommententry')
		commandEntry = self.tree.get_widget('enewcommandentry')
		iconButton = self.tree.get_widget('enewiconbutton')
		termCheck = self.tree.get_widget('enewtermcheck')
		nameEntry.set_text('')
		commentEntry.set_text('')
		commandEntry.set_filename('')
		iconButton.set_filename('')
		termCheck.set_active(0)
		entryDialog.hide()

	def editEntryDialog(self, item):
		self.count = 0
		self.setupEntry = True
		self.resetEntry = False
		self.item = item
		entryDialog = self.tree.get_widget('entrydialog')
		entryDialog.set_icon(self.icon)
		nameEntry = self.tree.get_widget('enameentry')
		commentEntry = self.tree.get_widget('ecommententry')
		commandEntry = self.tree.get_widget('ecommandentry')
		commandEntry.gtk_entry().connect(
			'key-press-event', self.on_ecommandentry_event
			)
		commandEntry.gtk_entry().set_completion(self.completion)
		iconButton = self.tree.get_widget('eiconbutton')
		iconButton.set_pixmap_subdir(item.iconPath)
		termCheck = self.tree.get_widget('etermcheck')
		originalValues = (
			item.getKey('Name'), item.getKey('Comment'), item.getKey('Exec'),
			item.iconPath, item.getKey('Terminal')
			)
		nameEntry.set_text(item.getKey('Name'))
		commentEntry.set_text(item.getKey('Comment'))
		commandEntry.set_filename(item.getKey('Exec'))
		iconButton.set_filename(item.iconPath)
		if item.getKey('Terminal') == 'true':
			termCheck.set_active(1)
		self.setupEntry = False
		entryDialog.show()
		def checkResponse(response):
			if response == gtk.RESPONSE_CLOSE:
				if len(nameEntry.get_text()) == 0:
					self.showError(entryDialog, "A name is required.")
					return False
				if len(commandEntry.gtk_entry().get_text()) == 0:
					self.showError(entryDialog, "A command is required.")
					return False
				return True
			elif response == gtk.RESPONSE_REJECT:
				nameEntry.set_text(originalValues[0])
				commentEntry.set_text(originalValues[1])
				commandEntry.set_filename(originalValues[2])
				iconButton.set_filename(originalValues[3])
				if originalValues[4] == 'true':
					termCheck.set_active(1)
				self.saveEntry(originalValues)
				self.tree.get_widget('erevertbutton').set_sensitive(False)
				return False
		code = False
		while code == False:
			response = entryDialog.run()
			code = checkResponse(response)
		self.resetEntry = True
		self.resetEntryDialog()
		self.resetEntry = False
		self.count = 0
		self.item = None

	def resetEntryDialog(self):
		self.tree.get_widget('erevertbutton').set_sensitive(False)
		entryDialog = self.tree.get_widget('entrydialog')
		nameEntry = self.tree.get_widget('enameentry')
		commentEntry = self.tree.get_widget('ecommententry')
		commandEntry = self.tree.get_widget('ecommandentry')
		iconButton = self.tree.get_widget('eiconbutton')
		termCheck = self.tree.get_widget('etermcheck')
		nameEntry.set_text('')
		commentEntry.set_text('')
		commandEntry.gtk_entry().set_text('')
		iconButton.set_filename('')
		termCheck.set_active(0)
		entryDialog.hide()
		return False

	def showError(self, parent, message):
		dialog = gtk.MessageDialog(
			parent, 0, gtk.MESSAGE_WARNING, gtk.BUTTONS_CLOSE, None
			)
		dialog.set_title('')
		dialog.set_size_request(400, -1)
		dialog.set_markup('<b>' + cgi.escape(message) + '</b>')
		dialog.run()
		dialog.destroy()

	def saveEntry(self, values):
		if not isinstance(values[4], (str, unicode)):
			if values[4] == True:
				values = (values[0], values[1], values[2], values[3], 'true')
			else:
				values = (values[0], values[1], values[2], values[3], 'false')
		self.item.setKey('Name', values[0])
		self.item.setKey('Comment', values[1])
		self.item.setKey('Exec', values[2])
		self.item.setKey('Icon', values[3])
		self.item.setKey('Terminal', values[4])
		self.item.save()

	def saveMenu(self, values):
		self.item.setKey('Name', values[0])
		self.item.setKey('Comment', values[1])
		self.item.setKey('Icon', values[2])
		self.item.save()

	def on_mcontents_changed(self, widget):
		if self.count < 3:
			self.count += 1
			return
		if self.resetMenu == True:
			return
		self.tree.get_widget('mrevertbutton').set_sensitive(True)
		values = (
			self.tree.get_widget('mnameentry').get_text(),
			self.tree.get_widget('mcommententry').get_text(),
			self.tree.get_widget('miconbutton').get_filename()
			)
		self.saveMenu(values)

	def on_econtents_changed(self, widget):
		if self.count < 4:
			self.count += 1
			return
		if self.resetEntry == True:
			return
		self.tree.get_widget('erevertbutton').set_sensitive(True)
		values = (
			self.tree.get_widget('enameentry').get_text(),
			self.tree.get_widget('ecommententry').get_text(),
			self.tree.get_widget('ecommandentry').gtk_entry().get_text(),
			self.tree.get_widget('eiconbutton').get_filename(),
			self.tree.get_widget('etermcheck').get_active()
			)
		self.saveEntry(values)

	def on_ecommandentry_event(self, entry, event):
		if event.keyval == gtk.keysyms.Tab:
			start, end = entry.get_selection_bounds()
			if start != end and start != 1 and end == len(entry.get_text()):
				entry.select_region(end, end)
				entry.set_position(-1)
				return True
		elif len(entry.get_text()) == 1:
			char = entry.get_text()[0]
			self.used_store.clear()
			for item in self.full_store:
				if item[0][0] == char:
					self.used_store.append([item[0],])
