;--------------------------------
; Album Shaper Installer Script for NSIS
;--------------------------------
!macro BIMAGE IMAGE PARMS
	Push $0
	GetTempFileName $0
	File /oname=$0 "${IMAGE}"
	SetBrandingImage ${PARMS} $0
	Delete $0
	Pop $0
!macroend

;version number
!define VERSION "2.1"

; Use maximal compression - lzma
SetCompressor lzma

; The name of the installer
Name "Album Shaper ${VERSION}"

; Set (Un)Installer icon
Icon "..\resources\win32\installIcon.ico"
UninstallIcon "..\resources\win32\uninstallIcon.ico"

; The file to write
OutFile "AlbumShaper_${VERSION}.exe"

; The default installation directory.
InstallDir "$PROGRAMFILES\Album Shaper ${VERSION}"

; Registry key to check for directory (so if you install again, it will 
; overwrite the old one automatically)
InstallDirRegKey HKLM "SOFTWARE\Album Shaper ${VERSION}" "Install_Dir"

; Text prompting user to select which components to install.
ComponentText "Select components to install:" 

; Text prompting user to select installation directory.
DirText "Choose directory for installing Album Shaper ${VERSION}:"

ShowInstDetails hide
ShowUninstDetails hide
InstProgressFlags smooth

;Set pages order
Page components
Page directory
Page instfiles

;Add top branding image
AddBrandingImage top 100

;Set install colors - black on white
InstallColors 000000 FFFFFF

;--------------------------------
; Tweaks just before installer is shown.
;--------------------------------
Function .onGUIInit
 !insertmacro BIMAGE "installerHeader.bmp" ""
FunctionEnd

;--------------------------------
; Tweaks just before uninstaller is shown.
;--------------------------------
Function un.onGUIInit
 !insertmacro BIMAGE "installerHeader.bmp" ""
FunctionEnd

;--------------------------------
;Main install section, installs binaries, helper files 
;(images, text files language translations, etc)
;--------------------------------
Section "!Album Shaper ${VERSION} (required)"
  SectionIn RO

  ; Set output path to the installation directory.
  SetOutPath $INSTDIR
  
  ;Files to install
  File /r /x CVS ..\bin\images
  File /r /x CVS ..\bin\text
  File /r /x CVS ..\bin\themes
  File /r /x CVS ..\bin\translations
  File /r /x CVS ..\bin\xmlConversion
  File ..\bin\AlbumShaper.exe
  File ..\bin\qt-mt334.dll
  ;;;File C:\Qt\3.2.1NonCommercial\lib\qt-mtnc321.dll

  ;setup uninstall target
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\AlbumShaper_${VERSION}" "DisplayName" "Album Shaper ${VERSION}"
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\AlbumShaper_${VERSION}" "UninstallString" '"$INSTDIR\uninstall.exe"'
  SetOutPath $INSTDIR
  WriteUninstaller "uninstall.exe"  
SectionEnd
;--------------------------------
; Start Menu Entries
;--------------------------------
Section "Start Menu Entry"
  CreateDirectory "$SMPROGRAMS\Album Shaper ${VERSION}"  
  CreateShortCut "$SMPROGRAMS\Album Shaper ${VERSION}\Album Shaper ${VERSION}.lnk" "$INSTDIR\AlbumShaper.exe" ""
  CreateShortCut "$SMPROGRAMS\Album Shaper ${VERSION}\Uninstall Album Shaper ${VERSION}.lnk" "$INSTDIR\uninstall.exe" ""
SectionEnd
;--------------------------------
; Quick Launch Entries
;--------------------------------
Section "Quick Launch Shortcut"
  CreateShortCut "$QUICKLAUNCH\Album Shaper ${VERSION}.lnk" "$INSTDIR\AlbumShaper.exe" ""
SectionEnd
;--------------------------------
; Uninstaller
;--------------------------------
UninstallText "This will uninstall Album Shaper ${VERSION}. Hit next to continue."

Section "Uninstall"

  DeleteRegKey HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\AlbumShaper_${VERSION}"
  RMDir /r "$SMPROGRAMS\Album Shaper ${VERSION}"
  Delete "$QUICKLAUNCH\Album Shaper ${VERSION}.lnk"
  RMDir /r $INSTDIR

  IfFileExists "$INSTDIR" 0 NoErrorMsg
    MessageBox MB_OK "Note: $INSTDIR could not be removed!" IDOK 0 ; skipped if file doesn't exist
  NoErrorMsg:

SectionEnd
