//==============================================
//  copyright            : (C) 2003-2005 by Will Stokes
//==============================================
//  This program is free software; you can redistribute it 
//  and/or modify it under the terms of the GNU General 
//  Public License as published by the Free Software 
//  Foundation; either version 2 of the License, or  
//  (at your option) any later version.         
//==============================================

#ifndef BACKEND_MANIPULATIONS_EDGEDETECTOR_H
#define BACKEND_MANIPULATIONS_EDGEDETECTOR_H

//--------------------
//forward declarations
//--------------------
class QImage;

//--------------------
typedef struct
{
  float ESF;
  int direction;
} LUTentry;
//--------------------
typedef struct
{
  int minLuminance;
  int maxLuminance;

  int edgeMagHistogram[256];
  float totalEdgeMagnitude;
  int numPixels;

  //normalized inputs for fuzzy logic process
  float meanMode;
  float mode;
  float pixelCount;
  
  float beta;
  float edgeThreshold;
  
} PixelCluster;
//--------------------
class EdgeDetect
{
public:
  EdgeDetect( QImage* image );
  ~EdgeDetect(); 
  int getNumClusters();
  PixelCluster* getClusters();
  int* getSmoothHist();
  int* getPeaks();
  QImage* getEdgeImage();
  int* getClusterMap();
  //----------------------
private:
  void allocateAndInitObjects();
  
  //construct a lookup table indexed by computed GSLC codes for applying N(on) M(aximum) S(uppression)
  void constructGSLClut();
  
  //iterate over each pixel computing luminance values for lum map and update lum histogram
  void fillLumMapAndLumHistogram();
  
  //fill smooth lum histogram using lum histogram
  void smoothLumHistogram();
  
  //compute edge magnitude, and GSLC for each pixel
  void computeEdgeMagAndGSLCmaps();
    
  //get pixel luminance for an abritrary pixel, clamping of coordinates performed automatically
  int pixelLum(int x, int y);
  
  //determine pixel clusters using smooth lum histogram
  void findPixelClusters();

  //compute cluster stats by iterating over image luminance map
  void computeClusterStatistics();
  
  //compute edge thresholds for each cluster using 18-rule fuzzy logic approach
  void computeClusterThresholds();
  
  //replace image with blurred-normalized edge image
  void constructEdgeImage();
  
  void deallocateObjects();
  //----------------------
  //GSLC LUT table
  LUTentry LUT[256];

  //loaded image
  QImage* image;
  
  ///luminosity and smooth luminosity histograms
  int lumHist[256];
  int smoothLumHist[256];

  //cluster peaks
  int clusterPeaks[256];

  //luminance map
  int* lumMap;

  //edge magnitude map
  float* edgeMagMap;
  
  //GSLC map
  int* GSLCmap; 

  //pixel clusters
  int numClusters;
  PixelCluster* clusters;
  
  //min and max # of pixels in clusters
  int minClusterSize, maxClusterSize;
//----------------------
};
//======================

#endif //BACKEND_MANIPULATIONS_EDGEDETECTOR_H
