//==============================================
//  copyright            : (C) 2003-2005 by Will Stokes
//==============================================
//  This program is free software; you can redistribute it
//  and/or modify it under the terms of the GNU General
//  Public License as published by the Free Software
//  Foundation; either version 2 of the License, or
//  (at your option) any later version.
//==============================================

#ifndef GUI_STATUSWIDGET_H
#define GUI_STATUSWIDGET_H

//--------------------
//forward declarations
class QGridLayout;
class QLabel;
class QFrame;
class QProgressBar;
class QTimer;
class ClickableLabel;
//--------------------

#include <qwidget.h>
#include <qhttp.h>

//=====================================
class StatusWidget : public QWidget
{
Q_OBJECT
//----------------------
public:
  ///Creates layout
  StatusWidget(QWidget *parent=0, const char* name=0);

  ///Deletes all objects
  ~StatusWidget();

  ///Initializes the progress bar
  void showProgressBar(QString message, int numSteps);

  ///Updates the progress bar
  void updateProgress(int progress, 
                      QString newMessage=QString::null);

  ///Returns current progress in steps
  int currentProgress();
  
  ///Updates the progress bar by one step
  void incrementProgress();

  ///Update message
  void setStatus( QString message );

  ///Check for updates
  void checkForUpdates();

  ///Remove program updates icon
  void removeUpdatesIcon();
  
  //grab user input
  void grabInput();
  
  //release user input
  void releaseInput();
//----------------------
private slots:
  ///called once a file is fetched from the network
  void fileFetched(bool error);

  ///Unset message
  void removeStatus();
//----------------------
private:
  ///Layout widgets placed in
  QGridLayout* grid;

  QLabel* message;
  QProgressBar* progressBar;
  int curStep;

  QTimer* timer;
//----------------------
///http object for fetching releases file, used to check to see if installed copy is up to date
QHttp http;

///Update available label
ClickableLabel* updateAvailable;
//----------------------

};
//======================

#endif //GUI_STATUSWIDGET_H
