//==============================================
//  copyright            : (C) 2003-2005 by Will Stokes
//==============================================
//  This program is free software; you can redistribute it
//  and/or modify it under the terms of the GNU General
//  Public License as published by the Free Software
//  Foundation; either version 2 of the License, or
//  (at your option) any later version.
//==============================================

#ifndef GUI_SUBALBUMWIDGET_H
#define GUI_SUBALBUMWIDGET_H

//--------------------
//forward declarations
class QGridLayout;
class QPixmap;
class QIconView;
class PhotosIconView;
class QToolButton;
class QFrame;
class Subalbum;
class LayoutWidget;
class Photo;

class QIconViewItem;
//--------------------

#include <qwidget.h>

//=====================================
/*! \brief Displays subalbum layout
 */
//=====================================
class SubalbumWidget : public QWidget
{
Q_OBJECT

public:
  ///Creates layout based on backend object
  SubalbumWidget(Subalbum* salbum,
                 QWidget *parent=0,
                 const char* name=0);

  ///Resets the subalbum this subalbum widget is displaying
  void setSubalbum(Subalbum* salbum);

  ///clears and reinserts all photos for the current collection
  ///the current selection is cleared
  void refreshPhotos();

  ///refreshes all photos, selections are preserved
  void refreshAllPhotos();
  
  ///refreshes selected photos, selections are preserved
  void refreshSelectedPhotos();

  ///returns a pointer to the backend subalbum
  Subalbum* getSubalbum();

  ///Returns currently selected photo. If no or multiple photos selected returns NULL
  Photo* getSelectedPhoto();

  ///Sets the selected photo to selection and ensures it is visible
  void setSelectedPhoto(Photo* selection);
  
  ///Returns first selected photo
  Photo* getFirstSelectedPhoto();
  
  ///Returns true if any phtos are selected
  bool anyPhotosSelected();

  ///Returns true if any selected photos are revertable
  bool anySelectedPhotosRevertable();
  
  ///Returns pointer to icon view
  QIconView* getPhotos();

  ///Activates/Deactives remove/rotate buttons
  void updateButtons(bool enable);

 ///Strip descriptions from selected photos
 void stripDescriptionsFromSelectedPhotos();

 ///Revert selected photos to their original form
 void revertSelectedPhotos();
//----------------------
signals:
 //signal emitted when the selection or the state of the selection changes  
 void selectedPhotoStateChanged();    
//----------------------
private slots:
  ///set desktop wallpaper
  void setWallpaperAction();

  ///handles changing selections
  void selectionChangedEvent();
  
  ///Activates/Deactives remove/rotate buttons depending on if an image is selected
  void updateButtons();

  ///Adds an image to the subalbum
  void addImageAction();
  void addImageAction(QStringList fileNames, bool setDescriptions=false);

  ///Remove an image from the subalbum
  void removeImageAction();

  ///Rotate clockwise selected images
  void rotate90ImageAction();

  ///Rotate counter-clockwise selected images
  void rotate270ImageAction();

  //Rearranges subalbums in grid
  void reorder();
  
  //Deselect all photos
  void deselectAll();
  //----------------------
protected:
    void resizeEvent( QResizeEvent * );
  //----------------------
private:
  ///Grids widgets are placed in
  QGridLayout* mainGrid;
  QGridLayout* buttonsGrid;

  ///Grid lower buttons are placed in
  QFrame* thumbnailFrame;
  QFrame* buttonsFrame;

  ///Photos layout
  PhotosIconView* photos;

  ///Pointer to backend subalbum
  Subalbum* subalbum;

  ///"Add" button
  QToolButton* addImage;

  ///"Remove" button
  QToolButton* removeImage;

  ///"Rotate 90" button
  QToolButton* rotate90Image;

  ///"Rotate 270" button
  QToolButton* rotate270Image;
  
  ///Set desktop wallpaper button
  QToolButton* setDesktopBtn;

  ///Pointer to the parent layout widget
  LayoutWidget* layout;

  ///cached enabled/disabled state of buttons
  bool buttonsState;
  
  ///cached enabled/distable state of set wallpaper button
  bool wallpaperButtonState;
//----------------------
};
//======================

#endif //GUI_SUBALBUMWIDGET_H
