# This is a simple sample of URL handler
# This module is a part of alicq ICQ client

parameter http {xterm -e lynx}
parameter ftp {xterm -e lynx}

proc UrlHandler {txt} {
	set URL [eval $txt get [$txt tag prevrange url current]]
	regexp {^([^:]*):.*$} $URL URL protocol
	variable $protocol
	if {[info exists protocol]} { eval exec [set $protocol] {$URL} & }
}
proc InitFilter {txt} {
	$txt tag configure url -foreground blue -underline yes
	set cursor [$txt cget -cursor]
	$txt tag bind url <Enter> "$txt configure -cursor hand2" 
	$txt tag bind url <1> "url::UrlHandler $txt" 
	$txt tag bind url <Leave> "$txt configure -cursor $cursor" 
}
proc RunFilter {txt idx1 idx2} {
	while {[set idx1 [$txt search -count len -regexp {(http|ftp|)://[^ ]*} $idx1 $idx2]]!=""} {
		$txt tag add url $idx1 "$idx1 + $len char"
		set idx1 [$txt index "$idx1 + $len char"]
	}
}

if [info exists env(BROWSER)] {
		set http "{$env(BROWSER)}"
}
Hook InitDisplayFilter url::InitFilter 
Hook DisplayFilter url::RunFilter 
