set tmp "/tmp/msg1"
set tmp2 "/tmp/msg2"
variable pgp_passphrase

proc EncodeMessage_PGP {message key} {
	set f [open "|gpg --batch --yes -r $key --armour -o $crypt::tmp -e" w]
	puts $f $message; close $f
	set f [open $crypt::tmp r]; set output [read -nonewline $f]; close $f
	return $output
}

proc DecodeMessage_PGP {message key} {
	set f [open $crypt::tmp w]; puts $f $message; close $f
	if [file exists $crypt::tmp2] {file delete $crypt::tmp2}
	set output "Error decoding message"
	catch {
		set f [open "|gpg --batch --no-tty --yes --passphrase-fd 0 -r $key --armour -o $crypt::tmp2 -d $crypt::tmp" w]
		puts $f $crypt::pgp_passphrase; catch {close $f}
		set f2 [open $crypt::tmp2 r]; set output [read -nonewline $f2]; close $f2
	}
	return $output
}

proc DecodeMessage_XOR {message key} {
	regexp "^---Alicq XOR begin---\n(.*)\n---Alicq XOR end---$" $message s message
	::Log 1 "Decrypting: $message"
	set keylen [string length $key]
	set msglen [string length $message]
	set result {}
	set pos 0
	while 1 {
		for {set i 0} {$i<$keylen} {incr i} {
			binary scan $message @${pos}c char1
			binary scan $key @${i}c char2
			append result [binary format c [expr $char1^$char2]]
			incr pos
			if {$pos==$msglen} { ::Log 1 "Result: $result";return $result}
		}	
	}
}

proc EncodeMessage_XOR {message key} {
	set result [DecodeMessage_XOR $message $key]
	return 	"---Alicq XOR begin---\n$result\n---Alicq XOR end---"
}

proc IncomingMessage {Uin Time Message} {
	switch -regexp -- $Message {	
		{-----BEGIN PGP MESSAGE-----.*-----END PGP MESSAGE-----} {
				set method PGP }
		{^---Alicq XOR begin---.*---Alicq XOR end---$} {
				::Log 1 "Method XOR"
				set method XOR }
		* return 		
	}
	if {![info exists method]||[info procs DecodeMessage_$method]=={}} return

	if [info exists ::Contacts($Uin:Property_key)] {
		set key $::Contacts($Uin:Property_key)	
	} else { ::Log 1 "Can't decrypt message from $Uin: no key"; return}
				
	set Message	[DecodeMessage_$method $Message $key]
	
	return [list $Uin $Time $Message]
}
proc OutgoingMessage {Uin Time Message} {
	if ![info exists ::Contacts($Uin:Property_encryption)] return
	set type $::Contacts($Uin:Property_encryption)
	if {[info exists ::Contacts($Uin:Property_key)]} {
		set Message [EncodeMessage_$type $Message\
			$::Contacts($Uin:Property_key)]
		return [list $Uin $Time $Message]
	}
}
Hook IncomingMessage crypt::IncomingMessage
Hook OutgoingMessage crypt::OutgoingMessage
