#  Alicq ICQ client: encoding module
#  Copyright (C) Ihar Viarheichyk 2001

#  This module is a part of Alicq ICQ client.

proc GetEncoding {name1 name2 op} {
	upvar 1 $name1 encoding
	# Default value is system encoding
	set encoding [encoding system]
	# Use encodings beginnig with CP on the wire
	if {[string match cp* $encoding]} return
	# Trying find wire encoding by the list
	foreach {local wire} {{koi8-r koi8-u iso8859-5} cp1251} {
		if {[lsearch -exact $local $encoding]!=-1} {
			set encoding $wire 
			return
		}
	}
	# If previuos attempts failed, analyse LANG variable
	# (usefull for UTF-8 encoding
	if {[info exists ::env(LANG)]} {
		switch -regex $::env(LANG) {
			"^(be|ru|ua)_" 	{set encoding "cp1251" }
		}
	}
}

trace variable ::encoding r encoding::GetEncoding

