# Retrieve user list 
proc GetLicqUsers {path} {
	global Contacts
	foreach file [glob -directory $path "*.uin"] {	
		set uid [file root [file tail $file]]
		set alias $uid
		set fd [open $file]
		while {![eof $fd]} {
			gets $fd ln
			if {[regexp {Groups.User *= *(.*)$} $ln s groupid]} {
				set gid $groupid 
			}
			if {[regexp {Alias *= *(.*)$} $ln s icqalias]} {
				set alias $icqalias 
			}
		}
		if {![info exists gid]} { set gid 0 }
		set gr {}
		for {set i 1} {$gid!=0} {set gid [expr $gid>>1]; incr i} {
			if {[expr $gid&1]} {
				lappend gr $i
			}
		}
		puts "Contact $uid \{$alias\} \{$gr\}"
	}
}

# Get owner's UIN and password
proc GetLicqOwner {filename} {
	global Contacts
	set fd [open $filename r]
	set attributes {Uin Password Alias}
	while {![eof $fd]} {
		gets $fd ln
		foreach attr $attributes {
			if {[regexp "$attr *= *(.*)$" $ln s value]} {
				set Contacts(me:$attr) $value
			}
		}
	}
}

proc GetLicqGroups {filename} {
	global ::Groups
	set fd [open $filename r]
	while {![eof $fd]} {
		gets $fd ln
		if {[regexp {^Group([0-9])+\.name *= *(.*)$} $ln s id name]} {
			puts "Group $id \{$name\}"
		}
	}

}

set licqbase [file join ~ .licq]

GetLicqGroups [file join $licqbase licq.conf]
GetLicqUsers [file join $licqbase users]
#GetLicqOwner [file join $licqbase owner.uin]
