# Emoticons module for Alicq IM.
# Author: Ihar Viarheichyk <iverg@mail.ru>

array set mapping {
	smile { :) :-) }
	wink  { ;) ;-) }
	ironic { :-/ :-\\ }
	tongue  { :-P :P :-p :p }
	grin { :-D :)) :-)) }
	sad  { :-( :( }
}

proc ::load_emoticons {name file} {
	image create photo emoticon::$name -file $file
}

handler DisplayMessage Show {txt from to} {
	variable mapping
	foreach {image list} [array get mapping] {
		foreach x $list {
			set i $from
			while {[set i [$txt search -count l $x $i $to]]!={}} {
				$txt tag add emoticon $i "$i + $l char"
				$txt image create $i -image emoticon::$image
				set i [$txt index "$i + $l char"]
			}
		}
	}
}
handler ChatOpen Configure {_ in out} { $in tag configure emoticon -elide yes }
resource emoticons [array names mapping]

