/* --< aLLtraX-Clock 0.3 >--{ 07 feb 2002 }--
 *
 * Author: aLLtraX (alltrax@users.sourceforge.net)
 *
 * This is my first release on open source, and also my first time with linux coding :)
 * I hope you will enjoy this small plugin for gkrellm.
 *
 * aLLtraX
 *
 * copyright : Your are free to distribute this program under the terms of the GNU GPL.
 */

#include <gkrellm2/gkrellm.h>

#include <stdio.h>
#include <math.h>

#include "alltraxclock.xpm"
#include "alltraxclock2.xpm"

#define CONFIG_NAME				"aLLtraX-Clock2"
#define MONITOR_CONFIG_KEYWORD	"aLLtraXClock2_0.2"
#define STYLE_NAME				"aLLtraX"

#define	MIN_GRID_RES	2
#define	MAX_GRID_RES	50

GkrellmMonitor     *mon;
GkrellmChart       *chart;
GkrellmChartdata   *plugin_cd;
GkrellmChartconfig *chart_config;

static gint	plugin_style_id;

static int g_nWidth =40;
static int g_nHeight = 42;

GdkBitmap* g_pClockMask = NULL;
int g_nClockMask = 0;

GdkColor* g_pBgColor = NULL;
GdkColor* g_pPointerColor = NULL;
GdkColor* g_pSecondHandColor = NULL;

gint g_nSecondHandSize = 18;
gint g_nBigHandSize = 17;
gint g_nLittleHandSize = 12;

gdouble g_dHours = 0;
gdouble g_dMinutes = 0;
gdouble g_dSeconds = 0;

static void load_clock_mask(int i)
{
   GdkPixmap* pTmpPix = NULL;
   
   if (g_pClockMask) gdk_bitmap_unref(g_pClockMask);
   g_pClockMask = NULL;
   
   switch (i)
   {
   case 1 :
      pTmpPix = gdk_pixmap_create_from_xpm_d(chart->drawing_area->window, &g_pClockMask, NULL, alltraxclock2_xpm);
      break;
   default :
      pTmpPix = gdk_pixmap_create_from_xpm_d(chart->drawing_area->window, &g_pClockMask, NULL, clock_xpm);
      break;
   }
   
   if (pTmpPix) gdk_pixmap_unref(pTmpPix);
}

static void draw_plugin_chart(void)
{
   GdkGCValues gc_values;
   GdkGC* pGC = chart->drawing_area->style->fg_gc[GTK_WIDGET_STATE (chart->drawing_area)];
   
   int second_hand_x    = (int) (sin((g_dSeconds * 3.14159 * 2) / 60) * g_nSecondHandSize);
   int second_hand_y    = (int) (cos((g_dSeconds * 3.14159 * 2) / 60) * g_nSecondHandSize);
   int big_hand_x       = (int) (sin((g_dMinutes * 3.14159 * 2) / 60) * g_nBigHandSize);
   int big_hand_y       = (int) (cos((g_dMinutes * 3.14159 * 2) / 60) * g_nBigHandSize);
   int little_hand_x    = (int) (sin((g_dHours * 3.14159 * 2) / 12) * g_nLittleHandSize);
   int little_hand_y    = (int) (cos((g_dHours * 3.14159 * 2) / 12) * g_nLittleHandSize);
   
   gdk_gc_get_values(pGC ,&gc_values);
   
   /* Draw the chart bg
   */
   
   gkrellm_clear_chart(chart);
   if (g_pClockMask)
   {
      gdk_gc_set_clip_origin(pGC, g_nWidth/2 - 30, 1);
      gdk_gc_set_clip_mask(pGC, g_pClockMask);

      gdk_gc_get_values(pGC ,&gc_values);
      gdk_gc_set_foreground(pGC,	g_pBgColor);

      gdk_draw_rectangle(chart->pixmap, pGC, TRUE, 0, 1, g_nWidth, g_nHeight-1);

      gdk_gc_set_foreground(pGC,	&gc_values.foreground);
      gdk_gc_set_clip_mask(pGC, NULL);
   }	
   
   /* Draw big & little hands.
   */
   
   gdk_gc_set_foreground(pGC,	g_pPointerColor);
   
   gdk_draw_line(chart->pixmap,
               pGC,
               g_nWidth/2, g_nHeight/2,
               g_nWidth/2 + big_hand_x, g_nHeight/2 - big_hand_y);
   gdk_draw_line(chart->pixmap,
               pGC,
               g_nWidth/2+1, g_nHeight/2+1,
               g_nWidth/2 + big_hand_x, g_nHeight/2 - big_hand_y);
   
   gdk_draw_line(chart->pixmap,
               pGC,
               g_nWidth/2, g_nHeight/2,
               g_nWidth/2 + little_hand_x, g_nHeight/2 - little_hand_y);
   gdk_draw_line(chart->pixmap,
               pGC,
               g_nWidth/2+1, g_nHeight/2+1,
               g_nWidth/2 + little_hand_x, g_nHeight/2 - little_hand_y);
   
   /* Draw second hand.
   */
   
   gdk_gc_set_foreground(pGC,	g_pSecondHandColor);
   
   gdk_draw_line(chart->pixmap,
                 pGC,
                 g_nWidth/2, g_nHeight/2,
                 g_nWidth/2 + second_hand_x, g_nHeight/2 - second_hand_y);
   
   gdk_gc_set_foreground(pGC, &gc_values.foreground);
   				  
   gkrellm_draw_chart_to_screen(chart);
}

static void update_plugin(void)
{
   if (GK.second_tick)
   {
      struct tm* pTime = NULL;

      pTime = gkrellm_get_current_time();
      g_dSeconds = pTime->tm_sec;
      g_dMinutes = pTime->tm_min + g_dSeconds/60.0;
      g_dHours = pTime->tm_hour + g_dMinutes/60.0;

      draw_plugin_chart();
   }
}

static gint chart_expose_event(GtkWidget *widget, GdkEventExpose *ev)
{
   gdk_draw_pixmap(widget->window,
         widget->style->fg_gc[GTK_WIDGET_STATE (widget)],
         chart->pixmap, ev->area.x, ev->area.y, ev->area.x, ev->area.y,
         ev->area.width, ev->area.height);
   return FALSE;
}

static void chart_click_event(GtkWidget *widget, GdkEventButton *event, gpointer data)
{
   if (event->button == 1)
   {
      g_nClockMask = !g_nClockMask;
      load_clock_mask(g_nClockMask);
   }

   if (event->button == 3)
   {
      gkrellm_open_config_window(mon);
   }
}
	
static void disconnect_plugin()
{
   if (g_pClockMask) gdk_bitmap_unref(g_pClockMask);
   g_pClockMask = NULL;
}

static gint chart_destroy_event(GtkWidget *widget, GdkEventAny *ev)
{
   if (g_pClockMask) gdk_bitmap_unref(g_pClockMask);
   g_pClockMask = NULL;
   return TRUE;
}

static void create_plugin(GtkWidget *vbox, gint first_create)
{
   GkrellmStyle* pStyle = NULL;
   
   if (first_create)
      chart = gkrellm_chart_new0();

   /* Chart heights initially default to 40 if this next call is not made.
   |  Once the user configs the chart, this call has no effect.  Make this
   |  call before the chart is created.
   */
   gkrellm_set_chart_height_default(chart, g_nHeight);
   g_nWidth = gkrellm_chart_width();

   /* The address of a ChartConfig struct pointer must be passed to the create
   |  function.  If the pointer is NULL, a ChartConfig struct will ba
   |  allocated and the pointer updated.  But usually the pointer will not
   |  be NULL if you load a saved chartconfig in load_plugin_config().
   */
   gkrellm_chart_create(vbox, mon, chart, &chart_config);

   /* Set your own chart draw function if you have extra info to draw
   */
   gkrellm_set_draw_chart_function(chart, draw_plugin_chart, NULL);

   gkrellm_disable_plugin_connect(mon, disconnect_plugin);

   gkrellm_alloc_chartdata(chart);

   /* Init chart colors
   */
   //pStyle = gkrellm_chart_style(DEFAULT_STYLE_ID);
   //pStyle = gkrellm_chart_style(STYLE_NAME);plugin_style_id
   pStyle = gkrellm_chart_style(plugin_style_id);
   g_pBgColor = &pStyle->label_tsA.color;
   g_pPointerColor = &pStyle->label_tsA.color;
   g_pSecondHandColor = &pStyle->label_tsB.color;
      
         
   /* Store the clock bg mask
   */	
   load_clock_mask(g_nClockMask);

   if (first_create)
   {
      gtk_signal_connect(GTK_OBJECT(chart->drawing_area),
            "expose_event", (GtkSignalFunc) chart_expose_event, NULL);
            
      gtk_signal_connect(GTK_OBJECT(chart->drawing_area),
            "destroy_event", (GtkSignalFunc) chart_destroy_event, NULL);
            
      gtk_signal_connect(GTK_OBJECT(chart->drawing_area),
            "button_press_event", (GtkSignalFunc) chart_click_event, NULL);
   }
   else
   {
      draw_plugin_chart();
   }
}

/* ---- User Config ---- */

static void save_plugin_config(FILE *f)
{
   fprintf(f, "%s display_mode %d\n", MONITOR_CONFIG_KEYWORD, g_nClockMask);
}

  /* When GKrellM is started up, load_plugin_config() is called if any
  |  config lines for this plugin are found.  The lines must have been
  |  saved by save_plugin_config().  gkrellm_load_chartconfig() must
  |  have the address of a ChartConfig struct pointer.  At this point, the
  |  pointer is almost always NULL and the function will allocate a
  |  ChartConfig struct and update the pointer.  The struct will be
  |  initialized with values from the config line.
  */
static void load_plugin_config(gchar *config_line)
{
   gchar config_keyword[32];
   int display_mode = 0;
   
   sscanf(config_line, "%31s %d\n", config_keyword, &display_mode);
   if (strcmp(config_keyword, "display_mode") == 0)
   {
      g_nClockMask = display_mode;
   }
}

static GtkWidget *plugin_enable_button;

  /* The apply is called whenever the user hits the OK or the Apply
  |  button in the config window.
  */
static void apply_plugin_config(void)
{
   /*printf("load %d : %d\n", n, g_nClockMask);*/
   g_nClockMask = GTK_TOGGLE_BUTTON(plugin_enable_button)->active;
   load_clock_mask(g_nClockMask);
}

static void create_plugin_tab(GtkWidget *tab_vbox)
{
   GtkWidget   *tabs, *text;
   GtkWidget   *vbox, *vbox1;
   gchar *plugin_about_text;

	/* Create your Gtk user config widgets here.
	*/
   tabs = gtk_notebook_new();
   gtk_notebook_set_tab_pos(GTK_NOTEBOOK(tabs), GTK_POS_TOP);
   gtk_box_pack_start(GTK_BOX(tab_vbox), tabs, TRUE, TRUE, 0);
   
   /* -- Options tab */
   //vbox = gkrellm_create_framed_tab(tabs, "Options");
   vbox = gkrellm_gtk_framed_notebook_page(tabs, "Options");
   vbox1 = gkrellm_gtk_framed_vbox(vbox, "aLLtraX clock options", 4, FALSE, 0, 2);
   gkrellm_gtk_check_button(vbox1, &plugin_enable_button, g_nClockMask,
                        FALSE, 0, "Display numbers");

   /* About tab */
   plugin_about_text = g_strdup(
       "aLLtraX-Clock2 0.2\n"
       "GKrellM analog clock Plugin\n\n"
       "Copyright (C) 2003 aLLtraX\n"
       "alltrax@users.sourceforge.net\n"
       "http://perso.wanadoo.fr/alltrax/\n\n"
       "Released under the GNU General Public License\n");
   vbox = gtk_label_new("About");
   text = gtk_label_new(plugin_about_text);
   gtk_notebook_append_page(GTK_NOTEBOOK(tabs),text,vbox);
   g_free(plugin_about_text);
}

static GkrellmMonitor plugin_mon  =
{
   CONFIG_NAME,			/* Name, for config tab.        */
   0,             	   /* Id,  0 if a plugin           */
   create_plugin,			/* The create_plugin() function */
   update_plugin,			/* The update_plugin() function */
   create_plugin_tab,	/* The create_plugin_tab() config function */
   apply_plugin_config, /* The apply_plugin_config() function      */

   save_plugin_config,		/* The save_plugin_config() function  */
   load_plugin_config,		/* The load_plugin_config() function  */
   MONITOR_CONFIG_KEYWORD,	/* config keyword                     */

   NULL,					/* Undefined 2  */
   NULL,					/* Undefined 1  */
   NULL,					/* private		*/

   MON_CAL,				/* Insert plugin before this monitor.       */
   NULL,					/* Handle if a plugin, filled in by GKrellM */
   NULL					/* path if a plugin, filled in by GKrellM   */
};

GkrellmMonitor* gkrellm_init_plugin(void)
{
   /* This is a good place to initialize plugin variables, but you should
   |  not do anything that assumes your plugin will actually be running.
   |  This routine will be called for all plugins GKrellM finds, but if
   |  the user does not enable the plugin, nothing else will be called.
   */
   plugin_style_id = gkrellm_add_chart_style(&plugin_mon, STYLE_NAME);
   mon = &plugin_mon;
   return &plugin_mon;
}
