#ifndef __ALS4000_H
#define __ALS4000_H

/*
 *  Header file for ALS4000-based cards
 *  Copyright (c) 2000 by Bart Hartgers <bart@etpmod.phys.tue.nl>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include "pcm.h"
#include "mixer.h"
#include "rawmidi.h"

typedef struct snd_stru_als4000dsp als4000dsp_t;
typedef struct snd_stru_als4000mixer als4000mixer_t;

struct snd_stru_als4000mixer
{
	als4000dsp_t     *dsp;
	
	snd_kmixer_element_t *me_mux_mic;
	snd_kmixer_element_t *me_mux_line;
	snd_kmixer_element_t *me_mux_cd;

	snd_kmixer_element_t *me_mux;
	snd_kmixer_element_t *me_in_accu;
	snd_kmixer_element_t *me_out_accu;
	snd_kmixer_element_t *me_playback;
	snd_kmixer_element_t *me_capture;

	snd_kmixer_element_t *me_vol_igain;

	snd_kmixer_element_t *me_in_speaker;
	snd_kmixer_element_t *me_vol_speaker;

	snd_kmixer_element_t *me_in_mic;
	snd_kmixer_element_t *me_vol_mic;
	snd_kmixer_element_t *me_sw1_mic_output;
	snd_kmixer_element_t *me_sw1_mic_input;

	snd_kmixer_element_t *me_in_line;
	snd_kmixer_element_t *me_vol_line;
	snd_kmixer_element_t *me_sw1_line_output;
	snd_kmixer_element_t *me_sw3_line_input;

	snd_kmixer_element_t *me_in_cd;
	snd_kmixer_element_t *me_vol_cd;
	snd_kmixer_element_t *me_sw1_cd_output;
	snd_kmixer_element_t *me_sw3_cd_input;
	
	snd_kmixer_element_t *me_in_synth;
	snd_kmixer_element_t *me_vol_synth;
	snd_kmixer_element_t *me_sw3_synth_input;

	snd_kmixer_element_t *me_vol_pcm;

	snd_kmixer_element_t *me_vol_ogain;

	snd_kmixer_element_t *me_tone;

	snd_kmixer_element_t *me_out_master;
#if 0	
	snd_kmixer_element_t *me_sw1_3dse;
#endif	
	snd_kmixer_element_t *me_vol_master;
	
	spinlock_t mixer_lock;
};

enum {
	ALS4000_MODE_RATELOCK_P=0x0001,
	ALS4000_MODE_RATELOCK_C=0x0002,
	ALS4000_MODE_RATELOCK=0x0003
};

struct snd_stru_als4000dsp
{
	unsigned long	gcr_port;
	unsigned long	sb_port;
	unsigned long	mpu_port;

	unsigned	mode;
	
	int		playback_format;
	int		capture_format;
	
	snd_irq_t	*irqptr;
	snd_dma_t	*dmaptr;
	char		name[32];
	als4000mixer_t	mixer;
	
	snd_card_t	*card;
	snd_pcm_t	*pcm;
	snd_pcm_subchn_t *playback_subchn;
	snd_pcm_subchn_t *capture_subchn;
	snd_kmixer_t	*kmixer;
	snd_rawmidi_t	*rmidi;
	
	spinlock_t	reg_lock;
};

static inline void snd_als4000_gcr_write_addr( unsigned long port, 
					       unsigned reg, u32 val )
{
	outb( reg, port+0x0c ); outl( val, port+0x08 );
}

static inline void snd_als4000_gcr_write( als4000dsp_t *dsp, 
					  unsigned reg, u32 val )
{
	snd_als4000_gcr_write_addr( dsp->gcr_port, reg, val );
}	

static inline u32 snd_als4000_gcr_read_addr( unsigned long port, 
					     unsigned reg )
{
	outb( reg, port+0x0c ); return inl( port+0x08 );
}

static inline u32 snd_als4000_gcr_read( als4000dsp_t *dsp, unsigned reg )
{
	return snd_als4000_gcr_read_addr(dsp->gcr_port,reg);
}

void snd_als4000_mixer_write( als4000dsp_t * codec,
			      unsigned char reg, unsigned char data);
unsigned char snd_als4000_mixer_read( als4000dsp_t * codec, unsigned char reg);

void snd_als4000_interrupt( snd_pcm_t *pcm );
void snd_als4000_set_addr( unsigned long gcr, int sb, int mpu, int opl,
			  int game );
void snd_als4000_disable( snd_pcm_t *pcm );
int snd_als4000dsp_new_pcm(snd_card_t * card,
			   int device,
			   unsigned long gcr_port,
			   snd_irq_t * irqptr,
			   snd_dma_t * dmaptr,
			   snd_rawmidi_t *rmidi,
			   snd_pcm_t ** rpcm);
void snd_als4000_configure( snd_pcm_t *pcm );
int snd_als4000dsp_new_mixer(als4000dsp_t * codec, int device, 
			     snd_pcm_t * pcm, snd_kmixer_t ** rmixer);
#endif
