/*  levelmeter.c
 *  Copyright (C) 1998 Andy Lo A Foe <arloafoe@cs.vu.nl>
 *  Original code by Tinic Uro
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/ 
#include <dirent.h>
#include <sys/stat.h>
#include <gtk/gtk.h>
#include <sys/time.h>
#include <time.h>   
#include <math.h>
#include <stdio.h>
#include <unistd.h>
#include <malloc.h>
#include <string.h>
#include <assert.h>
#include <pthread.h>
#include "scope_config.h"

static char actlEq[257];
static char oldlEq[257];       
static char actrEq[257];
static char oldrEq[257];

static char scX[256];
static char scY[256];     

static GdkImage *image = NULL;
static GtkWidget *scope_win = NULL;
static pthread_t levelmeter_thread;
static pthread_mutex_t levelmeter_mutex;
static gint is_init = 0;
static gint running = 0;/* this global variable determines when
			   and if we should exit the thread loop.
			   we should always exit gracefully from
			   the looper thread or else we might hold
		           the global GDK thread lock (a very shitty hack)
                           and lock our whole app */


static void levelmeter_hide();

static void levelmeter_set_data(void *audio_buffer, int size)
{
	short i;
	short *sound = (short *)audio_buffer;
	
	if (running && sound) {
		char *newsetl = actlEq;
	        char *newsetr = actrEq;
		int bufsize=size/512;
        	for(i=0;i<256;i++) {
                	*newsetl++=(char)((int)(*(sound  ))>>8);
                	*newsetr++=(char)((int)(*(sound+1))>>8);
                	sound+=bufsize;
        	}
        }
}


static void levelmeter32(GtkWidget *win)
{
	static int oldr = 0;
	static int oldl = 0;
	guint32 disp[256];
	guint32 *bits;
	char *oldsetl = oldlEq;
	char *newsetl = actlEq;
	char *oldsetr = oldrEq;
	char *newsetr = actrEq;
	gint levell, levelr; 
	gint maxl = 0, maxr = 0, count = 0; 
	guint32 colEq[65];
	gint i, w;
	GdkColormap *c;
	GdkVisual *v;
	GdkGC *gc;
	GdkColor bg_color;
	guint32 *cols = colEq;

	gdk_threads_enter();
	c = gtk_widget_get_colormap(win);
	gc = gdk_gc_new(win->window);
	v = gtk_widget_get_visual(win);


	for (i = 0; i < 32; i++) {
		GdkColor color;
		color.red = (i*8) << 8;
		color.green = 255 << 8;
		color.blue = 0;
	        gdk_color_alloc(c, &color);
		colEq[i] = color.pixel; 
		color.red = 255 << 8;
		color.green = ((31 - i) * 8) << 8;
		color.blue = 0;
		gdk_color_alloc(c, &color);
		colEq[i + 32] = color.pixel;
  	}

	// Create render image
	if (image)
		gdk_image_destroy(image);
	image = gdk_image_new(GDK_IMAGE_FASTEST, v, 256, 41);
	bg_color.red = SCOPE_BG_RED << 8;
	bg_color.blue = SCOPE_BG_BLUE << 8;
	bg_color.green = SCOPE_BG_GREEN << 8;
	gdk_color_alloc(c, &bg_color);
	gdk_threads_leave();

	for (i = 0; i < 256; i+=4) {
		disp[i]=cols[i>>2];
		disp[i+1]=cols[i>>2];
		disp[i+2]=cols[i>>2];
		disp[i+3]=0;
	}

	assert(image);
	assert(image->bpp == 4); 
	
	bits = (guint32 *)image->mem;	

	running = 1;

	while (running) {
		for (w=0; w < 256 * 41; w++) {
                        bits[w] = bg_color.pixel;
                }

		memcpy(oldsetl, newsetl, 256);
		memcpy(oldsetr, newsetr, 256);

		count++;

		if (count > 30) {
			count = 0;
			maxl = 0;
			maxr = 0;
		}
		levell = 0;
		for (i = 0; i < 256; i++) {
			if (oldsetl[i] > 0) {
				levell=MAX(levell,oldsetl[i]);
			} else {
				levell=MAX(levell,-oldsetl[i]);
			}
		}

		levelr = 0;
		for (i = 0; i < 256; i++) {
			if (oldsetr[i] > 0) {
				levelr=MAX(levelr, oldsetr[i]);
			} else {
				levelr=MAX(levelr,-oldsetr[i]);		
			}
		}
		levelr >>= 1;
		levell >>= 1;
			
		if (oldr > 0 && (oldr-=4) > levelr) 
				levelr = oldr;
		else oldr = levelr;

		if (oldl > 0 && (oldl-=4) > levell)
				levell = oldl;
		else oldl = levell;

		
		for (i = 3; i < 19; i++) {
			memcpy(bits + (i << 8), disp, levell<<4);
		}
		for (i = 21; i < 37; i++) {
			memcpy(bits + (i << 8), disp, levelr<<4);
		}

		if (maxl < levell<<2) {
			maxl = (levell<<2)-4;
			count = 0;
		}
		if (maxr < levelr<<2) {
			maxr = (levelr<<2)-4;
			count = 0;
		}

		for (i = 3; i < 19; i++) {
			if (maxl > 0)
				memcpy(bits + (i << 8) + maxl, disp+maxl, 4 << 2);
		}
		for (i = 21; i < 37; i++) {
			if (maxr > 0)
				memcpy(bits + (i << 8) + maxr, disp+maxr, 4 << 2);
		}

		gdk_threads_enter();
		gdk_draw_image(win->window,gc,image,0,0,0,0,-1,-1); 
		gdk_flush();
		gdk_threads_leave();
		dosleep(SCOPE_SLEEP);
	}
	gdk_threads_enter();
	gdk_gc_destroy(gc);
	levelmeter_hide();
	gdk_threads_leave();
}


static void levelmeter16(GtkWidget *win)
{
	static int oldl = 0;
	static int oldr = 0;
	guint16 disp[256];
	char *oldsetl = oldlEq;
	char *newsetl = actlEq;
	char *oldsetr = oldrEq;
	char *newsetr = actrEq;
	guint16 *bits;
	int levell, levelr; 
	int maxl = 0, maxr = 0, count = 0; 
	guint16 colEq[65];
	int i, w;
	GdkColormap *c;
	GdkVisual *v;
	GdkGC *gc;
	GdkColor bg_color;
	guint16 *cols = colEq;

	gdk_threads_enter();
	c = gtk_widget_get_colormap(win);
	gc = gdk_gc_new(win->window);
	v = gtk_widget_get_visual(win);

	for (i = 0; i < 32; i++) {
		GdkColor color;
		color.red = (i*8) << 8;
		color.green = 255 << 8;
		color.blue = 0;
	        gdk_color_alloc(c, &color);
		colEq[i] = color.pixel; 
		color.red = 255 << 8;
		color.green = ((31 - i) * 8) << 8;
		color.blue = 0;
		gdk_color_alloc(c, &color);
		colEq[i + 32] = color.pixel;
  	}

	// Create render image
	if (image)
		gdk_image_destroy(image);
	image = gdk_image_new(GDK_IMAGE_FASTEST, v, 256, 41);
	bg_color.red = SCOPE_BG_RED << 8;
	bg_color.blue = SCOPE_BG_BLUE << 8;
	bg_color.green = SCOPE_BG_GREEN << 8;
	gdk_color_alloc(c, &bg_color);
	gdk_threads_leave();

	for (i = 0; i < 256; i+=4) {
		disp[i]=cols[i>>2];
		disp[i+1]=cols[i>>2];
		disp[i+2]=cols[i>>2];
		disp[i+3]=0;
	}

	assert(image);
	assert(image->bpp == 2); 
	
	bits = (guint16 *)image->mem;	

	running = 1;
	
	while (running) {
		for (w=0; w < 256 * 41; w++) {
                        bits[w] = bg_color.pixel;
                }

		memcpy(oldsetl, newsetl, 256);
		memcpy(oldsetr, newsetr, 256);

		count++;

		if (count > 30) {
			count = 0;
			maxl = 0;
			maxr = 0;
		}
		levell = 0;
		for (i = 0; i < 256; i++) {
			if (oldsetl[i] > 0) {
				levell=MAX(levell,oldsetl[i]);
			} else {
				levell=MAX(levell,-oldsetl[i]);
			}
		}

		levelr = 0;
		for (i = 0; i < 256; i++) {
			if (oldsetr[i] > 0) {
				levelr=MAX(levelr, oldsetr[i]);
			} else {
				levelr=MAX(levelr,-oldsetr[i]);		
			}
		}
		levelr >>= 1;
		levell >>= 1;
		
		if (oldr > 0 && (oldr-=4) > levelr) 
				levelr = oldr;
		else oldr = levelr;

		if (oldl > 0 && (oldl-=4) > levell)
				levell = oldl;
		else oldl = levell;

		
		for (i = 3; i < 19; i++) {
			memcpy(bits + (i << 8), disp, levell<<3);
		}
		for (i = 21; i < 37; i++) {
			memcpy(bits + (i << 8), disp, levelr<<3);
		}
		if (maxl < levell<<2) {
			maxl = (levell<<2)-4;
			count = 0;
		}
		if (maxr < levelr<<2) {
			maxr = (levelr<<2)-4;
			count = 0;
		}

		for (i = 3; i < 19; i++) {
			if (maxl > 0)
				memcpy(bits + (i << 8) + maxl, disp+maxl, 4 << 1);
		}
		for (i = 21; i < 37; i++) {
			if (maxr > 0)
				memcpy(bits + (i << 8) + maxr, disp+maxr, 4 << 1);
		}

		gdk_threads_enter();
		gdk_draw_image(win->window ,gc,image,0,0,0,0,-1,-1); 
		gdk_flush();
		gdk_threads_leave();
		dosleep(SCOPE_SLEEP);
	}
	gdk_threads_enter();
	gdk_gc_destroy(gc);
	levelmeter_hide();
	gdk_threads_leave();
}


static void levelmeter8(GtkWidget *win)
{
	guint8 disp[256];
	char *oldsetl = oldlEq;
	char *newsetl = actlEq;
	char *oldsetr = oldrEq;
	char *newsetr = actrEq;
	guint8 *bits;
	int levell, levelr; 
	int maxl = 0, maxr = 0, count = 0; 
	guint8 colEq[65];
	int i, w;
	GdkColormap *c;
	GdkVisual *v;
	GdkGC *gc;
	GdkColor bg_color;
	guint8 *cols = colEq;

	gdk_threads_enter();
	c = gtk_widget_get_colormap(win);
	gc = gdk_gc_new(win->window);
	v = gtk_widget_get_visual(win);


	for (i = 0; i < 32; i++) {
		GdkColor color;
		color.red = (i*8) << 8;
		color.green = 255 << 8;
		color.blue = 0;
	        gdk_color_alloc(c, &color);
		colEq[i] = color.pixel; 
		color.red = 255 << 8;
		color.green = ((31 - i) * 8) << 8;
		color.blue = 0;
		gdk_color_alloc(c, &color);
		colEq[i + 32] = color.pixel;
  	}

	// Create render image
	if (image)
		gdk_image_destroy(image);
	image = gdk_image_new(GDK_IMAGE_FASTEST, v, 255, 41);
	bg_color.red = SCOPE_BG_RED << 8;
	bg_color.blue = SCOPE_BG_BLUE << 8;
	bg_color.green = SCOPE_BG_GREEN << 8;
	gdk_color_alloc(c, &bg_color);
	gdk_threads_leave();

	for (i = 0; i < 256; i+=4) {
		disp[i]=cols[i>>2];
		disp[i+1]=cols[i>>2];
		disp[i+2]=cols[i>>2];
		disp[i+3]=0;
	}

	assert(image);
	assert(image->bpp == 1); 
	
	bits = (guint8 *)image->mem;	

	running = 1;
	
	while (running) {
		for (w=0; w < 255 * 41; w++) {
                        bits[w] = bg_color.pixel;
                }

		memcpy(oldsetl, newsetl, 256);
		memcpy(oldsetr, newsetr, 256);

		count++;

		if (count > 30) {
			count = 0;
			maxl = 0;
			maxr = 0;
		}
		levell = 0;
		for (i = 0; i < 256; i++) {
			if (oldsetl[i] > 0) {
				levell=MAX(levell,oldsetl[i]);
			} else {
				levell=MAX(levell,-oldsetl[i]);
			}
		}

		levelr = 0;
		for (i = 0; i < 256; i++) {
			if (oldsetr[i] > 0) {
				levelr=MAX(levelr, oldsetr[i]);
			} else {
				levelr=MAX(levelr,-oldsetr[i]);		
			}
		}
		levelr >>= 1;
		levell >>= 1;

		
		for (i = 3; i < 19; i++) {
			memcpy(bits + (i << 8), disp, levell<<2);
		}
		for (i = 21; i < 37; i++) {
			memcpy(bits + (i << 8), disp, levelr<<2);
		}

		if (maxl < levell<<2) {
			maxl = (levell<<2)-4;
			count = 0;
		}
		if (maxr < levelr<<2) {
			maxr = (levelr<<2)-4;
			count = 0;
		}

		for (i = 3; i < 19; i++) {
			if (maxl > 0)
				memcpy(bits + (i << 8) + maxl, disp+maxl, 4);
		}
		for (i = 21; i < 37; i++) {
			if (maxr > 0)
				memcpy(bits + (i << 8) + maxr, disp+maxr, 4);
		}

		gdk_threads_enter();
		gdk_draw_image(win->window,gc,image,0,0,0,0,-1,-1); 
		gdk_flush();
		gdk_threads_leave();
		dosleep(SCOPE_SLEEP);
	}
	gdk_threads_enter();
	gdk_gc_destroy(gc);
	levelmeter_hide();
	gdk_threads_leave();
}


static void stop_levelmeter();

static gboolean close_levelmeter_window(GtkWidget *widget, GdkEvent *event, gpointer data)
{
	stop_levelmeter();

	return TRUE;
}


static void popup(GtkWidget *widget, GdkEvent *event, gpointer data)
{
	printf("Bla\n");
}


static GtkWidget *init_levelmeter_window()
{
	int i;

	GtkWidget *levelmeter_win;
	GtkStyle *style;
	GdkColor *color;

	pthread_mutex_init(&levelmeter_mutex, NULL);

	style = gtk_style_new();
	
	levelmeter_win = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(GTK_WINDOW(levelmeter_win), "Levelmeter");
	gtk_widget_set_usize(levelmeter_win, 255, 40);	
	gtk_window_set_wmclass (GTK_WINDOW(levelmeter_win), "Levelmeter", "AlsaPlayer");
        gtk_window_set_policy (GTK_WINDOW (levelmeter_win), FALSE, FALSE, FALSE);  

	// Set bg color, why does this producer suck so much, GTK people?????
	style = gtk_style_copy(gtk_widget_get_style(GTK_WIDGET(levelmeter_win)));
	color = &style->bg[GTK_STATE_NORMAL];
	color->red = SCOPE_BG_RED << 8;
	color->blue = SCOPE_BG_BLUE << 8;
	color->green = SCOPE_BG_GREEN << 8;
        gdk_color_alloc(gtk_widget_get_colormap(GTK_WIDGET(levelmeter_win)), color);
        gtk_widget_set_style(GTK_WIDGET(levelmeter_win), style);
	gtk_widget_set_events(levelmeter_win, GDK_BUTTON_PRESS_MASK);
	
	// Signals

	gtk_signal_connect(GTK_OBJECT(levelmeter_win), "delete_event",
		GTK_SIGNAL_FUNC(close_levelmeter_window), levelmeter_win);
	gtk_signal_connect(GTK_OBJECT(levelmeter_win), "button_press_event",
		GTK_SIGNAL_FUNC(popup), levelmeter_win);

	// Create sin/cos tables
	
	for (i = 0; i < 256; i++) {
                scX[i] = (char) (sin(((2*M_PI)/255)*i)*128);
                scY[i] = (char) (-cos(((2*M_PI)/255)*i)*128);
        } 

	return levelmeter_win;
}  



void levelmeter_hide()
{
	gint x, y;	
	if (scope_win) {
		gdk_window_get_root_origin(scope_win->window, &x, &y);	
		gtk_widget_hide(scope_win);
		gtk_widget_set_uposition(scope_win, x, y);
	}
}


static void stop_levelmeter()
{
	running = 0;
}


static void run_levelmeter(void *data)
{
	GdkVisual *visual;
	
	nice(SCOPE_NICE);	

	gdk_threads_enter();
	visual = gtk_widget_get_visual(scope_win);
	gdk_threads_leave();

	switch (visual->depth) {
		case 8:
			levelmeter8(scope_win);	
			break;
		case 16:
			levelmeter16(scope_win);
			break;
		case 24:	
		case 32:
			levelmeter32(scope_win);
			break;
	}
	//delete sub;
	pthread_mutex_unlock(&levelmeter_mutex);
}



static void start_levelmeter(void *data)
{
    if (!is_init) {
		is_init = 1;
		scope_win = init_levelmeter_window();
	}
	if (pthread_mutex_trylock(&levelmeter_mutex) != 0) {
			printf("levelmeter already running\n");
			return;
	}		
	gtk_widget_show(scope_win);
	pthread_create(&levelmeter_thread, NULL,
		(void * (*)(void *))run_levelmeter, data);
	pthread_detach(levelmeter_thread);
}

static int init_levelmeter()
{
	return 1;
}

static int open_levelmeter()
{
	return 1;
}


static void close_levelmeter()
{
}


static int levelmeter_running()
{
	return running;
}

scope_plugin levelmeter_plugin = {
	SCOPE_PLUGIN_VERSION,
	{ "Levelmeter" },
	{ "Andy Lo A Foe"},
	init_levelmeter,
	open_levelmeter,
	start_levelmeter,
	levelmeter_running,
	stop_levelmeter,
	close_levelmeter,
	levelmeter_set_data
};


scope_plugin *scope_plugin_info()
{
	return &levelmeter_plugin;
}

