//
//  Althea.cpp  --  Althea class functions
//  -- created  4/16/00   updated 4/19/00
////////////////////////////////////////////////

#include <list>
#include <iostream.h>
#include "Althea.h"

Althea gAlthea;
Althea gAlthea_config;

// Copying
void Althea::Althea_to_config ()
{
	gAlthea_config.set_Server_List(gAlthea.get_Server_List());
	gAlthea_config.set_folder_list(gAlthea.get_folder_list());
	gAlthea_config.set_message_list(gAlthea.get_message_list());
	gAlthea_config.set_Server_Config_List(gAlthea.get_Server_Config_List());
	gAlthea_config.set_Filter_Config_List(gAlthea.get_Filter_Config_List());
	gAlthea_config.set_message_text(gAlthea.get_message_text());
	gAlthea_config.set_main_window(gAlthea.get_main_window());
	gAlthea_config.set_config(gAlthea.get_config());
	gAlthea_config.set_Current_Server(gAlthea.get_Current_Server());
	gAlthea_config.set_Config_Current_Server(gAlthea.get_Config_Current_Server());
	gAlthea_config.set_Config_Current_Filter(gAlthea.get_Config_Current_Filter());
	gAlthea_config.set_Current_Folder(gAlthea.get_Current_Folder());
	gAlthea_config.set_Current_Message(gAlthea.get_Current_Message());
	gAlthea_config.set_Verbose(gAlthea.get_Verbose());
	gAlthea_config.filter_list = gAlthea.filter_list;
}


GtkWidget *Althea::get_attach_list()
{
  return( attach_list );
}


 
void Althea::set_attach_list( GtkWidget *a_list )
{
  attach_list = a_list;
}

void Althea::config_to_Althea ()
{
	gAlthea.set_Server_List(gAlthea_config.get_Server_List());
	gAlthea.set_folder_list(gAlthea_config.get_folder_list());
	gAlthea.set_message_list(gAlthea_config.get_message_list());
	gAlthea.set_Server_Config_List(gAlthea_config.get_Server_Config_List());
	gAlthea.set_Filter_Config_List(gAlthea_config.get_Filter_Config_List());
	gAlthea.set_message_text(gAlthea_config.get_message_text());
	gAlthea.set_main_window(gAlthea_config.get_main_window());
	gAlthea.set_config(gAlthea_config.get_config());
	gAlthea.set_Current_Server(gAlthea_config.get_Current_Server());
	gAlthea.set_Config_Current_Server(gAlthea_config.get_Config_Current_Server());
	gAlthea.set_Config_Current_Filter(gAlthea_config.get_Config_Current_Filter());
	gAlthea.set_Current_Folder(gAlthea_config.get_Current_Folder());
	gAlthea.set_Current_Message(gAlthea_config.get_Current_Message());
	gAlthea.set_Verbose(gAlthea_config.get_Verbose());
	gAlthea.filter_list = gAlthea_config.filter_list;
}

int Althea::get_Num_Servers()
{
    return( server_list.size() );
}

char Althea::get_Verbose()
{
    return( verbose );
}

Server * Althea::get_Server( const string &name )
{
    list<Server>::iterator it;
    it = server_list.begin();
    while( it != server_list.end() && (*it).get_Server_Name() != name )
        it++;

    if( (*it).get_Server_Name() == name )
        return( &(*it) );

    else
        return( NULL );
}

list<Server> Althea::get_Server_List() 
{
  return server_list;
}

void Althea::set_Server_List (list<Server> serverlist)
{
	server_list = serverlist;
}

Server * Althea::get_Server( int index )
{
    int count = 1;
    list<Server>::iterator it;
    it = server_list.begin();
    
    while( it != server_list.end() && count < index )
    {
        count++;
        it++;
    }
    
    if( count == index )
        return( &(*it) );

    else
        return( NULL );   
}


GtkWidget *Althea::get_folder_list()
{
    return( folder_list );
}

GtkWidget *Althea::get_Server_Config_List()
{
    return( config_server_list );
}

GtkWidget *Althea::get_Filter_Config_List()
{
    return( config_filter_list );
}

GtkWidget *Althea::get_message_list()
{
    return( message_list );
}

GtkWidget *Althea::get_message_text()
{
    return( message_text );
}

GtkWidget *Althea::get_main_window()
{
    return( main_window );
}

Configuration * Althea::get_config()
{
    return( config );
}

Server * Althea::get_Current_Server()
{
    return( current_server );
}

Server * Althea::get_Config_Current_Server()
{
    return( config_current_server );
}

Filter * Althea::get_Config_Current_Filter()
{
    return( config_current_filter );
}

Folder * Althea::get_Current_Folder()
{
    return( current_folder );
}


Message * Althea::get_Current_Message()
{
    return( current_message );
}

bool Althea::is_Current_Server()
{
    return( current_server != NULL );
}

bool Althea::is_Current_Folder()
{
    return( current_folder != NULL );
}

bool Althea::is_Current_Message()
{
    return( current_message != NULL );
}





void Althea::set_folder_list( GtkWidget *flist )
{
    folder_list = flist;
}

void Althea::set_message_list( GtkWidget *mlist )
{
    message_list = mlist;
}

void Althea::set_Server_Config_List( GtkWidget *server_config_list )
{
    config_server_list = server_config_list;
}

void Althea::set_Filter_Config_List( GtkWidget *filter_config_list )
{
    config_filter_list = filter_config_list;
}

void Althea::set_message_text( GtkWidget *mtext )
{
    message_text = mtext;
}

void Althea::set_main_window( GtkWidget *mwindow )
{
    main_window = mwindow;
}

void Althea::set_config(Configuration *newconfig)
{
    config = newconfig;
}

void Althea::set_Current_Server( Server *S )
{
    current_server = S;
}

void Althea::set_Current_Folder( Folder *F )
{
    current_folder = F;
}

void Althea::set_Config_Current_Server( Server *S )
{
    config_current_server = S;
}

void Althea::set_Config_Current_Filter( Filter *F )
{
    config_current_filter = F;
}


void Althea::set_Current_Message( Message *M )
{
    current_message = M;
}


void Althea::set_Verbose( char v )
{
    verbose = v;
}




void Althea::add_Server( const Server &S )
{
    server_list.push_back( S );
}

void Althea::add_Filter( const Filter &F )
{
    filter_list.push_back( F );
}



void Althea::delete_Server( const string &name )
{
    list<Server>::iterator it;

    it = server_list.begin();
    while( it != server_list.end() && (*it).get_Server_Name() != name )
        it++;

    if( (*it).get_Server_Name() == name )
        server_list.erase( it );
}

void Althea::delete_Filter( const string &name )
{
    list<Filter>::iterator it;

    it = filter_list.begin();
    while( it != filter_list.end() && (*it).filter_string != name )
        it++;

    if( (*it).filter_string == name )
        filter_list.erase( it );
}

// Debugging purposes only

void Althea::display()
{
    list<Server>::iterator it;
    it = server_list.begin();
    while( it != server_list.end() )
    {
        (*it).display();
        cout << "Server: " << (*it).get_Server_Name() << endl;
        it++;
    }
}

void Althea::display_filters()
{
list<Filter>::iterator it;
    it = filter_list.begin();
    while( it != filter_list.end() )
    {
      cout << "Filter String:" << (*it).filter_string << endl;
        it++;
    }

}


