//
// Configuration.cpp - Implementations of the Configuration class
// -- created  4/20/00  updated 4/20/00
//////////////////////////////////////////////////////////////

#include "Configuration.h"

bool Configuration::get_expert_mode()
{
	return expert_mode;
}

unsigned int Configuration::get_key_accelerator(keystrokes key)
{
	return key_accelerators[key];
}

void Configuration::toggle_expert_mode()
{
	expert_mode = !(expert_mode);
}

void Configuration::set_expert_mode()
{
	expert_mode = true;
}

void Configuration::set_beginner_mode()
{
	expert_mode = false;
}

void Configuration::set_key_accelerator(keystrokes key, char accelerator)
{
	// NOTE:  This function is built on the assumption that GDK_a equals
	//	the ascii value of a, and so on. 
	unsigned int helperint = (unsigned int) accelerator;
	key_accelerators[key] = helperint;
}

void Configuration::display()
{
	cout << "Configuration Info." << endl;
	cout << "Expert Mode:  ";
	if (expert_mode)
		cout << "Yes" << endl;
	else
		cout << "No" << endl;
}
