/********************************************************
 * MIME.cpp						*
 * 05.04.00						*
 * Keith Resar						*
 *							*
 * functions for decoding and encoding MIME in		*
 * in base64						*
 ********************************************************/

#include "MIME.h"

// the table to lookup our base64 en/decoding scheme
const string table = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";

unsigned int LookUp(const char base64Val)  {
   unsigned int counter;
   for (counter=0; counter<table.length(); counter++)  {
      if (table[counter]==base64Val)
	 return(counter);
   }

   // wasn't a valid charcter, ignore
   return(99);
}

int encode64(ifstream &file, string &encodedFile)  {
   // defs
   char readIn;
   char readInAltered;
   int base64Val;
   int n;
   int bits2;
   int bits4;

   // mess around
   n = 0;
   encodedFile = "";
   do  {
      file.get(readIn);
      n++;

      switch (n)  {
         case 1:
	    // we have no extra bits laying around.
	    // read in 8, must store 2.
	    readInAltered = readIn >> 2;
            base64Val = readInAltered & 63;
	    bits2 = (readIn & 3) << 4;
	    break;
         case 2:
	    // we have 2 bits laying around
	    // then we read in 8 bits.
	    // we want the higher 2 bits laying around, 
	    // and the lower 4 bits we just read.
	    // store our extra 4 bits
	    readInAltered = readIn >> 4;
            base64Val = (readInAltered | bits2) & 63;
	    bits4 = (readIn << 2) & 63;
	    break;
         case 3:
	    // we have 4 bits laying around.
	    // then we read in 8 bits.
	    // we want the lower 4 we saved and
	    // 2 of the bits we read in.
	    // save the upper 6 bits we read in
	    readInAltered = readIn >> 6;
            base64Val = (readInAltered | bits4) & 63;
	    encodedFile += table.c_str()[base64Val];
            base64Val = readIn & 63;
            n = 0;
	    break;
      }

      // store what we've got
      encodedFile += table.c_str()[base64Val];
   } while (file); 

   // make sure we have a multiple of 4 chars
   switch (n)  {
      case 1:
         encodedFile += "==";
	 break;
      case 2:
         encodedFile += "=";
	 break;
   }

   // return the encoded string
   //cout << "encoded file: " << encodedFile << endl;
   return(0);
}

void check(unsigned int convertedVal, ifstream &fileIn, int loc, int counter)  {
   unsigned char c;

   fileIn.get(c);
   if ((unsigned int)c!=convertedVal)  {
      cout << "was:  " << c << "\tnow:  " << convertedVal 
           << "\tat:  " << loc << "\tcounter: " << counter << endl;
   }
}

int decode64(string &encodedText, ofstream &fileOut)  {
   // defs
   unsigned int convertedVal;
   unsigned int partialVal;
   int n;
   unsigned int bits2;
   unsigned int bits4;
   unsigned int bits6;
   unsigned int counter;
   unsigned int lookedUp;
   //char c;
   //fileIn.get(c);

   // mess around
   n = 0;
   unsigned int encodedTextLength = encodedText.length();
   for (counter=0; counter<encodedTextLength && encodedText[counter]!='='; 
	           counter++)  {
      lookedUp = LookUp(encodedText[counter]);
      if (lookedUp<70)  {
	 n++;
         switch (n)  {
            case 1:
	       // we have no extra bits laying around.
               // only have 6 bits, so just save them until
               // we have a read with enough bits
	       bits6 = lookedUp << 2;
	       break;
            case 2:
	       // we have 6 bits stored.  
	       // our next char has 6 bits.
	       // write out 8 of these bits,
	       // store 4 of these bits
               partialVal = (lookedUp & 48) >> 4;
               convertedVal = bits6 + partialVal;
               bits4 = lookedUp << 4;
               fileOut.put((unsigned char)convertedVal); 
	       break;
            case 3:
	       // we have 4 bits stored
	       // our next char has 6 bits
	       // write out 8 of these bits,
	       // store 2 of these bits
               partialVal = (lookedUp & 60) >> 2;
               convertedVal = bits4 + partialVal;
               bits2 = lookedUp << 6;
               fileOut.put((unsigned char)convertedVal); 
               break;
	    case 4:
	       // we have 2 bits stored
	       // our nextchar has 6 bits
	       // write out all 8 bits
	       convertedVal = lookedUp + bits2;
               n = 0;
               fileOut.put((unsigned char)convertedVal); 
	       break;
         }
      }  
   }

   // return the encoded string
   return(0);
}
