//
//  callbacks.c  --  gtk functions to make callbacks
//  -- created  5/23/00 updated 5/23/00
//////////////////////////////////////////////

#include "callbacks.h"

extern Althea gAlthea;
extern Althea gAlthea_config;


void
on_printButton_clicked                       (GtkButton       *button,
                                              gpointer         user_data)
{
  string sTmpFile = "/tmp/printMail.althea";
  string sCommand = gtk_editable_get_chars( GTK_EDITABLE( user_data ), 0, -1 );

  Message *M = gAlthea.get_Current_Message();

  if ( M == NULL )   {
    error ( "Select a message to print.\n" );
  }
  else   {

    string sLetter = "From: " + M->get_From_Address() + "\n" +
      "To: " + M->get_To_Address() + "\n" +
      "Date: " + M->get_Date() + "\n" +
      "Subject: " + M->get_Subject() + "\n\n" +
      M->get_Body_Text() + "\n\n\n\n";


    ofstream outFile ( sTmpFile.c_str(), ios::out );

    if ( !outFile )   {
      error ( "File could not be opened.\n" );
    }
    else   {

      // write file
      outFile << sLetter << endl;

      // issue print sCommand
      int index = sCommand.find ( "%s" );
      if ( index == -1 )   {
	sCommand = sCommand + " " + sTmpFile;
      }
      else   {
	sCommand.replace ( index, 2, sTmpFile );  // replace "%s" with sTmpFile
      }
      system ( sCommand.c_str() );
      sCommand = "rm " + sTmpFile;
      system ( sCommand.c_str() );
    }
  }
}


void
update_message_list( Folder *the_folder )
{
  int i;
  int first_unseen = 0;
  GtkCList *message_list = GTK_CLIST (gAlthea.get_message_list());
  string flags;

  if (gAlthea.get_Verbose())
    cout << "adding " << the_folder->get_Num_Messages() << " messages..." << endl;
  gtk_clist_clear( GTK_CLIST (message_list) );
  assert( the_folder != NULL );

  if( the_folder->get_Num_Messages() > 0 ) {
    for( i = the_folder->get_Sequence_Start(); i <= the_folder->get_Sequence_Stop(); i++) {
      Message *M = the_folder->get_Message( i );
      assert( M != NULL );
      char *messages[] =
      {                  
	(char *)M->get_From_Address().c_str(),
	(char *)M->get_Subject().c_str(),
	(char *)M->get_Date().c_str(),
	(char *)M->get_Flags().c_str()
      };
          
      gtk_clist_append( GTK_CLIST (message_list), messages );
      gtk_clist_set_row_data( GTK_CLIST (message_list), i-1, (gpointer) M);

      flags = M->get_Flags();

      if( strstr( flags.c_str(), "\\Deleted" ) != NULL )
	set_row_color( GTK_CLIST (message_list), i-1, DELETED_COLORS );
      else if( flags == "" || strstr( flags.c_str(), "\\Unseen" ) != NULL
	       || strstr( flags.c_str(), "\\Recent" ) != NULL ) {
	set_row_color( GTK_CLIST (message_list), i-1, UNSEEN_COLORS );
	if( first_unseen == 0 )
	  first_unseen = i;
      } else if( strstr( flags.c_str(), "\\Answered" ) != NULL )
	set_row_color( GTK_CLIST (message_list), i-1, ANSWERED_COLORS );
      else
	set_row_color( GTK_CLIST (message_list), i-1, SEEN_COLORS );
    }
      
    // Now position the clist at the first unseen message
    if( first_unseen > 0 )
      first_unseen--;
    gtk_clist_moveto( GTK_CLIST (message_list), first_unseen, 0, 0.0, 0.0 );
  }
  
  
}


void
select_server                          (GtkObject       *object,
                                        gpointer        user_data)
{
  Server *the_server = (Server *) user_data;
  gAlthea.set_Current_Server( the_server );
  if (gAlthea.get_Verbose())
    cout << "You selected server " << the_server->get_Server_Name() << endl;
  
}

void
select_folder                          (GtkObject       *object, 
                                        gpointer        user_data)
{

  int ret_val;



  Folder *the_folder = (Folder *) user_data;
  if (gAlthea.get_Current_Folder()!=the_folder) {
      
    gAlthea.set_Current_Server( the_folder->get_Server_Ptr() );
    gAlthea.set_Current_Folder( the_folder );
    Server * the_server = gAlthea.get_Current_Server();
    if (!the_server->get_Reserved()) {
      the_server->reserve();
	       	
      if (gAlthea.get_Current_Server()->check_Connected() == SUCCESS) {  	    	    

	if (gAlthea.get_Verbose())
	  cout << "You selected folder " << the_folder->get_Folder_Name() << endl;

	ret_val = the_folder->get_Message_Headers();
	      
	if( ret_val == SUCCESS  || ret_val == SUCCESSFUL_SERVER_READ)
	  update_message_list( the_folder );
	else
	  error( "Problem getting message headers: error was " );
	    
	    
	if (the_folder->get_Folder_Name()=="INBOX") {
	  if (gAlthea.get_Verbose())
	    cout << "starting mail polling" << endl;
	  if (gAlthea.get_Current_Server()->timeout)
	    gtk_timeout_remove(gAlthea.get_Current_Server()->timeout);
	  gAlthea.get_Current_Server()->timeout=gtk_timeout_add( MAIL_POLL_INTERVAL,
								 poll_mail,
								 gAlthea.get_Current_Server());
	} //	if (the_folder->get_Folder_Name()=="INBOX")     
      } // if (gAlthea.get_Current_Server()->check_Connected() == SUCCESS)
      the_server->release();
    } // if (!the_server->get_Reserved())
  } // if (gAlthea.get_Current_Folder()!=the_folder
}


void
on_print_message_activate              (GtkObject       *object,
                                        gpointer        user_data)
{
  GtkWidget *print_dialog;
  print_dialog = create_print_dialog();
  gtk_widget_show (print_dialog);
}

void
on_expunge_menu_activate               (GtkObject       *object,
                                        gpointer        user_data)
{

  Server * the_server = gAlthea.get_Current_Server();
  while (the_server->get_Reserved()) {
    if (gAlthea.get_Verbose())
      cout << the_server->get_Server_Name() << " is reserved, sleeping" << endl;
    sleep(1);
  }
  the_server->reserve();

  if (gAlthea.get_Verbose())
    cout << "expunging" << endl;
  Folder *the_folder = gAlthea.get_Current_Folder();
  if (the_folder == NULL) return;
  the_folder->expunge_Deleted_Mail();
  update_message_list( the_folder );
  
  the_server->release();

}


void
on_full_header_menu_activate               (GtkObject       *object,
					    gpointer        user_data)
{
  string flags;
  int ret_val;
  Message * the_message = gAlthea.get_Current_Message();
  assert( the_message != NULL );

  Server * the_server = gAlthea.get_Current_Server();
  while (the_server->get_Reserved()) {
    if (gAlthea.get_Verbose())
      cout << the_server->get_Server_Name() << " is reserved, sleeping" << endl;
    sleep(1);
  }
  the_server->reserve();
    

   
  if (gAlthea.get_Current_Server()->check_Connected() == SUCCESS) { 
    // If we haven't gotten the message body yet, do so.  If we have set ret_val to 0
    // since we know the body retrieval was successful.

    if( the_message->have_Body_Text() == 0 ) {
      if (gAlthea.get_Verbose())
	cout << "Message not cached... reading from server.\n";       
      ret_val = the_message->get_Body_From_Server();
    }
    else
      ret_val = SUCCESS;
      
    if( ret_val == SUCCESS ) {    
      GtkWidget *mess_text = gAlthea.get_message_text();
      assert( mess_text != NULL );
	  

      gtk_text_freeze(GTK_TEXT(mess_text));
      gtk_text_set_point( GTK_TEXT (mess_text), gtk_text_get_length( GTK_TEXT (mess_text) ) );
      gtk_text_backward_delete( GTK_TEXT (mess_text), gtk_text_get_point( GTK_TEXT (mess_text) ));
      gtk_text_insert( GTK_TEXT (mess_text), NULL, &mess_text->style->black, NULL, the_message->get_Full_Header().c_str(), -1 );
      gtk_text_insert( GTK_TEXT (mess_text), NULL, &mess_text->style->black, NULL, the_message->get_Body_Text().c_str(), -1);
      gtk_text_set_point( GTK_TEXT (mess_text), 0 );
      gtk_text_thaw(GTK_TEXT(mess_text));
    }
    else {
      error( "Error retrieving message from server." );
      the_message->set_Have_Body( 0 );
    }
  } //  if (gAlthea.get_Current_Server()->check_Connected() == SUCCESS)
  the_server->release(); 



}


void 
attach_file_ok                         (GtkObject       *object,
                                        gpointer        user_data)
{
  GtkWidget *attach_window = GTK_WIDGET (user_data);
  string *filename = new string( gtk_file_selection_get_filename( GTK_FILE_SELECTION (attach_window) ) );
  if (gAlthea.get_Verbose()) {
    cout << "attach file okay!" << endl;
    cout << "  filename=\"" << *filename << "\"" << endl;
  }
}


// Create the new file selection window
////////////////////////////////////////
void
attach_file                            (GtkObject       *object,
                                        gpointer        user_data)
{
  //GtkWidget *attach_window = GTK_WIDGET (user_data);
  GtkWidget *attach_window = gtk_file_selection_new( "Select File" );

  if (gAlthea.get_Verbose())
    cout << "attach file!" << endl;
  gtk_signal_connect_object( GTK_OBJECT (attach_window), "destroy",
                             GTK_SIGNAL_FUNC (gtk_widget_destroy),
                             GTK_OBJECT (attach_window) );
  gtk_signal_connect_object( GTK_OBJECT (GTK_FILE_SELECTION (attach_window)->cancel_button),
                             "clicked",
                             GTK_SIGNAL_FUNC (gtk_widget_destroy),
                             GTK_OBJECT (attach_window) );
  gtk_signal_connect( GTK_OBJECT (GTK_FILE_SELECTION (attach_window)->ok_button),
                      "clicked",
                      GTK_SIGNAL_FUNC (attach_file_ok), 
                      attach_window );
  gtk_signal_connect_object( GTK_OBJECT (GTK_FILE_SELECTION (attach_window)->ok_button),
                             "clicked",
                             GTK_SIGNAL_FUNC (gtk_widget_destroy),
                             GTK_OBJECT (attach_window) );
  gtk_widget_show( attach_window );
  
  
}

void
create_message                         (GtkObject       *object,
                                        gpointer        user_data)
{

  text_widgets *temp = (text_widgets *) user_data;
  string *to, *subject, *cc, *body;
  Server * current = gAlthea.get_Current_Server();
  assert( current != NULL );
  
  to = extract_entry( temp->to );
  subject = extract_entry( temp->subject );
  cc = extract_entry( temp->cc );
  body = extract_text( temp->body );
  Message *M;
  if (current->get_EMail_Address()==""){
    M = new Message( current->get_Username() + "@" + current->get_SMTP_Server_Name(), (string) *to, (string) *cc,(string) *subject );
  }else{
    M = new Message( current->get_EMail_Address(), (string) *to, (string) *cc,(string) *subject );
  }
  M->set_Body_Text( (string) *body );
  M->set_Server_Ptr( current );
  M->send();
  M->save_FCC();
  delete M;  // We don't need it any more.  This will all probably be replaced with a stand-alone function some day.
}

gboolean
on_main_window_delete_event            (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  return FALSE;
}


void
on_main_window_destroy                 (GtkObject       *object,
                                        gpointer         user_data)
{
  gtk_main_quit();
}


void
on_althea_menu_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_new_message_menu_activate           (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkWidget *new_message_window=NULL;

  Server * current = gAlthea.get_Current_Server();
  if( current != NULL ) {

    string message = "";
    char *fname = (char *) malloc(255);
    strcpy(fname,getenv ("HOME"));
    strcat(fname, "/.sig");

    ifstream sig(fname);
    if (sig) {
      if (gAlthea.get_Verbose())
	cout << "found ~/.sig file" << endl;
      message += "\n\n\n-----\n";
      char c;
      while (sig.get(c)) 
	message += c;
    }
    new_message_window = create_new_message_window("", "", "", message);
    gtk_widget_show( new_message_window );
  }
  else
    error( "Select server to send mail from." );
}


void 
on_select_message                      (GtkWidget *widget,
                                        gint row,
                                        gint column,
                                        GdkEventButton *event,
                                        gpointer data)
{
  string flags;
  int ret_val;
  GtkWidget *attach_list = gAlthea.get_attach_list();
  GtkCList *message_list = GTK_CLIST (gAlthea.get_message_list());
  Message * the_message = (Message *) gtk_clist_get_row_data( message_list, row );
  assert( the_message != NULL );


  gAlthea.set_Current_Message( the_message );
  gAlthea.set_Current_Server( the_message->get_Server_Ptr() );


  gtk_list_clear_items(GTK_LIST(attach_list),0,-1);
 
    
  list<string> a_list = the_message->get_Message_Parts();
    
    
  if (a_list.size()>1)
    gtk_widget_set_usize(attach_list,600,a_list.size()*16);
  else
    gtk_widget_set_usize(attach_list,600,0);
    
  gtk_widget_show(attach_list);
    
  if (a_list.size()>1) {
    // populate attach list
    GtkWidget *label;
    GtkWidget *list_item;    
    list<string>::iterator it;
      
      
    int tpartno=0;
    it = a_list.begin();
    while( it != a_list.end() ) {  
 
      tpartno++;
      int *partno=new int;
      *partno=tpartno;
	
	
      string the_lab_text;
	
	
      if (*partno==1) {
	the_lab_text="Message Body";
      } else {
	if (tolower((*it)).find("\"text\""))
	  the_lab_text = "TEXT - ";
	else 
	  the_lab_text = "APPLICATION - ";
	int x;
	int n;
	for (n=0,x=0; n<3; x++)
	  if ((*it)[x]=='\"')
	    n++;
	  
	while ((*it)[x]!='\"'){
	    
	  the_lab_text+=(*it)[x];
	  x++;
	}
	  
	the_lab_text += " - ";
	unsigned int filenamestart = tolower((*it)).find("\"filename\"");
	if (filenamestart<(*it).length())
	  the_lab_text+=(*it).substr(filenamestart+12,(*it).find("\"",filenamestart+12)-(filenamestart+12));
      }
	
 
 
 
      label=gtk_label_new(the_lab_text.c_str());
      list_item=gtk_list_item_new();
      gtk_container_add(GTK_CONTAINER(list_item), label);
      gtk_widget_show(label);
      gtk_container_add(GTK_CONTAINER(attach_list), list_item);
      gtk_widget_show(list_item);
 	
      if (tolower((*it)).find("base64")<(*it).length())
	*partno*=-1;
      gtk_object_set_data(GTK_OBJECT(list_item),
			  "partno",
			  partno);
 	
      it++;
    } // while( it != a_list.end() )
      
      
  } // if (a_list.size()>1)
  gtk_widget_show(attach_list);
    
 




  Server * the_server = gAlthea.get_Current_Server();
  while (the_server->get_Reserved()) {
    if (gAlthea.get_Verbose())
      cout << the_server->get_Server_Name() << " is reserved, sleeping" << endl;
    sleep(1);
  }
  the_server->reserve();
    

   
  if (gAlthea.get_Current_Server()->check_Connected() == SUCCESS)    { 
    // If we haven't gotten the message body yet, do so.  If we have set ret_val to 0
    // since we know the body retrieval was successful.

    if( the_message->have_Body_Text() == 0 ) {
      if (gAlthea.get_Verbose())
	cout << "Message not cached... reading from server.\n";       
      ret_val = the_message->get_Body_From_Server();      
    }
    else
      ret_val = SUCCESS;
    
    if( ret_val == SUCCESS ) {    
      GtkWidget *mess_text = gAlthea.get_message_text();
      assert( mess_text != NULL );

      flags = the_message->get_Flags();
      if( flags == "" || strstr( flags.c_str(), "\\Unseen" ) != NULL
	  || strstr( flags.c_str(), "\\Recent" ) != NULL ) {
	set_row_color( GTK_CLIST (message_list), row, SEEN_COLORS );
	gtk_clist_set_text( GTK_CLIST (message_list), row, 3, flags.c_str() );
      }
  
      gtk_text_freeze(GTK_TEXT(mess_text));
      gtk_text_set_point( GTK_TEXT (mess_text), gtk_text_get_length( GTK_TEXT (mess_text) ) );
      gtk_text_backward_delete( GTK_TEXT (mess_text), gtk_text_get_point( GTK_TEXT (mess_text) ));
      gtk_text_insert( GTK_TEXT (mess_text), NULL, &mess_text->style->black, NULL, the_message->get_Header().c_str(), -1 );
      gtk_text_insert( GTK_TEXT (mess_text), NULL, &mess_text->style->black, NULL, the_message->get_Body_Text().c_str(), -1);
      gtk_text_set_point( GTK_TEXT (mess_text), 0 );
      gtk_text_thaw(GTK_TEXT(mess_text));
    }
    else {
      error( "Error retrieving message from server." );
      the_message->set_Have_Body( 0 );
    }
  }  
  the_server->release(); 
 
}

// Get the filename from the "Save Message" dialog box
///////////////////////////////////////////////////////
void
save_file_ok                           (GtkObject     *object, 
                                        gpointer      user_data )
{
  ofstream fout;
  GtkWidget *save_window = GTK_WIDGET (user_data);
  string *filename = new string(gtk_file_selection_get_filename( GTK_FILE_SELECTION (save_window) ) );
  string *text = new string(gtk_editable_get_chars( GTK_EDITABLE (gAlthea.get_message_text()), 0, -1 ) );

  if( *text != "" ) {
    fout.open( filename->c_str() );
    if( fout == NULL ) 
      error( "Cannot write to file \"" + *filename + "\"" );
    else
      fout << *text;
    fout.close();
  }
}

// Create the save file selection box
///////////////////////////////////////
void
on_save_message_menu_activate          (GtkObject     *object,
                                        gpointer      user_data)
{
  GtkWidget *save_window = gtk_file_selection_new( "Save Message" );
  Message * M = gAlthea.get_Current_Message();

  if( M != NULL ) {
    if (gAlthea.get_Verbose())
      cout << "Save file!" << endl;
    gtk_signal_connect_object( GTK_OBJECT (save_window), "destroy",
                               GTK_SIGNAL_FUNC (gtk_widget_destroy),
                               GTK_OBJECT (save_window) );
    gtk_signal_connect_object( GTK_OBJECT (GTK_FILE_SELECTION (save_window)->cancel_button),
                               "clicked",
                               GTK_SIGNAL_FUNC (gtk_widget_destroy),
                               GTK_OBJECT (save_window) );
    gtk_signal_connect( GTK_OBJECT (GTK_FILE_SELECTION (save_window)->ok_button),
                        "clicked",
                        GTK_SIGNAL_FUNC (save_file_ok), 
                        save_window );
    gtk_signal_connect_object( GTK_OBJECT (GTK_FILE_SELECTION (save_window)->ok_button),
                               "clicked",
                               GTK_SIGNAL_FUNC (gtk_widget_destroy),
                               GTK_OBJECT (save_window) );
    gtk_widget_show( save_window );
  } else {
    error( "Select a message to save." );
  }
}


void get_mail( void ) {

  GtkCTree *folder_list = GTK_CTREE (gAlthea.get_folder_list());   
  GtkCTreeNode *folder, *server;
  Server *the_server;
  Folder *F;
  int i, j, ret_val;
  for( i = 1; i <= gAlthea.get_Num_Servers(); i++ ) {
    the_server = gAlthea.get_Server( i );
    assert( the_server != NULL );


    while (the_server->get_Reserved()) {
      if (gAlthea.get_Verbose())
	cout << the_server->get_Server_Name() << " is reserved, sleeping" << endl;
      sleep(1);
    }
    the_server->reserve();
      
      
    server = create_new_server( the_server, folder_list );
    if( the_server->login() == SUCCESS ) {
      ret_val = the_server->get_Folder_List_From_Server();
      if( ret_val == SUCCESS ) {
	for( j = 1; j <= the_server->get_Num_Folders(); j++ ) {
	  F = the_server->get_Folder( j );
	  folder = create_folder_in_server( F, server );
	}
      }
      else
	error( "Could not get mailbox listing from server " + the_server->get_Server_Name() + "." );
    }
      
    else
      error( "Could not log in to server " + the_server->get_Server_Name() + "." );
    the_server->release();
  }
}


void get_mail( Server *the_server ) {

  GtkCTree *folder_list = GTK_CTREE (gAlthea.get_folder_list());   
  GtkCTreeNode *folder, *server;
  Folder *F;
  int j, ret_val;
  assert( the_server != NULL );
  
  while (the_server->get_Reserved()) {
    if (gAlthea.get_Verbose())
      cout << the_server->get_Server_Name() << " is reserved, sleeping" << endl;
    sleep(1);
  }
  the_server->reserve();


  server = create_new_server( the_server, folder_list );
  if( the_server->login() == SUCCESS ) {
    ret_val = the_server->get_Folder_List_From_Server();
    if( ret_val == SUCCESS ) {
      for( j = 1; j <= the_server->get_Num_Folders(); j++ ) {
	F = the_server->get_Folder( j );
	folder = create_folder_in_server( F, server );
      }
    }
    else
      error( "Could not get mailbox listing from server " + the_server->get_Server_Name() + "." );
  }
  
  else
    error( "Could not log in to server " + the_server->get_Server_Name() + "." );
  the_server->release();
}


void
on_check_mail_menu_activate            (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

  if (gAlthea.is_Current_Server()) {

    Server * the_server = gAlthea.get_Current_Server();
    Folder * the_folder = the_server->get_Folder( 1 );

    while (the_server->get_Reserved()) {
      if (gAlthea.get_Verbose())
	cout << the_server->get_Server_Name() << " is reserved, sleeping" << endl;
      sleep(1);
    }
    the_server->reserve();
    

    if (gAlthea.get_Current_Server()->check_Connected() == SUCCESS) {    
      if( the_server == NULL )
	error("Select a server first.");
      else {
	the_server->get_New_Mail();
	//the_folder->clear();
	//int ret_val = the_folder->get_Message_Headers();
	update_message_list( the_folder);
      }
    }
    the_server->release();
  } else {
    error("Select a server first.");
  }
}



void
on_print_menu_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkWidget *print_dialog;
  print_dialog = create_print_dialog();
  gtk_widget_show (print_dialog);
}


void
on_options_menu_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  gAlthea.Althea_to_config();
  // show the window
  GtkWidget *config_window = create_configwindow();
  gtk_widget_show( config_window );
  
  // get the lists
  GtkList *server_config_list = GTK_LIST (gAlthea_config.get_Server_Config_List());
  GtkList *filter_config_list = GTK_LIST (gAlthea_config.get_Filter_Config_List());

  gtk_list_set_selection_mode( server_config_list, GTK_SELECTION_SINGLE );
  gtk_list_set_selection_mode( filter_config_list, GTK_SELECTION_SINGLE );


  // populate server list
  GtkWidget *label;
  GtkWidget *list_item;



  list<Server>::iterator it;
  list<Server> server_list = gAlthea_config.get_Server_List();
  it = server_list.begin();
  while( it != server_list.end() ) {  
    label=gtk_label_new((*it).get_Server_Name().c_str());
    list_item=gtk_list_item_new();
    gtk_container_add(GTK_CONTAINER(list_item), label);
    gtk_widget_show(label);
    gtk_container_add(GTK_CONTAINER(server_config_list), list_item);
    gtk_widget_show(list_item);
    Server *the_server;
    the_server=(&*it);
    gtk_object_set_data(GTK_OBJECT(list_item),
			"server",
			(&*it));

    it++;
  }



  list<Filter>::iterator fit;
  list<Filter> filter_list = gAlthea_config.filter_list;
  fit = filter_list.begin();
  
  while( fit != filter_list.end() ) {  
    label=gtk_label_new((*fit).filter_string.c_str());
    list_item=gtk_list_item_new();
    gtk_container_add(GTK_CONTAINER(list_item), label);
    gtk_widget_show(label);
    gtk_container_add(GTK_CONTAINER(filter_config_list), list_item);
    gtk_widget_show(list_item);
    Filter *the_filter2;
    the_filter2=(&*fit);
    gtk_object_set_data(GTK_OBJECT(list_item),
			"filter",
			the_filter2);
    fit++;
  }


}


void
on_exit_menu_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  gtk_main_quit();
}


void
on_edit_menu_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_copy_menu_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_cut_menu_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_paste_menu_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_clear_menu_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_select_all_menu_activate            (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_search_menu_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_search_in_message_menu_activate     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_search_in_folders_menu_activate     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_search_again_menu_activate          (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_advanced_search_menu_activate       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_message_menu_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_reply_menu_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkCList *message_list = GTK_CLIST (gAlthea.get_message_list());
  GtkWidget *new_message_window=NULL;
  Message * M = gAlthea.get_Current_Message();
    
  if( M != NULL ) {
    string from=M->get_From_Address();


    if (strstr(from.c_str(),"\r")!=NULL)
      from = from.substr(0,from.find_first_of('\r'));
    // THE ABOVE IS JUST A WORK ARROUND! FIX THE BUG!

    string newflags;
    string oldMessage,newMessage;


    oldMessage = (string)"\n\n\n" + (string) gtk_editable_get_chars( GTK_EDITABLE (gAlthea.get_message_text()), 0, -1 );
    for (unsigned int x=0; x<oldMessage.length(); x++) {
      if (oldMessage[x]!='\n'){
	newMessage += oldMessage[x];
      } else {
	newMessage += oldMessage[x];
	newMessage += "> ";
      }
    }

    char *fname = (char *) malloc(255);
    strcpy(fname,getenv ("HOME"));
    strcat(fname, "/.sig");

    ifstream sig(fname);
    free(fname);
    if (sig) {
      if (gAlthea.get_Verbose())
	cout << "found ~/.sig file" << endl;
      newMessage += "\n\n\n-----\n";
      char c;
      while (sig.get(c)) 
	newMessage += c;
    }



    new_message_window = create_new_message_window(from, "Re: " + M->get_Subject(), "", newMessage);
    gtk_widget_show( new_message_window );
    Server *the_server=gAlthea.get_Current_Server();
    while (the_server->get_Reserved()) {
      if (gAlthea.get_Verbose())
	cout << the_server->get_Server_Name() << " is reserved, sleeping" << endl;
      sleep(1);
    }
    the_server->reserve();
	
    IMAPSetFlagByUID(gAlthea.get_Current_Server()->get_Connection(),M->get_UID(), "\\Answered", newflags);
    the_server->release();
    if (gAlthea.get_Verbose())
      cout << "The message's flags are now: " << newflags << endl;

    int row = gtk_clist_find_row_from_data( message_list, (gpointer) M );
    gtk_clist_set_text( GTK_CLIST (message_list), row, 3, newflags.c_str() );
    set_row_color( GTK_CLIST (message_list), row, ANSWERED_COLORS );

  }
  else
    error( "Select a message to reply to." );    
}



void
on_reply_all_menu_activate                 (GtkMenuItem     *menuitem,
					    gpointer         user_data)
{
  GtkCList *message_list = GTK_CLIST (gAlthea.get_message_list());
  GtkWidget *new_message_window=NULL;
  Message * M = gAlthea.get_Current_Message();
  
  if( M != NULL ) {
    string from=M->get_From_Address();
    string to=M->get_To_Address();
    string cc=M->get_CC_Address();


    if (strstr(from.c_str(),"\r")!=NULL)
      from = from.substr(0,from.find_first_of('\r'));
    if (strstr(to.c_str(),"\r")!=NULL)
      to = to.substr(0,to.find_first_of('\r'));
    if (strstr(cc.c_str(),"\r")!=NULL)
      cc = cc.substr(0,cc.find_first_of('\r'));

    // THE ABOVE IS JUST A WORK ARROUND! FIX THE BUG!

    string newflags;
    string oldMessage,newMessage;


    oldMessage = (string)"\n\n\n" + (string) gtk_editable_get_chars( GTK_EDITABLE (gAlthea.get_message_text()), 0, -1 );
    for (unsigned int x=0; x<oldMessage.length(); x++) {
      if (oldMessage[x]!='\n'){
	newMessage += oldMessage[x];
      } else {
	newMessage += oldMessage[x];
	newMessage += "> ";
      }
    }

    string sendcc;

    if (cc!=""){
      sendcc = to;
      sendcc+= ", " ;
      sendcc+= cc;
    } else
      sendcc = to;
 

    new_message_window = create_new_message_window(from, "Re: " + M->get_Subject(), sendcc, newMessage);
    gtk_widget_show( new_message_window );
    Server *the_server=gAlthea.get_Current_Server();
    while (the_server->get_Reserved()) {
      if (gAlthea.get_Verbose())
	cout << the_server->get_Server_Name() << " is reserved, sleeping" << endl;
      sleep(1);
    }
    the_server->reserve();
	
    IMAPSetFlagByUID(gAlthea.get_Current_Server()->get_Connection(),M->get_UID(), "\\Answered", newflags);
    the_server->release();
    if (gAlthea.get_Verbose())
      cout << "The message's flags are now: " << newflags << endl;

    int row = gtk_clist_find_row_from_data( message_list, (gpointer) M );
    gtk_clist_set_text( GTK_CLIST (message_list), row, 3, newflags.c_str() );
    set_row_color( GTK_CLIST (message_list), row, ANSWERED_COLORS );

  }
  else
    error( "Select a message to reply to." );
    
}


void
on_forward_menu_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkWidget *new_message_window=NULL;
  Message * M = gAlthea.get_Current_Message();
  if( M != NULL ) {

    string newMessage="";
    char *fname = (char *) malloc(255);
    strcpy(fname,getenv ("HOME"));
    strcat(fname, "/.sig");

    ifstream sig(fname);
    free(fname);
    if (sig) {
      if (gAlthea.get_Verbose())
	cout << "found ~/.sig file" << endl;
      newMessage += "\n\n\n-----\n";
      char c;
      while (sig.get(c)) 
	newMessage += c;
    }


    new_message_window =
      create_new_message_window("", "Fwd: " + M->get_Subject(), "", (string)"\n\n\n" + (string) gtk_editable_get_chars( GTK_EDITABLE (gAlthea.get_message_text()), 0, -1 )+newMessage);
    gtk_widget_show( new_message_window );
  }
  else
    error( "Select a message to forward." );
}


void
on_delete_menu_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  if (gAlthea.is_Current_Message()) {
    

    Message * M = gAlthea.get_Current_Message();
    GtkCList *message_list = GTK_CLIST (gAlthea.get_message_list());
    int row;
    Server *the_server = gAlthea.get_Current_Server();
    
    //Add the undelete option if you press it twice.
    if (strstr(M->get_Flags().c_str(),"\\Deleted")) {
      on_undelete_menu_activate (menuitem, user_data);
    }
    else {
      if (gAlthea.get_Current_Server()->check_Connected() == SUCCESS) {
	if( M != NULL ) {
	  while (the_server->get_Reserved()) {
	    if (gAlthea.get_Verbose())
	      cout << the_server->get_Server_Name() << " is reserved, sleeping" << endl;
	    sleep(1);
	  }
	  the_server->reserve();

	  M->Delete();
	  the_server->release();	  
	  row = gtk_clist_find_row_from_data( message_list, (gpointer) M );
	  if( row != -1 ) {
	    gtk_clist_set_text( GTK_CLIST (message_list), row, 3, M->get_Flags().c_str() );
	    set_row_color( GTK_CLIST (message_list), row, DELETED_COLORS );
	    Folder *the_folder=gAlthea.get_Current_Folder();
	    if (row!=the_folder->get_Sequence_Stop()-1)
	      gtk_clist_select_row( GTK_CLIST (message_list), row+1, 0 ); 
	  }
	} else
	  error( "Select a message to delete." );
      } 
    }
  } else 
    error( "Select a message to delete." );
}


void
on_undelete_menu_activate              (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  int row;
  string flags;
  GtkCList *message_list = GTK_CLIST (gAlthea.get_message_list());

  if (gAlthea.is_Current_Message()) {


    Server *the_server = gAlthea.get_Current_Server();
    while (the_server->get_Reserved()) {
      if (gAlthea.get_Verbose())
	cout << the_server->get_Server_Name() << " is reserved, sleeping" << endl;
      sleep(1);
    }
    the_server->reserve();


    Message * M = gAlthea.get_Current_Message();
    if (gAlthea.get_Current_Server()->check_Connected() == SUCCESS)
      {
	if( M != NULL ) {
	  M->Undelete();
	  row = gtk_clist_find_row_from_data( message_list, (gpointer) M );
	  if( row != -1 ) {
	    flags = M->get_Flags();
	    gtk_clist_set_text( GTK_CLIST (message_list), row, 3, flags.c_str() );
	    set_row_color( GTK_CLIST (message_list), row, SEEN_COLORS );
	  }
	} else
	  error( "Select a message to undelete." );	    
      } else
	error( "Select a message to undelete." );
    the_server->release();
  }
}


void
on_move_to_folder_menu_activate        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_address_book_menu_activate          (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    error( "This feature not yet implemented." );
}


void
on_view_menu_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_add_an_address_menu_activate        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_import_menu_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_export_menu_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_help_menu_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_index_menu_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_contents_menu_activate              (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkWidget *helpDialog;
  helpDialog = create_helpDialog ();
  gtk_widget_show (helpDialog);

}


void
on_about_menu_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkWidget *about_window = create_about_window();
  gtk_widget_show( about_window );
}

void
on_add_server_clicked                   (GtkButton       *button,
                                       gpointer         user_data)
{
  gAlthea_config.set_Config_Current_Server(NULL);
  GtkWidget *serverconfig_window = create_serverconfig();
  gtk_widget_show( serverconfig_window );
}

void
on_edit_server_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget       *selected_item;
  GList           *dlist;

  GtkList *server_config_list = GTK_LIST (gAlthea_config.get_Server_Config_List());


  dlist=GTK_LIST(server_config_list)->selection;
  if (dlist) {
    selected_item=GTK_WIDGET(dlist->data);


    Server *the_server = (Server *)gtk_object_get_data(GTK_OBJECT(selected_item),
						       "server");
    gAlthea_config.set_Config_Current_Server(the_server);

    GtkWidget *serverconfig_window = create_serverconfig();

    gtk_widget_show( serverconfig_window );


  } else 
    error("Select a Server to Edit");


}


void
on_delete_server_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget       *selected_item;
  GList           *dlist;

  GtkList *server_config_list = GTK_LIST (gAlthea_config.get_Server_Config_List());

  dlist=GTK_LIST(server_config_list)->selection;
  if (dlist) {
    selected_item=GTK_WIDGET(dlist->data);
    Server *the_server = (Server *)gtk_object_get_data(GTK_OBJECT(selected_item),
						       "server");
    string servername = the_server->get_Server_Name();
    gAlthea_config.delete_Server(servername);
    if (gAlthea_config.get_Verbose())
      cout << "Deleted " << servername << endl;
    //We need to redisplay the server list!!  
  
    // get the list
    GtkList *server_config_list = GTK_LIST (gAlthea_config.get_Server_Config_List());
    gtk_list_set_selection_mode( server_config_list, GTK_SELECTION_SINGLE );
  
    // clear the list 
    gtk_list_clear_items ( GTK_LIST (server_config_list), 0, -1 );
  
    // populate server list
    GtkWidget *label;
    GtkWidget *list_item;

    list<Server>::iterator it;
    list<Server> server_list = gAlthea_config.get_Server_List();
    it = server_list.begin();
  
    while( it != server_list.end() ) {  
      label=gtk_label_new((*it).get_Server_Name().c_str());
      list_item=gtk_list_item_new();
      gtk_container_add(GTK_CONTAINER(list_item), label);
      gtk_widget_show(label);
      gtk_container_add(GTK_CONTAINER(server_config_list), list_item);
      gtk_widget_show(list_item);
      Server *the_server2;
      the_server2=(&*it);
      gtk_object_set_data(GTK_OBJECT(list_item),
			  "server",
			  the_server2);
      it++;
    }
  } else 
    error("Select a Server to Delete");
}


void
on_add_filter_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{

  gAlthea_config.set_Config_Current_Filter(NULL);
  GtkWidget *filterconfig_window = create_filterconfig();
  gtk_widget_show( filterconfig_window );
}


void
on_edit_filter_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget       *selected_item;
  GList           *dlist;

  GtkList *filter_config_list = GTK_LIST (gAlthea_config.get_Filter_Config_List());


  dlist=GTK_LIST(filter_config_list)->selection;
  if (dlist) {
    selected_item=GTK_WIDGET(dlist->data);


    Filter *the_filter = (Filter *)gtk_object_get_data(GTK_OBJECT(selected_item),
						       "filter");
    gAlthea_config.set_Config_Current_Filter(the_filter);

    GtkWidget *filterconfig_window = create_filterconfig();

    gtk_widget_show( filterconfig_window );


  } else 
    error("Select a Server to Edit");
}

void
on_delete_filter_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{

}

void
on_serverok_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{	
  string tempname;
  Server *original_server;
  // Get the data from the gpointer
  server_text_widgets *temp = (server_text_widgets *) user_data;
  Server *the_server = gAlthea_config.get_Config_Current_Server(); 
  //Check if the_server was set to NULL, meaning, we are adding a server
  if (!(the_server)) {
    //  Here we are creating a new server to add into the list
    the_server = new Server();
  	
    // Extract the data into the_server
    the_server->set_Server_Name(*extract_entry(temp->name));
    the_server->set_IMAP_Server_Name(*extract_entry(temp->imapserver));
    the_server->set_Port_Number(atoi((*extract_entry(temp->imapport)).c_str()));
    the_server->set_Username(*extract_entry(temp->username));
    the_server->set_Password(*extract_entry(temp->password));
    the_server->set_Folder_Root(*extract_entry(temp->folderroot));
    the_server->set_SMTP_Server_Name(*extract_entry(temp->smtpserver));
    the_server->set_FCC_Folder(*extract_entry(temp->sentmailfolder));
    the_server->set_EMail_Address(*extract_entry(temp->email));
    the_server->set_Save_Password(gtk_toggle_button_get_active(&temp->savepassword->toggle_button));
    the_server->set_Use_SSL(gtk_toggle_button_get_active(&temp->usessl->toggle_button));


  	
    // Add the server into gAlthea_config
    gAlthea_config.add_Server(*the_server);

  } //End getting the new server in
  else {
    //  Else we are getting the edited server in.
    //  NOTE:  I'm getting the server object in by name.  This means you might
    //	get the wrong server if you have two servers with the same name.
    //	This ended up this way in this version because of pointer bugs.
    //	I gave up, for now!
  	
    tempname = the_server->get_Server_Name();
  	
    original_server = gAlthea_config.get_Server(tempname);
  	
    original_server->set_Server_Name(*extract_entry(temp->name));
    original_server->set_IMAP_Server_Name(*extract_entry(temp->imapserver));
    original_server->set_Port_Number(atoi((*extract_entry(temp->imapport)).c_str()));
    original_server->set_Username(*extract_entry(temp->username));
    original_server->set_Password(*extract_entry(temp->password));
    original_server->set_Folder_Root(*extract_entry(temp->folderroot));
    original_server->set_SMTP_Server_Name(*extract_entry(temp->smtpserver));
    original_server->set_FCC_Folder(*extract_entry(temp->sentmailfolder));
    original_server->set_EMail_Address(*extract_entry(temp->email));
    original_server->set_Save_Password(gtk_toggle_button_get_active(&temp->savepassword->toggle_button));
    original_server->set_Use_SSL(gtk_toggle_button_get_active(&temp->usessl->toggle_button));
  }
  
  //We need to redisplay the server list!!  
  
  // get the list
  GtkList *server_config_list = GTK_LIST (gAlthea_config.get_Server_Config_List());
  gtk_list_set_selection_mode( server_config_list, GTK_SELECTION_SINGLE );
  
  // clear the list 
  // NOTE:  I have used 0-256 to clear the list, but this is bad.
  //	There must be a way to clear the list without indices.  Or
  //	to find out the number of items in the list????
  gtk_list_clear_items ( GTK_LIST (server_config_list), 0, -1 );
  
  // populate server list
  GtkWidget *label;
  GtkWidget *list_item;

  list<Server>::iterator it;
  list<Server> server_list = gAlthea_config.get_Server_List();
  it = server_list.begin();
  
  while( it != server_list.end() ) {  
    label=gtk_label_new((*it).get_Server_Name().c_str());
    list_item=gtk_list_item_new();
    gtk_container_add(GTK_CONTAINER(list_item), label);
    gtk_widget_show(label);
    gtk_container_add(GTK_CONTAINER(server_config_list), list_item);
    gtk_widget_show(list_item);
    Server *the_server2;
    the_server2=(&*it);
    gtk_object_set_data(GTK_OBJECT(list_item),
			"server",
			the_server2);
    it++;
  }
}


void
on_servercancel_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{

}

void
on_filterok_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{
  // Get the data from the gpointer
  filter_text_widgets *temp = (filter_text_widgets *) user_data;
  Filter *the_filter = gAlthea_config.get_Config_Current_Filter(); 
  //Check if the_ilter was set to NULL, meaning, we are adding a filter
  if (!(the_filter)) {
    //  Here we are creating a new server to add into the list
    the_filter = new Filter("","","");
  
    // Extract the data into the_server
    the_filter->field=(*extract_entry(temp->filter_field));
    the_filter->filter_string=(*extract_entry(temp->filter_string));
    the_filter->folder=(*extract_entry(temp->folder));


    // Add the filter into gAlthea_config
    gAlthea_config.add_Filter(*the_filter);

  } //End getting the new filter in
  else {
    //  Else we are getting the edited filter in.

    the_filter->field=(*extract_entry(temp->filter_field));
    the_filter->filter_string=(*extract_entry(temp->filter_string));
    the_filter->folder=(*extract_entry(temp->folder));
    
  }
  
  //We need to redisplay the filter list!!  
  
  // get the list
  GtkList *filter_config_list = GTK_LIST (gAlthea_config.get_Filter_Config_List());
  gtk_list_set_selection_mode( filter_config_list, GTK_SELECTION_SINGLE );
  
  // clear the list 
  gtk_list_clear_items ( GTK_LIST (filter_config_list), 0, -1 );
  
  // populate server list
  GtkWidget *label;
  GtkWidget *list_item;

  list<Filter>::iterator it;
  list<Filter> filter_list = gAlthea_config.filter_list;
  it = filter_list.begin();
  
  while( it != filter_list.end() ) {  
    label=gtk_label_new((*it).filter_string.c_str());
    list_item=gtk_list_item_new();
    gtk_container_add(GTK_CONTAINER(list_item), label);
    gtk_widget_show(label);
    gtk_container_add(GTK_CONTAINER(filter_config_list), list_item);
    gtk_widget_show(list_item);
    Filter *the_filter2;
    the_filter2=(&*it);
    gtk_object_set_data(GTK_OBJECT(list_item),
			"filter",
			the_filter2);
    it++;
  }
}


void
on_filtercancel_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{

}

void
on_okconfig_clicked						(GtkButton		*button,
								 gpointer		user_data)
{
  
	save_Althea(gAlthea_config);
	error("Your new configuration has been saved. \nYou will need to restart Althea for your changes to take effect.");
}

void
on_registerbutton_clicked                     (GtkButton       *button,
                                        gpointer         user_data)
{
  string url="http://althea.sourceforge.net/reg.php3?altheaversion=";
  url+=VERSION; 
  registeralthea("althea.sourceforge.net", url);
  gtk_widget_destroy(gAlthea.register_window);
}


void
on_noregisterbutton_clicked                     (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_widget_destroy(gAlthea.register_window);
}

void
on_passwordokbutton_clicked            (GtkButton       *button,
                                        gpointer         user_data)
{


  prompt_info *temp = (prompt_info *) user_data;


  string password= *extract_entry(GTK_ENTRY(temp->text));
  load_Server(temp->other_info->name, temp->other_info->smtp, temp->other_info->imap, temp->other_info->port, temp->other_info->username, password, temp->other_info->folder_root, temp->other_info->fccfolder, temp->other_info->emailaddress,temp->other_info->savepassword, temp->other_info->usessl);
  

  gtk_widget_destroy(temp->the_window);



}

void on_entry1_key_press_event (GtkWidget *widget,
		      GdkEventKey *event,
		      gpointer     data)
{
  if (event->keyval==GDK_Return) {
    on_passwordokbutton_clicked(NULL,data);
  }
}


int poll_mail (gpointer data) {




  Server * the_server= (Server *) data;
  if (gAlthea.get_Verbose())
    cout << "checking mail on server:  " << the_server->get_Server_Name() << endl;
    
  Folder * the_folder = the_server->get_Folder( 1 );
  int oldnumofmessages = the_folder->get_Num_Messages();


  if (!the_server->get_Reserved()) {
    the_server->reserve();

    the_server->get_New_Mail();

    if (the_folder->get_Num_Messages()!=oldnumofmessages) { // yes I realize that this would miss                                                                                                         // if you got a new message and you had deleted
      // a message from another client or report you had more mail
      // when you had less, but, well if you want to read
      // your mail from two clients, that's what you get...

      cout << "\a"; // beep!
      if (gAlthea.get_Current_Folder()==the_folder)
	update_message_list( the_folder);
      else{
	string message= "You have new mail in ";
	message+=the_server->get_Server_Name();
	message+="/INBOX";
	error(message);
      }
    }
    the_server->release();

  }
  return 1;
}



// taken and modified from balsa 1.1.7 (www.balsa.net)

gboolean
on_folder_list_drag_motion (GtkWidget* folder_list, GdkDragContext* context, 
			       gint x, gint y, guint time, gpointer user_data)
{
    return FALSE;
}


void
on_folder_list_drag (GtkWidget* widget, GdkDragContext* context, 
		     gint x, gint y, GtkSelectionData* selection_data, 
		     guint info, guint32 time, gpointer data)
{
  GtkCTreeNode *node;
  gint row, column;    

    
  if (gAlthea.get_Current_Message()) {
      
    /* find the node and mailbox */
    if (gtk_clist_get_selection_info (GTK_CLIST (gAlthea.get_folder_list()), x, y, 
				      &row, &column)) {
      node = gtk_ctree_node_nth (GTK_CTREE(gAlthea.get_folder_list()), row);
      Folder * to_folder =(Folder *) gtk_ctree_node_get_row_data (GTK_CTREE(gAlthea.get_folder_list()), node);
	
      IMAPCopyMessage(gAlthea.get_Current_Server()->get_Connection(),
		      gAlthea.get_Current_Message()->get_UID(),
		      to_folder->get_Folder_Name(), 
		      gAlthea.get_Current_Server()->get_Folder_Root());
	
      on_delete_menu_activate (NULL, NULL);
	
	
	
    }
  }

}





void 
on_althea_index_drag (GtkWidget* widget, GdkDragContext* drag_context, 
		      GtkSelectionData* data, guint info, guint time, 
		      gpointer user_data)
{ 


  if (gAlthea.get_Current_Message()) {
    
    g_return_if_fail (widget != NULL);
    gtk_selection_data_set (data, data->target, 8, 
			    (const guchar *)itoa(gAlthea.get_Current_Message()->get_Message_ID()).c_str(), 
			    sizeof ((const guchar *)itoa(gAlthea.get_Current_Message()->get_Message_ID()).c_str()));
    
  }

}


 
 
 
void on_attach_list_select_child (GtkList *list,
 				  GtkWidget *widget,
				  gpointer user_data) {
 
 
  int *partno = (int *)gtk_object_get_data(GTK_OBJECT(widget),
					   "partno");
 
  string parttext;
 
  IMAPGetMessagePartByUID(gAlthea.get_Current_Server()->get_Connection(),
			  gAlthea.get_Current_Message()->get_UID(), 
			  parttext, (int)abs(*partno));
 
  struct save_file_info *info = new save_file_info;
 
  GtkWidget *filesel= gtk_file_selection_new("Save Attachment");
  info->data=parttext;
  info->isbase64 = (*partno<0);
  info->filesel = filesel;
   
 
  gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION(filesel)->ok_button),
		      "clicked", GTK_SIGNAL_FUNC (save_attach), info);
   
  /* Ensure that the dialog box is destroyed when the user clicks a button. */
   
  gtk_signal_connect_object (GTK_OBJECT (GTK_FILE_SELECTION(filesel)->ok_button),
			     "clicked", GTK_SIGNAL_FUNC (gtk_widget_destroy),
			     GTK_OBJECT(filesel));
   
  gtk_signal_connect_object (GTK_OBJECT (GTK_FILE_SELECTION(filesel)->cancel_button),
			     "clicked", GTK_SIGNAL_FUNC (gtk_widget_destroy),
			     GTK_OBJECT(filesel));
 
 
 
 
  gtk_widget_show(filesel);
 
}
 
void save_attach(GtkFileSelection *selector, gpointer user_data) {
 
 
   
  struct save_file_info *info = (save_file_info *)user_data;
 
 
 
  gchar *selected_filename = gtk_file_selection_get_filename (GTK_FILE_SELECTION(info->filesel));
   
   
 
  ofstream outfile(selected_filename);
 
  if (outfile) {
    if (info->isbase64) {
      decode64(info->data, outfile);
    } else {
      outfile << info->data;
    }
  } else 
    error("could not open file for writing");
 
}
 


void on_folder_list_select_row (GtkCTree *ctree, GtkCTreeNode *node, gint column,
				gpointer user_data)
{

  gchar *text[1];
  guint8 *spacing;
  gboolean *is_leaf;
  gboolean *expanded;


  spacing = new guint8;
  is_leaf = new gboolean;
  expanded = new gboolean;


  gtk_ctree_get_node_info(GTK_CTREE(ctree),
			  GTK_CTREE_NODE(node),
			  text,
			  spacing,
			  NULL,
			  NULL,
			  NULL,
			  NULL,
			  is_leaf,
			  expanded);
  if (*is_leaf){
    select_folder(NULL,gtk_ctree_node_get_row_data(ctree,node));
  }  else {
    select_server(NULL,gtk_ctree_node_get_row_data(ctree,node));
  }
}
