//
//  crypto.cpp  --  crypto functions to scramble the password for the config file
//  -- created 5/3/01
///////////////////////////////////////////////

#include "crypto.h"



char AltheaCryptFind(unsigned char tape[],unsigned char c) {

  unsigned char index=0;

  while (tape[index]!=c) {
    index++;
  }
  return index;
}




string AltheaCrypt(string text) {

  unsigned char tape[255];
  int charcount=0;
  for (unsigned char x=0; x<255; x++) {
    if (isprint(x)) {
      tape[charcount]=x;
      charcount++;
    }
  }
  tape[charcount]=0;
  string crypt;
  unsigned char lastchar=31;
  for (int x=0; (unsigned int)x<text.length(); x++) {
    unsigned char index;
    unsigned char c=text[x];
    index=AltheaCryptFind(tape,c);
    unsigned char crch=(index+lastchar)%charcount;
    lastchar=crch;
    crypt=crypt+(char)tape[crch];
  }
  return crypt;
}



string AltheaDecrypt(string text) {
  unsigned char tape[255];
  int charcount=0;
  for (unsigned char x=0; x<255; x++) {
    if (isprint(x)) {
      tape[charcount]=x;
      charcount++;
    }
  }
  tape[charcount]=0;
  string decrypt;
  unsigned char lastchar=31;
  for (int x=0; (unsigned int)x<text.length(); x++) {
    unsigned char index;
    unsigned char c=text[x];
    index=AltheaCryptFind(tape,c);
    short crch=(index-lastchar)%charcount;
    if (crch<0) crch=charcount+crch;
    decrypt=decrypt+(char)tape[crch];
    lastchar=index;
  }
  return decrypt;
}
