//
//  smtp.cpp  --  functions to send mail using smtp
//  -- created 5/23/00 updated 5/23/00
//////////////////////////////////////////////////

// TO DO:

// Cannot comma-separate multiple addresses on RCPT To: line. Best to
// make an array of recipients and iterate through it, one recipient
// per RCPT To line.
//
// Also a problem of sending message data before getting 354
// line. This is allowed only by `pipelining' SMTP servers (RFC 2920).
//
// Thanks to Ben Beuchler for SMTP standards compliance help.
// Note:  In the SMTP standard, capitalization of commands is not specified
//	but unfortunately, many SMTP servers implemented case-sensitivity 
//	anyways.  To be safe, we are capital letters.  

# include "smtp.h"

extern Althea gAlthea;

int
SMTPSend(const string &host, int port, const string &to, 
	 const string &cc, const string &bcc, const string &from, 
	 const string &message, string &errcode)
{

  AConPtr connection = new ACon;
  string buffer, helo_message;
  int done, local_done, i, j;
  string rcpt;

  /* connect to port 25 on host */
  connection = MakeConnection( host.c_str(), port, false ); //false=nossl

  errcode = readTilEOL(connection);
  if (strncmp(errcode.c_str(), "220", 3) != 0) {
    return SMTP_HOST_NOT_READY;
  }

  /* send helo line, probably should actually say domain at some point */	
  helo_message = "HELO myhost.com\r\n";
  WriteToSocket(connection, helo_message.c_str() , strlen(helo_message.c_str()));

  if (gAlthea.get_Verbose() == 2)
    cout << "C: " << helo_message << endl;

  errcode = readTilEOL(connection);
  if (strncmp(errcode.c_str(), "250", 3) != 0)
    return SMTP_HOST_NO_HELO;


  /* send envelope MAIL From line */
  WriteToSocket(connection, "MAIL From: <", 12);
  WriteToSocket(connection, from.c_str(), strlen(from.c_str()));
  WriteToSocket(connection, ">\r\n", 3);

  if (gAlthea.get_Verbose() == 2)
    cout << "C: MAIL From: <" << from << ">" << endl;

  errcode = readTilEOL(connection);
  if (strncmp(errcode.c_str(), "250", 3) != 0)
    return SMTP_FROM_ERR;

  // Get and send the To: line RCPTs
  done = i = 0;
  while (!done) {
	local_done = 0;
	rcpt = *new string();
	for (j = 0; (!local_done); j++) {
		if (to[i] == '\0') {
			local_done = 1;
			done = 1;
			rcpt += '\0';
			}
		else if (to[i] == ',') {
			local_done = 1;
			rcpt += '\0';
			i++;
			}
		else {
			rcpt += to[i];
			i++;
			}
		}
		
	if ((valid_address(rcpt)) && (i != 0)) {
		WriteToSocket(connection, "RCPT To: ", 9);
    		WriteToSocket(connection, rcpt.c_str(), strlen(rcpt.c_str()));
    		WriteToSocket(connection, "\r\n", 2);

    		if (gAlthea.get_Verbose() == 2)
      			cout << "C: RCPT To: " << rcpt << endl;

    		errcode = readTilEOL(connection);
    		if (strncmp(errcode.c_str(), "250", 3) != 0)
      			return SMTP_TO_ERR;
		}

	}

  // Get and send the CC: line RCPTs
  done = i = 0;
  while (!done) {
	local_done = 0;
	rcpt = *new string();
	for (j = 0; (!local_done); j++) {
		if (cc[i] == '\0') {
			local_done = 1;
			done = 1;
			rcpt += '\0';
			}
		else if (cc[i] == ',') {
			local_done = 1;
			rcpt += '\0';
			i++;
			}
		else {
			rcpt += cc[i];
			i++;
			}
		}
		
	if ((valid_address(rcpt)) && (i != 0)) {
		WriteToSocket(connection, "RCPT To: ", 9);
    		WriteToSocket(connection, rcpt.c_str(), strlen(rcpt.c_str()));
    		WriteToSocket(connection, "\r\n", 2);

    		if (gAlthea.get_Verbose() == 2)
      			cout << "C: RCPT To: " << rcpt << endl;

    		errcode = readTilEOL(connection);
    		if (strncmp(errcode.c_str(), "250", 3) != 0)
      			return SMTP_TO_ERR;
		}

	}

  /* send DATA line */
  WriteToSocket(connection, "DATA\r\n", 6);
  if (gAlthea.get_Verbose() == 2)
    cout << "C: DATA" << endl;

  errcode = readTilEOL(connection);
  if (strncmp(errcode.c_str(), "354", 3) != 0)
    return SMTP_DATA_ERR;


  /* send message data */
  WriteToSocket(connection, message.c_str(), strlen(message.c_str()));
  WriteToSocket(connection, "\r\n.\r\n", 5);

  if (gAlthea.get_Verbose() == 2) {
    cout << "C: " << message << endl;
    cout << "\r\n.\r\n";
  }

  errcode = readTilEOL(connection);
  if (strncmp(errcode.c_str(), "250", 3) != 0)
    return SMTP_SEND_ERR;


  /* quit */
  WriteToSocket(connection, "QUIT\r\n", 6);

  if (gAlthea.get_Verbose() == 2)
    cout << "C: QUIT" << endl;

  errcode = readTilEOL(connection);
  if (strncmp(errcode.c_str(), "221", 3) != 0)
    return SMTP_QUIT_ERR;


  return SUCCESS;
}

bool valid_address (const string &rcpt)
{
	int i;
	for (i = 0; rcpt[i] != '\0'; i++)
	{
		if (!(isspace(rcpt[i])))
			return true;
	}
	return false;
}
