# J.7 What do anarchists mean by social revolution?

In anarchist theory, **_social revolution_** means far more than just
revolution. For anarchists, a true revolution is far more than just a change
in the political makeup, structure or form of a society. It must transform all
aspects of a society -- political, economic, social, interpersonal
relationships, and so on -- and the individuals who comprise it. Indeed, these
two transformations go hand in hand, complementing each other and supporting
each other. People, while transforming society, transform themselves. As
Alexander Berkman put it:

> _"there are revolutions and revolutions. Some revolutions change only the
governmental form by putting a new set of rulers in place of the old. These
are political revolutions, and as such they often meet with little resistance.
But a revolution that aims to abolish the entire system of wage slavery must
also do away with the power of one class to oppress another. That is, it is
not any more a mere change of rulers, of government, not a political
revolution, but one that seeks to alter the whole character of society. That
would be a **social** revolution."_ [**What is Anarchism?**, p. 176]

It means two related things. First, it means transforming all parts of society
and not just tinkering with certain aspects of the current system. Where
political revolution means, in essence, changing bosses, social revolution
means changing society, a transformation in the way society is organised and
run. Social revolution, in other words, does not aim to change one form of
subjection for another, but to do away with everything that can enslave and
oppress the individual. Second, it means bringing about this fundamental
change **directly** by the mass of people in society, rather than relying on
political means of achieving this end, in the style of Marxist-Leninists and
other authoritarian socialists. For anarchists, such an approach is a
political revolution only and doomed to failure. The _"actual, positive work
of the social revolution must . . . be carried out by the toilers themselves,
by the labouring people"_ as _"the worse victims of present institutions, it
is to their own interest to abolish them."_ [Berkman, **Op. Cit.**, p. 189 and
p. 187]

That is not to say that an anarchist social revolution is not political in
content -- far from it; it should be obvious to anyone familiar with anarchist
theory that there are political theories and goals at work within anarchism.
With an analysis of the state which proclaims it to be an instrument of
minority class rule, designed to exclude participation by the many, it should
be obvious that we aim to abolish it. What we **are** saying, however, is that
anarchists do not seek to seize power and attempt, through control of law
enforcement and the military (in the style of governments) to bring change
about from the top-down. Rather, we seek to bring change upward from below,
and in so doing, make such a revolution inevitable and not contingent on the
machinations of a political vanguard (unsurprisingly, as we noted in [section
H.3.3](secH3.md#sech33), Lenin dismissed talk of change exclusively from
below as anarchist and saw the need for change from above by government). As
Durruti argued: _"We never believed that the revolution consisted of the
seizure of power by a minority which would impose a dictatorship on the people
. . . We want a revolution by and for the people. Without this no revolution
is possible. It would be a Coup d'Etat, nothing more."_ [quoted by Abel Paz,
**Durruti: The People Armed**, pp. 135-7]

For anarchists, a social revolution is a movement from below, of the oppressed
and exploited struggling for their own freedom. Moreover, such a revolution
does not appear as if by magic. Rather, it is the case that revolutions _"are
not improvised. They are not made at will by individuals nor even by the most
powerful associations. They come independently of all will and all
conspiracies, and are always brought on by the natural force of
circumstance."_ [Bakunin, **The Political Philosophy of Bakunin**, p. 323]
Revolutions break-out when the conditions are ripe and cannot be artificially
produced (by, say, a union leadership proclaiming out of the blue such-and-
such a day for a general strike). However, the actions of individuals and
associations can make revolution more likely by their propaganda, struggles
and organising so that when the circumstances change, people are able and
willing to act in a revolutionary manner (by, say, spontaneously going on
strike and their unions expanding the struggle into a general strike). This
means that there is no mechanical, objective, process at work but rather
something which we can influence but not command. Revolutions are a product of
social evolution and of the social struggle which is an inevitable part of it:

> _"the oppressed masses . . . have never completely resigned themselves to
oppression and poverty, and who today more than ever show themselves thirsting
for justice, freedom and wellbeing, are beginning to understand that they will
not be able to achieve their emancipation except by union and solidarity with
all the oppressed, with the exploited everywhere in the world. And they also
understand that the indispensable condition for their emancipation which
cannot be neglected is the possession of the means of production, of the land
and of the instruments of labour."_ [Malatesta, **Anarchy**, p. 33]

Thus any social revolution proceeds from the daily struggles of working class
people (just as anarchism does). It is not an event, rather it is a
**process** \-- a process which is occurring at this moment. So a social
revolution is not something in the future which we wait for but an process
which is occurring in the here and now which we influence along side other
tendencies as well as objective factors. This means that _"evolution and
revolution are not two separate and different things. Still less are they
opposites . . . Revolution is merely the boiling point of evolution."_
[Berkman, **Op. Cit.**, p. 179] This means how we act **now** matters as we
shape the future by our struggles today. As German Anarchist Gustav Landauer
put it:

> _"The State is not something that can be destroyed by a revolution, but it
is a condition, a certain relationship between human beings, a mode of human
behaviour; we destroy it by contracting other relationships, by behaving
differently."_ [quoted by George Woodcock, **Anarchism**, p. 421]

This does not mean that anarchists do not recognise that a revolution will be
marked by, say, specific events (such as a general strike, wide scale
occupations of land, housing, workplaces, actual insurrections and so on). Of
course not. It means that we place these events in a process, within social
movements recognising that they do not occur in isolation from history nor the
evolution of ideas and movements within society.

Berkman echoed this point when he argued that while _"a social revolution is
one that entirely changes the foundation of society, its political, economic
and social character"_ such a change _"must **first** take place in the ideas
and opinions of the people, in the minds of men [and women]."_ This means that
_"the social revolution must be prepared. Prepared in these sense of
furthering evolutionary process, of enlightening the people about the evils of
present-day society and convincing them of the desirability and possibility,
of the justice and practicability of a social life based on liberty."_ [**Op.
Cit.**, p. 180-1] Such preparation would be the result of social struggle in
the here and now, social struggle based on direct action, solidarity and self-
managed organisations. While Berkman concentrated on the labour movement, his
comments are applicable to all social movements:

> _"In the daily struggle of the proletariat such an organisation [a
syndicalist union] would be able to achieve victories about which the
conservative union, as at present built, cannot even dream . . . Such a union
would soon become something more than a mere defender and protector of the
worker. It would gain a vital realisation of the meaning of unity and
consequent power, of labour solidarity. The factory and shop would serve as a
training camp to develop the worker's understanding of his [or her] proper
role in life, to cultivate his [or her] self-reliance and independence, teach
him [or her] mutual help and co-operation, and make him [or her] conscious of
his [or her] responsibility. He [or she] will learn to decide and act on his
[or her] own judgement, not leaving it to leaders or politicians to attend to
his [or her] affairs and look out for his [or her] welfare . . . He [or she]
will grow to understand that present economic and social arrangements are
wrong and criminal, and he [or she] will determine to change them. The shop
committee and union will become the field of preparation for a new economic
system, for a new social life."_ [**Op. Cit.**, pp. 206-7]

In other words, the struggle against authority, exploitation, oppression and
domination in the here and now is the start of the social revolution. It is
this daily struggle, Bakunin stressed, which creates free people and the
organisations it generates _"bear . . . the living seed of the new society
which is to replace the old one. They are creating not only the ideas, but
also the facts of the future itself."_ Therefore (libertarian) socialism will
be attained only _"through the development and organisation of the non-
political or anti-political social power of the working classes in city and
country."_ [**Bakunin On Anarchism**, p. 255 and p. 263] Such social power is
expressed in economic and community organisations such as self-managed unions
and workplace/community assemblies (see [section J.5](secJ5.md)) and these
form the organisational framework of a free society (see [section
I.2.3](secI2.md#seci23)).

Anarchists try and follow the example of our Spanish comrades in the C.N.T.
and F.A.I. who, when _"faced with the conventional opposition between
reformism and revolution, they appear, in effect, to have put forward a third
alternative, seeking to obtain immediate practical improvements through the
actual development, in practice, of autonomous, libertarian forms of self-
organisation."_ [Nick Rider, _"The Practice of Direct Action: The Barcelona
Rent Strike of 1931"_, pp. 79-105, **For Anarchism**, David Goodway (ed.), p.
99] While doing this, anarchists must also _"beware of ourselves becoming less
anarchist because the masses are not ready for anarchy."_ [Malatesta, **Errico
Malatesta: His Life and Ideas**, p. 162]

So revolution and anarchism is the product of struggle, a social process in
which anarchist ideas spread and develop. _"This does not mean,"_ argued
Malatesta, _"that to achieve anarchy we must wait till **everyone** becomes an
anarchist. On the contrary . . . under present conditions only a small
minority, favoured by specific circumstances, can manage to conceive what
anarchy is. It would be wishful thinking to hope for a general conversion
before a change actually took place in the kind of environment in which
authoritarianism and privilege now flourish. It is precisely for this reason
that [we] . . . need to organise for the bringing about of anarchy, or at any
rate that degree of anarchy which could become gradually feasible, as soon as
a sufficient amount of freedom has been won and a nucleus of anarchists
somewhere exists that is both numerically strong enough and able to be self-
sufficient and to spread its influence locally."_ [**The Anarchist
Revolution**, pp. 83-4]

Thus anarchists influence social struggle, the revolutionary process, by
encouraging anarchistic tendencies within those who are not yet anarchists but
are instinctively acting in a libertarian manner. Anarchists spread our
message to those in struggle and support libertarian tendencies in it as far
as we can. In this way, more and more people will become anarchists and
anarchy will become increasingly possible (we discuss the role of anarchists
in a social revolution in [section J.7.4](secJ7.md#secj74)). For anarchists,
a social revolution is the end product of years of struggle. It is marked by
the transformation of a given society, the breaking down of all forms of
oppression and the creation of new ways of living, new forms of self-managed
organisation, a new attitude to life itself. Moreover, we do not wait for the
future to introduce such transformations in our daily life. Rather, we try and
create as many anarchistic tendencies in today's society as possible in the
firm belief that in so doing we are pushing the creation of a free society
nearer.

So anarchists, including revolutionary ones, try to make the world today more
libertarian and so bring us closer to freedom. Few anarchists think of anarchy
as something in (or for) the distant future, rather it is something we try and
create in the here and now by living and struggling in a libertarian manner.
Once enough people do this, then a more extensive change towards anarchy (i.e.
a revolution) is possible.

## J.7.1 Why are most anarchists revolutionaries?

While most anarchists do believe that a social revolution is required to
create a free society, some reject the idea. This is because they think that
revolutions are by their very nature coercive and so are against anarchist
principles. In the words of Proudhon (in reply to Marx):

> _"Perhaps you still hold the opinion that no reform is possible without a
helping **coup de main,** without what used to be called a revolution but
which is quite simply a jolt. I confess that my most recent studies have led
me to abandon this view, which I understand and would willingly discuss, since
for a long time I held it myself. I do not think that this is what we need in
order to succeed, and consequently we must not suggest **revolutionary**
action as the means of social reform because this supposed means would simply
be an appeal to force and to arbitrariness. In brief, it would be a
contradiction."_ [**Selected Writings of Pierre-Joseph Proudhon**, p. 151]

Also they point to the fact that the state is far better armed than the
general population, better trained and (as history proves) more than willing
to slaughter as many people as required to restore "order." In face of this
power, they argue, revolution is doomed to failure.

Those opposed to revolution come from all tendencies of the movement.
Traditionally, Individualist anarchists are usually against the idea of
revolution, as was Proudhon. However, with the failure of the Russian
Revolution and the defeat of the CNT-FAI in Spain, some social anarchists have
rethought support for revolution. Rather than seeing revolution as the key way
of creating a free society they consider it doomed to failure as the state is
too strong a force to be overcome by insurrection. Instead of revolution, such
anarchists support the creation of alternatives, such as co-operatives, mutual
banks and so on, which will help transform capitalism into libertarian
socialism by _"burn[ing] Property little by little"_ via _"some system of
economics"_ which will _"put back into society . . . the wealth which has been
taken out of society by another system of economics."_ [Proudhon, **Op.
Cit.**, p. 151] Such alternative building, combined with pressurising the
state to, say, use co-operatives to run public services and industries as well
as civil disobedience and non-payment of taxes, is seen as the best way to
creating anarchy. This may take time, they argue, but such gradual change will
be more successful in the long run.

Most revolutionary anarchists agree on the importance of building libertarian
alternatives in the here and now. They would agree with Bakunin when he argued
that such organisations as libertarian unions, co-operatives and so on are
essential _"so that when the Revolution, brought about by the natural force of
circumstances, breaks out, there will be a real force at hand which knows what
to do and by virtue thereof is capable of taking the Revolution into its own
hands and imparting to it a direction salutary for the people: a serious,
international organisation of worker's organisations of all countries, capable
of replacing the departing political world of the States and the
bourgeoisie."_ [**The Political Philosophy of Bakunin**, p. 323] Thus, for
most anarchists, the difference between evolution and revolution is one of
little import -- anarchists should support libertarian tendencies within
society as they support revolutionary situations when they occur.

However, revolutionary anarchists argue that, ultimately, capitalism cannot be
reformed away nor will the state wither away under the onslaught of
libertarian institutions and attitudes. Neither mutual banking (see [section
J.5.7](secJ5.md#secj57)) nor co-operatives (see [section
J.5.11](secJ5.md#secj511)) can out-compete capitalist institutions. This
means that these alternatives, while important, are insufficient to the task
of creating a free society. This suggests that while libertarian tendencies
within capitalism may make life better under that system, they cannot get rid
of it. This requires a social revolution. Such anarchists agree with Alexander
Berkman that there _"is no record of any government or authority, of any group
or class in power having given up its mastery voluntarily. In every instance
it required the use of force, or at least the threat of it."_ [**What is
Anarchism?**, p. 174] Even the end of State capitalism ("Communism") in
Eastern Europe did not contradict this argument. Without the mass action of
the population, the regime would have continued. Faced with a massive popular
revolt, the Commissars realised that it was better to renounce (some) power
than have it all taken from them (and they were right, as this allowed many of
them to become part of the new, private capitalist, ruling class). Thus mass
rebellion, the start of any true revolution, was required.

The argument that the state is too powerful to be defeated has been proven
wrong time and time again. Every revolution has defeated a military machine
which previously had been proclaimed to be unbeatable (most obviously, the
people armed in Spain defeated the military in two-thirds of the country).
Ultimately, the power of the state rests on its troops following orders. If
those troops rebel, then the state is powerless. That is why anarchists have
always produced anti-militarist propaganda urging troops to join strikers and
other people in revolt. Revolutionary anarchists argue that any state can be
defeated, if the circumstances are right and the work of anarchists is to
encourage those circumstances.

In addition, revolutionary anarchists argue that even if anarchists did not
support revolutionary change, this would not stop such events happening.
Revolutions are the product of developments in human society and occur whether
we desire them or not. They start with small rebellions, small acts of refusal
by individuals, groups, workplaces and communities, then grow. These acts of
rebellion are inevitable in any hierarchical society, as is their spreading
wider and wider. Revolutionary anarchists argue that anarchists must, by the
nature of our politics and our desire for freedom, support such acts of
rebellion and, ultimately, social revolution. Not to do so means ignoring
people in struggle against our common enemy and ignoring the means by which
anarchist ideas and attitudes will grow within existing society. Thus
Alexander Berkman was right when he wrote:

> _"That is why it is no prophecy to foresee that some day it must come to
decisive struggle between the masters of life and the dispossessed masses._

> _"As a matter if fact, that struggle is going on all the time._

> _"There is a continuous warfare between capital and labour. That warfare
generally proceeds within so-called legal forms. But even these erupt now and
then in violence, as during strikes and lockouts, because the armed fist of
government is always at the service of the masters, and that fist gets into
action the moment capital feels its profits threatened: then it drops the mask
of 'mutual interests' and 'partnership' with labour and resorts to the final
argument of every master, to coercion and force._

> _"It is therefore certain that government and capital will not allow
themselves to be quietly abolished if they can help it; nor will they
miraculously 'disappear' of themselves, as some people pretend to believe. It
will require a revolution to get rid of them."_ [**Op. Cit.**, p. 174]

However, all anarchists are agreed that any revolution should be as non-
violent as possible. Violence is the tool of oppression and, for anarchists,
violence is only legitimate as a means of self-defence against authority.
Therefore revolutionary anarchists do not seek "violent revolution" -- they
are just aware that when people refuse to kow-tow to authority then that
authority will use violence against them. This use of violence has been
directed against non-violent forms of direct action and so those anarchists
who reject revolution will not avoid state violence directed against them
unless they renounce **all** forms of resistance to state and capitalist
authority. So when it comes to effective action by the subjects of an
authority, the relevant question quickly becomes how much does our freedom
depend on us **not** exercising it?

Nor do revolutionary anarchists think that revolution is in contradiction to
the principles of anarchism. As Malatesta put it, _"[f]or two people to live
in peace they must both want peace; if one insists on using force to oblige
the other to work for him and serve him, then the other, if he wishes to
retain his dignity as a man and not be reduced to abject slavery, will be
obliged, in spite of his love of peace, to resist force with adequate means."_
[**Errico Malatesta: His Life and Ideas**, p. 54] Under any hierarchical
system, those in authority do not leave those subject to them in peace. The
boss does not treat his/her workers as equals, working together by free
agreement without differences in power. Rather, the boss orders the worker
about and uses the threat of sanctions to get compliance. Similarly with the
state. Under these conditions, revolution cannot be authoritarian -- for it is
not authoritarian to destroy authority! To quote Rudolf Rocker:

> _"We . . . know that a revolution cannot be made with rosewater. And we
know, too, that the owning classes will never yield up their privileges
spontaneously. On the day of victorious revolution the workers will have to
impose their will on the present owners of the soil, of the subsoil and of the
means of production, which cannot be done -- let us be clear on this --
without the workers taking the capital of society into their own hands, and,
above all, without their having demolished the authoritarian structure which
is, and will continue to be, the fortress keeping the masses of the people
under dominion. Such an action is, without doubt, an act of liberation; a
proclamation of social justice; the very essence of social revolution, which
has nothing in common with the utterly bourgeois principle of dictatorship."_
[_"Anarchism and Sovietism"_, pp. 53-74, **The Poverty of Statism**, Albert
Meltzer (ed.), p. 73]

It should also be noted that those who proclaim that a revolution is
inherently authoritarian like, say, Engels (see [section
H.4.7](secH4.md#sech47)) are confused. They fail to see that it is hardly
"authoritarian" to stop someone ruling you! It is an act of liberation to free
oneself from those oppressing you. Malatesta comments reflect well the
position of revolutionary anarchists with regards to the use of force:

> _"We neither seek to impose anything by force nor do we wish to submit to a
violent imposition._

> _"We intend to use force against government, because it is by force that we
are kept in subjection by government._

> _"We intend to expropriate the owners of property because it is by force
that they withhold the raw materials and wealth, which is the fruit of human
labour, and use it to oblige others to work in their interest._

> _"We shall resist with force whoever would wish by force, to retain or
regain the means to impose his will and exploit the labour of others . . ._

> _"With the exception of these cases, in which the use of violence is
justified as a defence against force, we are always against violence, and for
self-determination."_ [**Op. Cit.**, p. 56]

This is the reason why most anarchists are revolutionaries. They do not think
it against the principles of anarchism and consider it the only real means of
creating a free society -- a society in which the far greater, and permanent,
violence which keeps the majority of humanity in servitude can be ended once
and for all.

## J.7.2 Is social revolution possible?

One objection to the possibility of social revolution is based on what we
might call "the paradox of social change." This argument goes as follows:
authoritarian institutions reward and select people with an authoritarian type
of personality for the most influential positions in society; such types of
people have both (a) an interest in perpetuating authoritarian institutions
(from which they benefit) and (b) the power to perpetuate them; hence they
create a self-sustaining and tightly closed system which is virtually
impervious to the influence of non-authoritarian types. Therefore,
institutional change presupposes individual change, which presupposes
institutional change, and so on. Unless it can be shown, then, that
institutions and human psychology can both be changed **at the same time**,
hope for a genuine social revolution (instead of just another rotation of
elites) appears to be unrealistic.

Connected with this problem is the fact that the psychological root of the
hierarchical society is addiction to power -- over other people, over nature,
over the body and human emotions -- and that this addiction is highly
contagious. That is, as soon as any group of people anywhere in the world
becomes addicted to power, those within range of their aggression also feel
compelled to embrace the structures of power, including centralised control
over the use of deadly force, in order to protect themselves from their
neighbours. Once these structures of power are adopted, authoritarian
institutions become self-perpetuating.

In this situation, fear becomes the underlying emotion behind the
conservatism, conformity, and mental inertia of the majority, who in that
state become vulnerable to the self-serving propaganda of authoritarian elites
alleging the necessity of the state, strong leaders, militarism, "law and
order," capitalists, rulers, etc. The simultaneous transformation of
institutions and individual psychology becomes even more difficult to imagine.

Serious as these obstacles may be, they do not warrant despair. To see why,
let us note first that "paradigm shifts" in science have not generally derived
from new developments in one field alone but from a convergence of cumulative
developments in several different fields at once. For example, the Einsteinian
revolution which resulted in the overthrow of the Newtonian paradigm was due
to simultaneous progress in mathematics, physics, astronomy and other sciences
that all influenced, reacted on, and cross-fertilised each other (see Thomas
Kuhn's **The Structure of Scientific Revolutions**). Similarly, if there is
going to be a "paradigm shift" in the social realm, i.e. from hierarchical to
non-hierarchical institutions, it is likely to emerge from the convergence of
a number of different socio-economic and political developments at the same
time. In a hierarchical society, the oppression authority produces also
generates resistance, and so hope. The _"instinct for freedom"_ cannot be
repressed forever.

That is why anarchists stress the importance of direct action ([section
J.2](secJ2.md)) and self-help ([section J.5](secJ5.md)). By the very
process of struggle, by practising self-management, direct action and
solidarity, people create the necessary "paradigm shift" in both themselves
and society as a whole. Thus the struggle against authority is the school of
anarchy -- it encourages libertarian tendencies in society and the
transformation of individuals into anarchists (_"Only freedom or the struggle
for freedom can be the school for freedom."_ [Malatesta, **Errico Malatesta:
His Life and Ideas**, p. 59]). In a revolutionary situation, this process is
accelerated. It is worth quoting Murray Bookchin at length on this subject:

> _"Revolutions are profoundly educational processes, indeed veritable
cauldrons in which all kinds of conflicting ideas and tendencies are sifted
out in the minds of a revolutionary people . . ._

> _"Individuals who enter into a revolutionary process are by no means the
same after the revolution as they were before it began. Those who encounter a
modicum of success in revolutionary times learn more within a span of a few
weeks or months than they might have learned over their lifetime in non-
revolutionary times. Conventional ideas fall away with extraordinary rapidity;
values and prejudices that were centuries in the making disappear almost
overnight. Strikingly innovative ideas are quickly adopted, tested, and, where
necessary, discarded. Even newer ideas, often flagrantly radical in character,
are adopted with an elan that frightens ruling elites -- however radical the
latter may profess to be -- and they soon become deeply rooted in the popular
consciousness. Authorities hallowed by age-old tradition are suddenly divested
of their prestige, legitimacy, and power to govern . . ._

> _"So tumultuous socially and psychologically are revolutions in general that
they constitute a standing challenge to ideologues, including sociobiologists,
who assert that human behaviour is fixed and human nature predetermined.
Revolutionary changes reveal a remarkable flexibility in 'human nature,' yet
few psychologists have elected to study the social and psychological tumult of
revolution as well as the institutional changes it so often produces. Thus
much must be said with fervent emphasis: **to continue to judge the behaviour
of a people during and after a revolution by the same standards one judged
them by beforehand is completely myopic.**_

> _"I wish to argue that the capacity of a revolution to produce far-reaching
ideological and moral changes in a people stems primarily from the opportunity
it affords ordinary, indeed oppressed, people to exercise popular self-
management -- to enter directly, rapidly, and exhilaratingly into control over
most aspects of their social and personal lives. To the extent that an
insurrectionary people takes over the reins of power from the formerly
hallowed elites who oppressed them and begins to restructure society along
radically populist lines, individuals grow aware of latent powers within
themselves that nourish their previously suppressed creativity, sense of self-
worth, and solidarity. They learn that society is neither immutable nor
sanctified, as inflexible custom had previously taught them; rather, it is
malleable and subject, within certain limits, to change according to human
will and desire."_ [**The Third Revolution**, vol. 1, pp. 6-7]

In short, _"it is only through th[e] struggle for freedom, equality and
solidarity that you will reach an understanding of anarchism."_ [Nestor
Makhno, **The Struggle Against the State and Other Essays**, p. 71]

So, social revolutions are possible. Anarchists anticipate successful revolts
within certain circumstance. People who are in the habit of taking orders from
bosses are not capable of creating a new society. Tendencies towards freedom,
self-management, co-operation and solidarity are not simply an act of ethical
will which overcomes the competitive and hierarchical behaviour capitalism
generates within those who live in it. Capitalism is, as Malatesta noted,
based on competition -- and this includes **within** the working class.
However, **_co-operation_** is stimulated within our class by our struggles to
survive in and resist the system. This tendency for co-operation generated by
struggle against capitalism also produces the habits required for a free
society -- by struggling to change the world (even a small part of it), people
also change themselves. Direct action produces empowered and self-reliant
people who can manage their own affairs themselves. It is on the liberating
effects of struggle, the tendencies towards individual and collective self-
management and direct action it generates, the needs and feelings for
solidarity and creative solutions to pressing problems it produces that
anarchists base their positive answer on whether social revolution is
possible. History has shown that we are right. It will do so again.

## J.7.3 Doesn't revolution mean violence?

While many try and paint revolutions (and anarchists) as being violent by
their very nature, the social revolution desired by anarchists is essentially
non-violent. This is because, to quote Bakunin, _"[i]n order to launch a
radical revolution, it is . . . necessary to attack positions and things and
to destroy property and the State, but there will be no need to destroy men
and to condemn ourselves to the inevitable reaction which is unfailingly
produced in every society by the slaughter of men."_ [**Michael Bakunin:
Selected Writings**, pp. 168-9] Equally, to destroy the institution of private
property there is no need to destroy the actual useful things monopolised by
the few:

> _"How to smash the tyranny of capital? Destroy capital? But that would be to
destroy all the riches accumulated on earth, all primary materials, all the
instruments of labour, all the means of labour . . . Thus capital cannot and
must not be destroyed. It must be preserved . . . there is but a single
solution -- **the intimate and complete union of capital and labour** . . .
the workers must obtain not individual but **collective** property in capital
. . . the collective property of capital . . . [is] the absolutely necessary
conditions of the emancipation **of labour and of the workers.**"_ [**The
Basic Bakunin**, pp. 90-1]

The essentially non-violent nature of anarchist ideas of social revolution can
be seen from the Seattle General Strike of 1919. Here is a quote from the
Mayor of Seattle (we do not think we need to say that he was not on the side
of the strikers):

> _"The so-called sympathetic Seattle strike was an attempted revolution. That
there was no violence does not alter the fact . . . The intent, openly and
covertly announced, was for the overthrow of the industrial system; here
first, then everywhere . . . True, there were no flashing guns, no bombs, no
killings. Revolution, I repeat, doesn't need violence. The general strike, as
practised in Seattle, is of itself the weapon of revolution, all the more
dangerous because quiet. To succeed, it must suspend everything; stop the
entire life stream of a community . . . That is to say, it puts the government
out of operation. And that is all there is to revolt -- no matter how
achieved."_ [quoted by Howard Zinn, **A People's History of the United
States**, pp. 370-1]

If the strikers had occupied their workplaces and local communities had
created popular assemblies then the attempted revolution would have become an
actual one without any use of violence at all. In Italy, a year later, the
occupations of the factories and land started. As Malatesta pointed out, _"in
**Umanita Nova** [the daily anarchist newspaper] we . . . said that if the
movement spread to all sectors of industry, that is workers and peasants
followed the example of the metallurgists, of getting rid of the bosses and
taking over the means of production, the revolution would succeed without
shedding a single drop of blood."_ Thus the _"occupation of the factories and
the land suited perfectly our programme of action."_ [**Errico Malatesta: His
Life and Ideas**, p. 135] Sadly the workers followed their socialist trade
union leaders and stopped the occupations rather than spreading them.

These events indicate the strength of ordinary people and the relative
weakness of government and capitalism -- they only work when they can force
people to respect them. After all, a government is _"only a handful of men"_
and is strong _"when the people are with it. Then they supply the government
with money, with an army and navy, obey it, and enable it to function."_
Remove that support and _"no government can accomplish anything."_ The same
can be said of capitalists, whose wealth _"would do them no good but for the
willingness of the people to work for them and pay tribute to them."_ Both
would _"find out that all their boasted power and strength disappear when the
people refuse to acknowledge them as masters, refuse to let them lord it over
them."_ In contrast, _"the people's power"_ is _"**actual**: it cannot be
taken away . . . It cannot be taken away because it does not consist of
possessions but in ability. It is the ability to create, to produce."_ To
achieve a free society we need to _"be conscious of its tremendous power."_
[Alexander Berkman, **What is Anarchism?**, p. 84, p. 86, p. 87 and p. 83]

Therefore the notion that a social revolution is necessarily violent is a
false one. For anarchists, social revolution is essentially an act of self-
liberation (of both the individuals involved and society as a whole). It has
nothing to do with violence, quite the reverse, as anarchists see it as the
means to end the rule and use of violence in society. Anarchists hope that any
revolution is essentially non-violent, with any violence being defensive in
nature. As Malatesta stressed, _"Anarchists are opposed to violence"_ and it
_"is justifiable only when it is necessary to defend oneself and others from
violence."_ [**Errico Malatesta: His Life and Ideas**, p. 53]

Of course, many revolutions are marked by violence. It has two sources. First,
and most obviously, the violent resistance of those protecting their power and
wealth against those seeking liberty. Unsurprisingly, this violence is usually
downplayed in history books and the media. Second, acts of revenge resulting
from the domination and repression of the system the revolution seeks to end.
Such violence is not desired nor the aim of anarchism nor of the revolution.
As Berkman argued:

> _"We know that revolution begins with street disturbances and outbreaks; it
is the initial phase which involves force and violence. But that is merely the
spectacular prologue of the real revolution. The age long misery and indignity
suffered by the masses burst into disorder and tumult, the humiliation and
injustice meekly borne for decades find vents in acts of fury and destruction.
That is inevitable, and it is solely the master class which is responsible for
this preliminary character of revolution. For it is even more true socially
than individually that 'whoever sows the wind will reap the whirlwind'; the
greater the oppression and wretchedness to which the masses had been made to
submit, the fiercer will rage the social storm. All history proves it, but the
lords of life have never harkened to its warning voice."_ [**Op. Cit.**, p.
195]

_"Most people have very confused notions about revolution,"_ Berkman
suggested. _"To them it means just fighting, smashing things, destroying. It
is the same as if rolling up your sleeves for work should be considered the
work itself that you have to do. The fighting bit of the revolution is merely
the rolling up of your sleeves."_ The task of the revolution is the
_"destruction of the existing conditions"_ and _"**conditions** are not
destroyed [by] breaking and smashing things. You can't destroy wage slavery by
wrecking the machinery in the mills and factories . . . You won't destroy
government by setting fire to the White House."_ To think of revolution _"in
terms of violence and destruction is to misinterpret and falsify the whole
idea of it. In practical application such a conception is bound to lead to
disastrous results."_ For what is there to destroy? _"The wealth of the rich?
Nay, that is something we want the whole of society to enjoy."_ The means of
production are to be made _"useful to the entire people"_ and _"serve the
needs of all."_ Thus the aim of revolution is _"to **take over** things for
the general benefit, not to destroy them. It is to reorganise conditions for
public welfare . . . to reconstruct and rebuild."_ [**Op. Cit.**, pp. 183-4]

Thus when anarchists like Bakunin speak of revolution as "destruction" they
mean that the idea of authority and obedience must be destroyed, along with
the institutions that are based on such ideas. We do not mean, as can be
clearly seen, the destruction of people or wealth. Nor do we imply the
glorification of violence -- quite the reserve, as anarchists seek to limit
violence to that required for self-defence against oppression and authority.

Therefore a social revolution **may** involve some violence. It may also mean
no violence at all. It depends on the revolution and how widely anarchist
ideas are spread. One thing is sure, for anarchists social revolution is
**not** synonymous with violence. Indeed, violence usually occurs when the
ruling class resists the action of the oppressed -- that is, when those in
authority act to protect their social position.

The wealthy and their state will do anything in their power to prevent having
a large enough percentage of anarchists in the population to simply "ignore"
the government and property out of existence. If things got that far, the
government would suspend the legal rights, elections and round up influential
subversives. The question is, what do anarchists do in response to these
actions? If anarchists are in the majority or near it, then defensive violence
would likely succeed. For example, _"the people armed"_ crushed the fascist
coup of July 19th, 1936 in Spain and resulted in one of the most important
experiments in anarchism the world has ever seen (see [section
A.5.6](secA5.md#seca56)). This should be contrasted with the aftermath of
the factory occupations in Italy in 1920 and the fascist terror which crushed
the labour movement (see [section A.5.5](secA5.md#seca55)). In other words,
you cannot just ignore the state even if the majority are acting, you need to
abolish it and organise self-defence against attempts to re-impose it or
capitalism.

We discuss the question of self-defence and the protection of the revolution
in [section J.7.6](secJ7.md#secj76).

## J.7.4 What would a social revolution involve?

Social revolution necessitates putting anarchist ideas into daily practice.
Therefore it implies that direct action, solidarity and self-management become
increasingly the dominant form of living in a society. It implies the
transformation of society from top to bottom. We can do no better than quote
Errico Malatesta on what revolution means:

> _"The Revolution is the creation of new living institutions, new groupings,
new social relationships; it is the destruction of privileges and monopolies;
it is the new spirit of justice, of brotherhood, of freedom which must renew
the whole of social life, raise the moral level and the material conditions of
the masses by calling on them to provide, through their direct and conscious
action, for their own futures. Revolution is the organisation of all public
services by those who work in them in their own interest as well as the
public's; Revolution is the destruction of all of coercive ties; it is the
autonomy of groups, of communes, of regions; Revolution is the free federation
brought about by a desire for brotherhood, by individual and collective
interests, by the needs of production and defence; Revolution is the
constitution of innumerable free groupings based on ideas, wishes, and tastes
of all kinds that exist among the people; Revolution is the forming and
disbanding of thousands of representative, district, communal, regional,
national bodies which, without having any legislative power, serve to make
known and to co-ordinate the desires and interests of people near and far and
which act through information, advice and example. Revolution is freedom
proved in the crucible of facts -- and lasts so long as freedom lasts."_
[**Errico Malatesta: His Life and Ideas**, p. 153]

This, of course, presents a somewhat wide vision of the revolutionary process.
We will need to give some more concrete examples of what a social revolution
would involve. However, before so doing, we stress that these are purely
examples drawn from previous revolutions and are not written in stone. Every
revolution creates its own forms of organisation and struggle. The next one
will be no different. As we argued in [section I.2](secI2.md), an anarchist
revolution will create its own forms of freedom, forms which will share
features with organisations generated in previous revolutions, but which are
unique to this one. Thus the Paris Commune of 1871 had mandated and recallable
delegates as did the Russian soviets of 1905 and 1917, but the first was based
on geographical delegation and the later on workplaces. All we do here is give
a rough overview of what we expect (based on previous revolutions) to see
occur in a future social revolution. We are not predicting the future. As
Kropotkin put it:

> _"A question which we are often asked is: 'How will you organise the future
society on Anarchist principles?' If the question were put to . . . someone
who fancies that a group of men [or women] is able to organise society as they
like, it would seem natural. But in the ears of an Anarchist, it sounds very
strangely, and the only answer we can give to it is: 'We cannot organise you.
It will depend upon **you** what sort of organisation you choose.'"_ [**Act
for Yourselves**, p. 32]

And organise themselves they have. In every social revolution, the oppressed
have created many different self-managed organisations. These bodies include
the directly democratic neighbourhood Sections of the Great French Revolution,
the neighbourhood clubs of the 1848 French Revolution and the Paris Commune,
the workers councils and factory committees of the Russian and German
revolutions, the industrial and rural collectives of the Spanish Revolution,
the workers councils of the Hungarian revolution of 1956, assemblies and
action committees of the 1968 revolt in France, the neighbourhood assemblies
and occupied workplaces of the 2001 revolt in Argentina, and so on. These
bodies were hardly uniform in structure and some were more anarchistic than
others, but the tendency towards self-management and federation existed in
them all. This tendency towards anarchistic solutions and organisation is not
unsurprising, for, as Nestor Makhno argued, _"[i]n carrying through the
revolution, under the impulsion of the anarchism that is innate in them, the
masses of humanity search for free associations. Free assemblies always
command their sympathy. The revolutionary anarchist must help them to
formulate this approach as best they can."_ [**The Struggle Against the State
and Other Essays**, p. 85]

In addition, we must stress that we are discussing an **anarchist** social
revolution in this section. As we noted in [section I.2.2](secI2.md#seci22),
anarchists recognise that any revolution will take on different forms in
different areas and develop in different ways and at different speeds. We
leave it up to others to describe their vision of revolution (for Marxists,
the creation of a "workers' state" and the seizure of power by the
"proletarian" vanguard or party, and so on).

So what would a libertarian revolution involve?

Firstly, a revolution _"is not the work of one day. It means a whole period,
mostly lasting for several years, during which the country is in a state of
effervescence; when thousands of formerly indifferent spectators take a lively
part in public affairs."_ It _"criticises and repudiates the institutions
which are a hindrance to free development . . . it boldly enters upon problems
which formerly seemed insoluble."_ [Kropotkin, **Op. Cit.**, pp. 25-6] Thus,
it would be a **process** in which revolutionary attitudes, ideas, actions and
organisations spread in society until the existing system is overthrown and a
new one takes its place. It does not come overnight. Rather it is an
accumulative development, marked by specific events of course, but
fundamentally it goes on in the fabric of society.

So the **real** Russian revolution occurred during the period between the 1917
February and October insurrections when workers took over their workplaces,
peasants seized their land, new forms of social life (soviets, factory
committees, co-operatives, etc.) were formed and people lost their previous
submissive attitudes to authority by using direct action to change their lives
for the better (see [section A.5.4](secA5.md#seca54)). Similarly, the
Spanish Revolution occurred after the 19th of July, 1936, when workers again
took over their workplaces, peasants formed collectives and militias were
organised to fight fascism (see [section A.5.6](secA5.md#seca56))

Secondly, _"there **must** be a rapid modification of outgrown economical and
political institutions, an overthrow of the injustices accumulated by
centuries past, a displacement of wealth and political power."_ [Kropotkin,
**Op. Cit.**, p. 25] This aspect is the key one. Without the abolition of the
state and capitalism, no real revolution has taken place. As Bakunin argued,
_"the program of social revolution"_ is _"the abolition of all exploitation
and all political or juridical as well as governmental and bureaucratic
oppression, in other words, to the abolition of all classes through the
equalisation of economic conditions, and the abolition of their last buttress,
the state."_ That is, _"the total and definitive liberation of the proletariat
from economic exploitation and state oppression."_ [**Statism and Anarchy**,
pp. 48-9]

We should stress here that, regardless of what Marxists may say, anarchists
see the destruction of capitalism occurring **at the same time as** the
destruction of the state. We do not aim to abolish the state first, then
capitalism as Engels asserted we did (see [section H.2.4](secH2.md#sech24)).
This perspective of a simultaneous political and economic revolution is
clearly seen when Bakunin wrote that a city in revolt would _"naturally make
haste to organise itself as best it can, in revolutionary style, after the
workers have joined into associations and made a clean sweep of all the
instruments of labour and every kind of capital and building; armed and
organised by streets and **quartiers,** they will form the revolutionary
federation of all the **quartiers,** the federative commune"_ All _"the
revolutionary communes will then send representatives to organise the
necessary services and arrangements for production and exchange . . . and to
organise common defence against the enemies of the Revolution."_ [**Michael
Bakunin: Selected Writings**, p. 179]

As can be seen, an essential part of a social revolution is the
_"expropriation of landowners and capitalists for the benefit of all."_
[Malatesta, **Op. Cit.**, p. 198] This would be done by workers occupying
their workplaces and placing them under workers' self-management. As
Voltairine de Cleyre argued in 1910 _"the weapon of the future will be the
general strike"_ and is it not clear that _"it must be the strike which will
**stay in** the factory, not **go out**? which will guard the machines and
allow no scab to touch them? which will organise, not to inflict deprivation
on itself, but on the enemy? which will take over industry and operate it for
the workers, not for franchise holder, stockholders, and officeholders?"_ [_"A
Study of the General Strike in Philadelphia"_, pp. 307-14, **Anarchy! An
Anthology of Emma Goldman's Mother Earth**, Peter Glassgold (ed.), p. 311]
Individual self-managed workplaces would then federate on a local and
industrial basis into workers' councils to co-ordinate joint activity, discuss
common interests and issues as well as ensuring common ownership and
universalising self-management: _"We must push the workers to take possession
of the factories, to federate among themselves and work for the community, and
similarly the peasants should take over the land and the produce usurped by
the landlords, and come to an agreement with the industrial workers on the
necessary exchange of goods."_ [Malatesta, **Op. Cit.**, p. 165]

In this way capitalism is replaced by new economic system based the end of
hierarchy, on self-managed work. These workplace assemblies and local,
regional, etc., federations would start to organise production to meet human
needs rather than capitalist profit. While most anarchists would like to see
the introduction of communistic relations begin as quickly as possible in such
an economy, most are realistic enough to recognise that tendencies towards
libertarian communism will be depend on local conditions. As Malatesta argued:

> _"It is then that graduation really comes into operation. We shall have to
study all the practical problems of life: production, exchange, the means of
communication, relations between anarchist groupings and those living under
some kind of authority, between communist collectives and those living in an
individualistic way; relations between town and country, the utilisation for
the benefit of everyone of all natural resources of the different regions [and
so on] . . . And in every problem [anarchists] should prefer the solutions
which not only are economically superior but which satisfy the need for
justice and freedom and leave the way open for future improvements, which
other solutions might not."_ [**Op. Cit.**, p. 173]

No central government could organise such a transformation. No centralised
body could comprehend the changes required and decide between the
possibilities available to those involved. Hence the very complexity of life,
and the needs of social living, will push a social revolution towards
anarchism. _"Unavoidably,"_ argued Kropotkin, _"the Anarchist system of
organisation -- free local action and free grouping -- will come into play."_
[**Op. Cit.**, p. 72] Unless the economy is transformed from the bottom up by
those who work within it, socialism is impossible. If it is re-organised from
the top-down by a centralised body all that will be achieved is state
capitalism and rule by bureaucrats instead of capitalists. Without local
action and free agreement between local groups to co-ordinate activity, a
revolution would be dead in the water and fit only to produce a new
bureaucratic class structure, as the experience of the Russian Revolution
proves (see [section H.6](secH6.md)).

Therefore, the key economic aspect of a social revolution is the end of
capitalist oppression by the direct action of the workers themselves and their
re-organisation of their work and the economy by their own actions,
organisations and initiative from the bottom-up:

> _"To destroy radically this oppression without any danger of it re-emerging,
all people must be convinced of their right to the means of production, and be
prepared to exercise this basic right by expropriating the landowners, the
industrialists and financiers, and putting all social wealth at the disposal
of the people."_ [Malatesta, **Op. Cit.**, p. 167]

However, the economic transformation is but part of the picture. As Kropotkin
argued, _"throughout history we see that each change in the economic relations
of a community is accompanied by a corresponding change in what may be called
political organisation . . . Thus, too, it will be with Socialism. If it
contemplates a new departure in economics it **must** be prepared for a new
departure in what is called political organisation."_ [**Op. Cit.**, p. 39]
Thus the anarchist social revolution also aims to abolish the state and create
a confederation of self-governing communes to ensure its final elimination.
This destruction of the state is essential as _"those workers who want to free
themselves, or even only to effectively improve their conditions, will be
forced to defend themselves from the government . . . which by legalising the
right to property and protecting it with brute force, constitutes a barrier to
human progress, which must be beaten down . . . if one does not wish to remain
indefinitely under present conditions or even worse."_ Therefore, _"[f]rom the
economic struggle one must pass to the political struggle, that is to the
struggle against government."_ [Malatesta, **Op. Cit.**, p. 195]

Thus a social revolution will have to destroy the state bureaucracy and its
forces of violence and coercion (the police, armed forces, intelligence
agencies, and so on). If this is not done then the state will come back and
crush the revolution. As the CNT newspaper put it in the 1930s, the _"first
step in the social revolution is to take control of Town Hall and proclaim the
free commune. Once this occurs, self-management spreads to all areas of life
and the people exercise their sovereign executive power through the popular
assembly." _This free commune _"is the basic unit of libertarian communism . .
. and, federated, it provides the basic structure of the new society in all
its aspects: administrative, economic and political."_ [quoted by Abel Paz,
**Durruti in the Spanish Revolution**, p. 312]

Such a destruction of the state does not involve violence against individuals,
but rather the end of hierarchical organisations, positions and institutions.
It would involve, for example, the disbanding of the police, army, navy, state
officialdom, etc. It would mean the transformation of police stations,
military bases, the offices used by the bureaucracy into something more useful
(or, as in the case of prisons, their destruction). Town halls would be
occupied and used by community and industrial groups, for example. Offices of
the mayor could be turned into crèches. Police stations, if they have not been
destroyed, could be turned into storage centres for goods (William Morris, in
his utopian novel **News from Nowhere**, imagined the Houses of Parliament
being turned into a manure storage facility). And so on. Those who used to
work in such occupations would be asked to pursue a more fruitful way of life
or leave the community. In this manner, all harmful and useless institutions
would be destroyed or transformed into something of benefit to society.

In addition, as well as the transformation/destruction of the buildings
associated with the old state, the decision making process for the community
previously usurped by the state would come back into the hands of the people.
Alternative, self-managed organisations would be created in every community to
manage community affairs. From these community assemblies, confederations
would spring up to co-ordinate joint activities and interests. These
neighbourhood assemblies and confederations would be means by which power
would be dissolved in society and government finally eliminated in favour of
freedom (both individual and collective).

Ultimately, anarchism means creating positive alternatives to those existing
institutions which provide some useful function. For example, we propose self-
management as an alternative to capitalist production. We propose self-
governing communes to organise social life instead of the state. _"One only
destroys, and effectively and permanently,"_ argued Malatesta, _"that which
one replaces by something else; and to put off to a later date the solution of
problems which present themselves with the urgency of necessity, would be to
give time to the institutions one is intending to abolish to recover from the
shock and reassert themselves, perhaps under other names, but certainly with
the same structure."_ [**Op. Cit.**, p. 159] This was the failure of the
Spanish Revolution, which ignored the state rather than abolish it via new,
self-managed organisations (see [section I.8.13](secI8.md#seci813)). It must
be stressed that this was not due to anarchist theory (see [section
I.8.11](secI8.md#seci811)).

Hence a social revolution would see the _"[o]rganisation of social life by
means of free association and federations of producers and consumers, created
and modified according to the wishes of their members, guided by science and
experience, and free from any kind of imposition which does not spring from
natural needs, to which everyone, convinced by a feeling of overriding
necessity, voluntarily submits."_ [Malatesta, **Op. Cit.**, p. 184] A
revolution organises itself from the bottom up, in a self-managed way. As
Bakunin summarised:

> _"the federative Alliance of all working men's associations . . . will
constitute the Commune . . . The Commune will be organised by the standing
federation of the Barricades and by the creation of a Revolutionary Communal
Council composed of one or two delegates from each barricade . . . vested with
plenary but accountable and removable mandates . . . all provinces, communes
and associations . . . **reorganising** on revolutionary lines . . . [would
send] their representatives to an agreed meeting place . . . vested with
similar mandates to constitute the federation of insurgent associations,
communes and provinces in the name of the same principles and to organise a
revolutionary force capable of defeating reaction . . . it is the very fact of
the expansion and organisation of the revolution for the purpose of self-
defence among the insurgent areas that will bring about the triumph of the
revolution . . . There can no longer be any successful revolution unless the
political revolution is transformed into social revolution . . . Since
revolution everywhere must be created by the people, and supreme control must
always belong to the people organised in a free federation of agricultural and
industrial associations . . . organised from the bottom upwards by means of
revolutionary delegation."_ [**Michael Bakunin: Selected Writings**, pp.
170-2]

Thus we have a dual framework of revolution, the federation of self-managed
workplace and community assemblies based on mandated and recallable delegates.
_"Through its class organisations,"_ Makhno argued, _"the people yearned to
lay the foundations of a new, free society intended, as it develops without
interference, to eliminate from the body of society all the parasites and all
the power exercised by some over others, these being deemed by the toilers to
be stupid and harmful."_ [**Op. Cit.**, p. 79] These organisations, as we
stressed in [section I.2.3](secI2.md#seci23), are the products of the social
struggle and revolution themselves:

> _"Assembly and community must arise from within the revolutionary process
itself; indeed, the revolutionary process must **be** the formation of
assembly and community, and with it, the destruction of power. Assembly and
community must become 'fighting words,' not distinct panaceas. They must be
created as **modes of struggle** against existing society . . . The future
assemblies of people in the block, the neighbourhood or the district -- the
revolutionary sections to come -- will stand on a higher social level than all
the present-day committees, syndicates, parties and clubs adorned by the most
resounding 'revolutionary' titles. They will be the living nuclei of utopia in
the decomposing body of bourgeois society . . . The specific gravity of
society . . . must be shifted to its base -- the armed people in permanent
assembly."_ [Murray Bookchin, **Post-Scarcity Anarchism**, pp. 104-5]

Such organisations are required because _"[f]reedom has its forms . . . a
liberatory revolution always poses the question of what social forms will
replace existing ones. At one point or another, a revolutionary people must
deal with how it will manage the land and the factories from which it requires
the means of life. It must deal with the manner in which it will arrive at
decisions that affect the community as a whole. Thus if revolutionary thought
is to be taken at all seriously, it must speak directly to the problems and
forms of social management."_ [Bookchin, **Op. Cit.**, p. 86] If this is not
done, capitalism and the state will not be destroyed and the social revolution
will fail. Only by destroying hierarchical power, by abolishing state and
capitalism by self-managed organisations, can individuals free themselves and
society.

As well as these economic and political changes, there would be other changes
as well -- far too many to chronicle here. For example: _"We will see to it
that all empty and under-occupied houses are used so that no one will be
without a roof over his [or her] head. We will hasten to abolish banks and
title deeds and all that represents and guarantees the power of the State and
capitalist privilege. And we will try to reorganise things in such a way that
it will be impossible for bourgeois society to be reconstituted."_ [Malatesta,
**Op. Cit.**, p. 165] Similarly, free associations will spring up on a whole
range of issues, interests and needs. Social life will become transformed, as
will many aspects of personal life and personal relationships. We cannot say
in which way, bar there will be a general libertarian movement in all aspects
of life as women resist and overcome sexism, gays resist and end homophobia,
the young will expect to be treated as individuals, not property, and so on.

Society will become more diverse, open, free and libertarian in nature. And,
hopefully, it and the struggle that creates it will be **fun** \-- anarchism
is about making life worth living and so any struggle must reflect that. The
use of fun in the struggle is important. There is no incongruity in conducting
serious business and having fun. We are sure this will piss off the "serious"
Left no end. The aim of revolution is to emancipate **individuals** not
abstractions like "the proletariat," "society," "history" and so on. Having
fun is part and parcel of that liberation. As Emma Goldman argued (and was
paraphrased in the 1970s to _"If I cannot dance, it is not my revolution!"_),
anarchism stands for _"release and freedom from conventions and prejudice"_
and so she could _"not believe"_ that it _"should demand the denial of life
and joy"_ (_"If it meant that, I did not want it"_): _"I want freedom, the
right to self-expression, everybody's right to beautiful, radiant things."_
[**Living My Life**, vol. 1, p. 56] As Bookchin suggested: _"Can we resolve
the anarchic, intoxicating phase that opens all the great revolutions of
history merely into an expression of class interest and the opportunity to
redistribute social wealth?"_ [Bookchin, **Op. Cit.**, p. 189f]

Therefore a social revolution involves a transformation of society from the
bottom up by the creative action of working class people. This transformation
would be conducted through self-managed organisations which will be the basis
for abolishing hierarchy, state and capitalism: _"There can be no separation
of the revolutionary process from the revolutionary goal. **A society based on
self-administration must be achieved by means of self-administration** . . .
If we define 'power' as the power of man over man, power can only be destroyed
by the very process in which man acquires power over his own life and in which
he not only 'discovers' himself, but, more meaningfully, formulates his
selfhood in all its social dimensions."_ [Bookchin, **Op. Cit.**, p. 104]

## J.7.5 What is the role of anarchists in a social revolution?

All the great social revolutions have been spontaneous. Indeed, it is cliché
that the revolutionaries are usually the most surprised when a revolution
breaks out. Nor do anarchists assume that a revolution will initially be
totally libertarian in nature. All we assume is that there will be libertarian
tendencies which anarchists work within to try and strengthen. Therefore the
role of anarchists and anarchist organisations is to push a revolution towards
a social revolution by encouraging the tendencies we discussed in the [last
section](secJ7.md#secj74) and by arguing for anarchist ideas and solutions.
In the words of Vernon Richards:

> _"We do not for one moment assume that all social revolutions are
necessarily anarchist. But whatever form the revolution against authority
takes, the role of anarchists is clear: that of inciting the people to abolish
capitalistic property and the institutions through which it exercises its
power for the exploitation of the majority by a minority."_ [**Lessons of the
Spanish Revolution**, p. 44]

For anarchists, our role in a social revolution is clear -- we try to spread
anarchist ideas and encourage autonomous organisation and activity by the
oppressed. For example, during the Russian Revolution anarchists and anarcho-
syndicalists played a key role in the factory committee movement for workers'
self-management. They combated Bolshevik attempts to substitute state control
for workers' self-management and encouraged workplace occupations and
federations of factory committees (see Maurice Brinton's **The Bolsheviks and
Workers' Control** for a good introduction to this movement and Bolshevik
hostility to it). Similarly, they supported the soviets (councils elected by
workers in their workplaces) but opposed their transformation from
revolutionary bodies into state organs (and so little more than organs of the
Communist Party, rubber-stamping the decisions of the party leadership). The
anarchists tried to _"work for their conversion from centres of authority and
decrees into non-authoritarian centres, regulating and keeping things in order
but not suppressing the freedom and independence of local workers'
organisations. They must become centres which link together these autonomous
organisations."_ [G. P. Maksimov, **The Anarchists in the Russian
Revolution**, p. 105]

Therefore, the role of anarchists, as Murray Bookchin put it, is to
_"**preserve and extend the anarchic phase that opens all the great social
revolutions**"_ by working _"**within the framework of the forms created by
the revolution,** not within the forms created by the party. What this means
is that their commitment is to the revolutionary organs of self-management . .
. to the **social** forms, not the **political** forms."_ Revolutionary
anarchists _"seek to persuade the factory committees, assemblies or soviets to
make themselves into **genuine organs of popular self-management,** not to
dominate them, manipulate them, or hitch them to an all-knowing political
party,"_ to organise to _"propagate ideas systematically . . . **ideas which
promote the concept of self-management**."_ The revolutionary organisation
_"presents the most advanced demands"_ and _"formulate[s] -- in the most
concrete fashion -- the immediate task that should be performed to advance the
revolutionary process. It provides the boldest elements in action and in the
decision-making organs of the revolution."_ [**Post-Scarcity Anarchism**, pp.
139-140]

Equally as important, _"is that the people, all people, should lose their
sheep-like instincts and habits with which their minds have been inculcated by
an age-long slavery, and that they should learn to think and act freely. It is
to this great task of spiritual liberation that anarchists must especially
devote their attention."_ Unless people think and act for themselves, no
social revolution is possible and anarchy will remain just an opposition
tendency within authoritarian societies. Practically, this means the
encouragement of self-management and direct action. Anarchists thus _"push the
people to expropriate the bosses and put all goods in common and organise
their daily lives themselves, through freely constituted associations, without
waiting for orders from outside and refusing to nominate or recognise any
government or constituted body in whatever guise . . . even in a provisional
capacity, which ascribes to itself the right to lay down the law and impose
with force its will on others."_ [Malatesta, **Errico Malatesta: His Life and
Ideas**, pp. 160-1 and p. 197] This is because, to quote Bakunin, anarchists
do _"not accept, even in the process of revolutionary transition, either
constituent assemblies, provisional governments or so-called revolutionary
dictatorships; because we are convinced that revolution is only sincere,
honest and real in the hands of the masses, and that when it is concentrated
in those of a few ruling individuals it inevitably and immediately becomes
reaction."_ [**Michael Bakunin: Selected Writings**, p. 237]

The history of every revolution confirms Kropotkin (who echoed Proudhon) that
_"revolutionary government"_ is a contradiction in terms. Government bodies
mean _"the transferring of initiative from the armed workers to a central body
with executive powers. By removing the initiative from the workers, the
responsibility for the conduct of the struggle and its objectives [are] also
transferred to a governing hierarchy, and this could have no other than an
adverse effect on the morale of the revolutionary fighters."_ [Richards, **Op.
Cit.**, pp. 42-3] Such a centralisation of power means the suppression of
local initiatives, the replacing of self-management with bureaucracy and the
creation of a new, exploitative and oppressive class of officials and party
hacks. Only when power rests in the hands of everyone can a social revolution
exist and a free society be created. If this is not done, if the state
replaces the self-managed associations of a free people, all that happens is
the replacement of one class system by another. This is because the state is
an instrument of minority rule -- it can never become an instrument of
majority empowerment as its centralised, hierarchical and authoritarian nature
excludes such a possibility (see [section H.3.7](secH3.md#sech37) for more
discussion on this issue).

Therefore an important role of anarchists is to undermine hierarchical
organisation by creating self-managed ones, by keeping the management and
direction of a struggle or revolution in the hands of those actually
conducting it. It is **their** revolution, **not** a party's and so they
should control and manage it. They are the ones who have to live with the
consequences of it. As Bakunin argued, social revolution _"should not only be
made for the people's sake; it should also be made by the people."_ [**No
Gods, No Masters**, vol. 1, p. 141] _"The revolution is safe, it grows and
becomes strong,"_ correctly argued Alexander Berkman, _"as long as the masses
feel that they are direct participants in it, that they are fashioning their
own lives, that **they** are making the revolution, that they **are** the
revolution. But the moment that their activities are usurped by a political
party or are centred in some special organisation, revolutionary effort
becomes limited to a comparatively small circle from which the large masses
are practically excluded. The natural result is that popular enthusiasm is
dampened, interest gradually weakens, initiative languishes, creativeness
wanes, and the revolution becomes the monopoly of a clique which presently
turns dictator."_ [**What is Anarchism?**, p. 213] The history of every
revolution proves this point, we feel, and so the role of anarchists is clear
-- to keep a revolution revolutionary by encouraging libertarian ideas,
organisation, tactics and activity.

Anarchists, therefore, organise to influence social struggle in a libertarian
manner and our role in any social revolution is to combat authoritarian
tendencies and parties while encouraging working class self-organisation,
self-activity and self-management (how we organise to achieve this is
described in [section J.3](secJ3.md)). Only by the spreading of libertarian
ideas and values within society, encouraging libertarian forms of social
organisation (i.e., self-management, decentralisation, federalism, etc.) and
continually warning against centralising power into a few hands can a
revolution become more than a change of masters.

## J.7.6 How could an anarchist revolution defend itself?

To some, particularly Marxists, this section may seem in contradiction with
anarchist ideas. As we discussed in [section H.2.1](secH2.md#sech21),
Marxists tend to assume, incorrectly, that anarchists are either against
defending a revolution or see no need to. However, as will become very clear,
nothing could be further from the truth. Anarchists have always argued for
defending a revolution -- by force, if necessary. Anarchists argue that Marx
(and Marxists) confuse self-defence by _"the people armed"_ with the state, a
confusion which has horrific implications (as the history of the Russian
Revolution shows).

So how would an anarchist revolution (and by implication, society) defend
itself? Firstly, we should note that it will **not** defend itself by creating
a centralised body, a new state. If it did this then the revolution will have
failed and a new class society would have been created (a society based on
state bureaucrats and oppressed workers as in the Soviet Union). Thus we
reject the Marxist notion of a so-called "workers" or "revolutionary" state as
confused in the extreme (as should be obvious from our analysis in [section
H](secHcon.md)). Rather, we seek libertarian means to defend a libertarian
revolution. What would these libertarian means be?

In short, this would involve the _"creation of a voluntary militia, without
powers to interfere as militia in the life of the community, but only to deal
with any armed attacks by the forces of reaction to re-establish themselves,
or to resist outside intervention by countries as yet not in a state of
revolution."_ The creation of a free militia would be part of the general
social transformation as the _"most powerful means for defending the
revolution remains always that of taking away from the bourgeois the economic
means on which their power rests, and of arming everybody (until such time as
one will have managed to persuade everybody to throw away their arms as
useless and dangerous toys), and of interesting the mass of the population in
the victory of the revolution."_ [Malatesta, **Errico Malatesta: His Life and
Ideas**, p. 166 and p. 173] As Bakunin stressed:

> _"let us suppose . . . it is Paris that starts [the revolution] . . . Paris
will naturally make haste to organise itself as best it can, in revolutionary
style, after the workers have joined into associations and made a clean sweep
of all the instruments of labour, every kind of capital and building; armed
and organised by streets and **quartiers**, they will form the revolutionary
federation of all the **quartiers**, the federative commune . . . All the
French and foreign revolutionary communes will then send representatives to
organise the necessary common services . . . and to organise common defence
against the enemies of the Revolution, together with propaganda, the weapon of
revolution, and practical revolutionary solidarity with friends in all
countries against enemies in all countries."_ [**Michael Bakunin: Selected
Writings**, pp. 178-9]

So anarchists have always seen the necessity to defend a revolution. There is
no theoretical contradiction implied by this for while anarchism _"is opposed
to any interference with your liberty"_ and _"against all invasion and
violence"_, it recognises that when _"any one attacks **you**, then it is
**he** who is invading you, he who is employing violence against you. You have
a right to defend yourself. More than that, it is your duty, as an anarchist
to protect your liberty, to resist coercion and compulsion . . . In other
words, the social revolution will attack no one, but it will defend itself
against invasion from any quarter."_ [Alexander Berkman, **What is
Anarchism?**, p. 231] These militias, in other words, do not seek to impose a
revolution, for you cannot impose freedom or force people to be free against
their will: _"The power of the people in arms can only be used in the defence
of the revolution and the freedoms won by their militancy and their
sacrifices."_ [Vernon Richards, **Lessons of the Spanish Revolution**, p. 44]

Such activity, Berkman stressed, _"must be in consonance with th[e] spirit [of
anarchism]. Self-defence excludes all acts of coercion, of persecution or
revenge. It is concerned only with repelling attack and depriving the enemy of
opportunity to invade you."_ Any defence would be based on _"the strength of
the revolution . . . First and foremost, in the support of the people . . . If
they feel that they themselves are making the revolution, that they have
become masters of their lives, that they have gained freedom and are building
up their welfare, then in that very sentiment you have the greatest strength
of the revolution . . . Let them believe in the revolution, and they will
defend it to the death."_ Thus the _"armed workers and peasants are the only
effective defence of the revolution."_ [**Op. Cit.**, pp. 231-2] Malatesta
stressed that a government is not required to defend freedom:

> _"But, by all means, let us admit that the governments of the still
unemancipated countries were to want to, and could, attempt to reduce free
people to a state of slavery once again. Would this people require a
government to defend itself? To wage war men are needed who have all the
necessary geographical and mechanical knowledge, and above all large masses of
the population willing to go and fight. A government can neither increase the
abilities of the former nor the will and courage of the latter. And the
experience of history teaches us that a people who really want to defend their
own country are invincible: and in Italy everyone knows that before the corps
of volunteers (anarchist formations) thrones topple, and regular armies
composed of conscripts or mercenaries disappear."_ [**Anarchy**, p. 42]

As can be seen, anarchist theory has always addressed the necessity of
defending a social revolution and proposed a solution -- the voluntary, self-
managed militia organised by the free communes and federations of workers'
associations. The militias would be unified and co-ordinated by federations of
communes while delegates from each militia unit would co-ordinate the actual
fighting. In times of peace the militia members would be living and working
among the rest of the populace, and, thus, they would tend to have the same
outlook and interests as their fellows. Moreover, in the case of foreign
intervention, the importance of international solidarity is important (_"a
social revolution cannot be a revolution in one nation alone. It is by nature
an international revolution."_ [Bakunin, **Op. Cit.**, p. 49]). Thus any
foreign intervention would face the problems of solidarity actions and revolts
on its own doorstep and not dare send its troops abroad for long, if at all.
Ultimately, the only way to support a revolution is to make your own.

Within the revolutionary area, it is the actions of liberated people that will
defend it. Firstly, the population would be armed and so counter-
revolutionaries would face stiff opposition to their attempts to recreate
authority. Secondly, they would face liberated individuals who would reject
and resist their attempts Thus, as we discuss in [section
I.5.11](secI5.md#seci511), any authoritarian would face the direct action of
a free people, of free individuals, who would refuse to co-operate with the
would-be authorities and join in solidarity with their friends and fellow
workers to resist them. The only way a counter-revolution could spread
internally is if the mass of the population had become alienated from the
revolution and this is impossible in an anarchist revolution as power remains
in their hands. A free society need not fear internal counter-revolutionaries
gaining support.

History, as well as theory, points to such libertarian forms of self-defence.
In all the major revolutions which anarchists took part in they formed
militias to defend freedom. For example, anarchists in many Russian cities
formed _"Black Guards"_ to defend their expropriated houses and revolutionary
freedoms. In the Ukraine, Nestor Makhno helped organise a peasant-worker army
to defend the social revolution against authoritarians of right and left. In
the Spanish Revolution, the CNT organised militias to free those parts of
Spain under fascist rule after the military coup in 1936.

These anarchist militias were as self-managed as possible, with any "officers"
elected and accountable to the troops and having the same pay and living
conditions as them. Nor did they impose their ideas on others. When a militia
liberated a village, town or city they called upon the population to organise
their own affairs, as they saw fit. All the militia did was present
suggestions and ideas to the population. For example, when the Makhnovists
passed through a district they would put on posters announcing:

> _"The freedom of the workers and the peasants is their own, and not subject
to any restriction. It is up to the workers and peasants to act, to organise
themselves, to agree among themselves in all aspects of their lives, as they
themselves see fit and desire . . . The Makhnovists can do no more than give
aid and counsel . . . In no circumstances can they, nor do they wish to,
govern."_ [quoted by Peter Marshall, **Demanding the Impossible**, p. 473]

Needless to say, the Makhnovists counselled the workers and peasants _"to set
up free peasants' and workers' councils"_ as well as to expropriate the land
and means of production. They argued that _"[f]reedom of speech, of the press
and of assembly is the right of every toiler and any gesture contrary to that
freedom constitutes an act of counter-revolution."_ [**No Gods, No Masters**,
vol. 2, pp. 157-8] The Makhnovists also organised regional congresses of
peasants and workers to discuss revolutionary and social issues. The army's
declared principles were voluntary enlistment, the election of officers and
self-discipline according to the rules adopted by each unit themselves.
Remarkably effective, the Makhnovists were the force that defeated Denikin's
army and helped defeat Wrangel. After the Whites were defeated, the Bolsheviks
turned against the Makhnovists and betrayed them. However, while they existed
the Makhnovists defended the freedom of the working class to organise
themselves against both right and left statists (see Voline's **The Unknown
Revolution**, Peter Arshinov's **History of the Makhnovist Movement** or
Alexandre Skirda's **Nestor Makhno Anarchy's Cossack** for more information).

A similar situation developed in Spain. After defeating the fascist military
coup on 19th of July, 1936, the anarchists organised self-managed militias to
liberate those parts of Spain under Franco. These groups were organised in a
libertarian fashion from the bottom up:

> _"The establishment of war committees is acceptable to all confederal
militias. We start from the individual and form groups of ten, which come to
accommodations among themselves for small-scale operations. Ten such groups
together make up one **centuria,** which appoints a delegate to represent it.
Thirty **centurias** make up one column, which is directed by a war committee,
on which the delegates from the **centurias** have their say . . . although
every column retains its freedom of action, we arrive at co-ordination of
forces, which is not the same thing as unity of command."_ [**Op. Cit.**, pp.
256-7]

Like the Makhnovists, the anarchist militias in Spain were not only fighting
against reaction, they were fighting for a better world. As Durruti argued:
_"Our comrades on the front know for whom and for what they fight. They feel
themselves revolutionaries and they fight, not in defence of more or less
promised new laws, but for the conquest of the world, of the factories, the
workshops, the means of transportation, their bread and the new culture."_
[**Op. Cit.**, p. 248] When they liberated towns and villages, the militia
columns urged workers and peasants to collectivise the land and means of
production, to re-organise life in a libertarian fashion. All across anti-
Fascist Spain workers and peasants did exactly that. The militias only
defended the workers' and peasants' freedom to organise their own lives as
they saw fit and did not force them to create collectives or dictate their
form.

In this, the CNT was not only following the suggestions of the likes of
Bakunin and Malatesta, it was implementing its own stated policies. Thus
before the revolution we find leading FAI member D. A. Santillan arguing that
the _"local Council of Economy will assume the mission of defence and raise
voluntary corps for guard duty and if need be, for combat"_ in the _"cases of
emergency or danger of a counter-revolution."_ These Local Councils would be a
federation of workplace councils and would be members of the Regional Council
of the Economy which, like the Local Council, would be _"constitute[d] by
delegations or through assemblies."_ [**After the Revolution**, p. 80 and pp.
82-83] Thus defence of a free society is based on the federation of workers'
councils and so directly controlled by the revolutionary population. This can
also be seen in the Spanish CNT's 1936 resolution on Libertarian Communism in
the section entitled **_"Defence of the Revolution"_**:

> _"We acknowledge the necessity to defend the advances made through the
revolution . . . So . . . the necessary steps will be taken to defend the new
regime, whether against the perils of a foreign capitalist invasion . . . or
against counter-revolution at home. It must be remembered that a standing army
constitutes the greatest danger for the revolution, since its influence could
lead to dictatorship, which would necessarily kill off the revolution . . .
The people armed will be the best assurance against any attempt to restore the
system destroyed from either within or without . . . Let each Commune have its
weapons and means of defence . . . the people will mobilise rapidly to stand
up to the enemy, returning to their workplaces as soon as they may have
accomplished their mission of defence. . . . _

> _"1. The disarming of capitalism implies the surrender of weaponry to the
communes which be responsible for ensuring defensive means are effectively
organised nationwide._

> _"2. In the international context, we shall have to mount an intensive
propaganda drive among the proletariat of every country so that it may take an
energetic protest, calling for sympathetic action against any attempted
invasion by its respective government. At the same time, our Iberian
Confederation of Autonomous Libertarian Communes will render material and
moral assistance to all the world's exploited so that these may free
themselves forever from the monstrous control of capitalism and the State."_
[quoted by Jose Peirats, **The CNT in the Spanish Revolution**, vol. 1, p.
110]

Which was precisely what the CNT did do in July 1936 when faced with the
fascist coup. Unfortunately, like the Makhnovists, the CNT militias were
betrayed by their so-called allies on the left. The anarchist troops were not
given enough arms and were left on the front to rot in inaction. The "unified"
command of the Republican State preferred not to arm libertarian troops as
they would use these arms to defend themselves and their fellow workers
against the Communist led counter-revolution. Ultimately, the _"people in
arms"_ won the revolution and the _"People's Army"_ which replaced it lost the
war (see Jose Peirats' **The CNT in the Spanish Revolution**, Abel Paz's
**Durruti in the Spanish Revolution**, Vernon Richard's **Lessons of the
Spanish Revolution** or Noam Chomsky's **Objectivity and Liberal
Scholarship**).

While the cynic may point out that, in the end, these revolutions and militias
were defeated, it does not mean that their struggle was in vain or a future
revolution will not succeed. That would be like arguing in 1940 that democracy
is inferior to fascism because most democratic states had been (temporarily)
defeated by the Axis powers. It does not mean that these methods will fail in
the future or that we should embrace apparently more "successful" approaches
which end in the creation of a society the total opposite of what we desire
(means determine ends, after all, and statist means will create statist ends
and apparent "successes" -- like Bolshevism -- are the greatest of failures in
terms of our ideas and ideals). All we are doing here is pointing how
anarchists have defended revolutions in the past and that these methods were
successful for a long time in face of tremendous opposition forces.

Thus, in practice, anarchists have followed libertarian theory and created
self-managed forms of self-defence against attempts to re-enslave a free
people. In the end, an anarchist revolution can be defended only by applying
its ideas as widely as possible. Its defence rests in those who make it. If
the revolution is an expression of their needs, desires and hopes then it will
be defended with the full passion of a free people. Such a revolution **may**
be defeated by superior force, who can tell? But the possibility is that it
will not and that is what makes it worth trying. To not act because of the
possibility of failure is to live half a life.

Anarchism calls upon everyone to live the kind of life they deserve as unique
individuals and desire as human beings. Individually we can make a difference,
together we can change the world.

[‹ J.6 What methods of child rearing do anarchists advocate? ](secJ6.md "Go
to previous page" ) [up](secJcon.md "Go to parent page" ) [Appendix :
Anarchism and "anarcho"-capitalism ›](append1.md "Go to next page" )

