// ========================================================================
// copyright (C) 1999-2003 by Tobias Erbsland <te@profzone.ch>
// ------------------------------------------------------------------------
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2 of the License, or (at your
// option) any later version.
// ========================================================================

#include "mranalyse.h"

mrAnalyse::mrAnalyse() :
		strPrefix( "mr" ),
		strName( "Most Recipients" ),
		strVersion( "V0.1" ),
		strAuthor( "Tobias Erbsland <te@profzone.ch>" ),
		strHelp( "Create statistics about the sender with the most recipients." )
{
	addParam( "limit", "Limit Output to n Lines.", "Integer from 1 to x.", G_STRING, "25" );
	addParam( "no-delivery", "Statistic with not delivered mail",
	          "If set, not delivered mails are included.", G_FLAG, "0" );
	addParam( "only-no-delivery", "Statistic ONLY with not delivered mail",
	          "If set, ONLY not delivered mails are included.", G_FLAG, "0" );
}

void mrAnalyse::run( std::map< std::string, unity_t > * unity_map )
{
	mrAnalyse::unity_map = unity_map; // Speichern, unsicher...

	std::map< std::string, unity_t >::iterator i;

	bool not_del = false;
	bool del = true;
	int limit = getIntParam( "limit" );

	if ( getFlagParam( "no-delivery" ) ) not_del = true; // Auch falsche;
	if ( getFlagParam( "only-no-delivery" ) )  // Hat auch vorrang.
	{
		not_del = true;
		del = false;
	};

	for ( i = unity_map->begin(); i != unity_map->end(); i++ )
	{
		// Nichtzugestellte oder zugestellte Mails aus statistik entfernen.
		if ( !not_del && ( i->second.to_intern.size() + i->second.to_extern.size() == 0 ) ) continue;
		if ( !del && ( i->second.to_intern.size() + i->second.to_extern.size() != 0 ) ) continue;

		most_recipients.insert( std::make_pair( i->second.to_extern.size() + i->second.to_intern.size(), i->first ) );
		if ( most_recipients.size() > static_cast<std::multimap<std::string, long>::size_type>( limit ) )
			most_recipients.erase( most_recipients.begin() );
	}
}

void mrAnalyse::print( void )
{
	if ( !report ) return ; // be sure :-)

	//	std::list< std::string >::iterator k;
	std::multimap< long, std::string >::reverse_iterator j;

	report->startNewReport( "Most Recipients", Report::TABLE );
	report->addCol( 4, Report::COUNTER, Report::RIGHT, "nr", Report::NONE );
	// -1 = soviel platz verwenden, wie noch vorhanden.
	report->addCol( -1, Report::STRING, Report::LEFT, "from", Report::NONE );
	report->addCol( 9, Report::INTEGER, Report::RIGHT, "size", Report::NONE );
	report->addCol( 6, Report::INTEGER, Report::RIGHT, "total", Report::NONE );
	report->addCol( 5, Report::INTEGER, Report::RIGHT, "ext", Report::ROUND );
	report->addCol( 5, Report::INTEGER, Report::RIGHT, "int", Report::ROUND );
	report->addCol( 10, Report::DATE, Report::RIGHT, "date", Report::NONE );
	report->printHeader();
	for ( j = most_recipients.rbegin(); j != most_recipients.rend(); j++ )
	{
		report->printField( ( *unity_map ) [ j->second ].from );
		report->printField( ( *unity_map ) [ j->second ].size );
		report->printField( j->first );
		report->printField( static_cast<long>( ( *unity_map ) [ j->second ].to_extern.size() ) );
		report->printField( static_cast<long>( ( *unity_map ) [ j->second ].to_intern.size() ) );
		// i make here a static cast, but this is only a workaround!!!
		report->printField( static_cast<long>( ( *unity_map ) [ j->second ].date ) );
	}
	report->printFooter();
}

void mrAnalyse::free( void )
{
	most_recipients.clear();
}
