// ========================================================================
// copyright (C) 1999-2003 by Tobias Erbsland <te@profzone.ch>
// ------------------------------------------------------------------------
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2 of the License, or (at your
// option) any later version.
// ========================================================================

#ifndef PLUGIN_H
#define PLUGIN_H
#ifdef _MSC_VER
#include "win32/config_win32.h"
#endif
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <list>

#include "parameter.h"
#include "report.h"
#include "filter.h"
#include "addrfilter.h"
#include "analyse.h"

/** The abstract Plugin class.
  *@author Tobias Erbsland
  */
class Plugin : public Parameter
{

protected:
	struct maps_t
	{
		std::list<Filter *> * f;
		std::list<AddrFilter *> * d;
		std::list<Analyse *> * a;
		std::list<Report *> * r;
		std::list<Plugin *> * p;
	};
	maps_t maps;

public:
	enum pa_e {
	    PA_BEFORE_PARAM = 2 ^ 0,
	    PA_INIT = 2 ^ 1,
	    PA_BEFORE_FILTER = 2 ^ 2,
	    PA_FILTER = 2 ^ 3,
	    PA_AFTER_FILTER = 2 ^ 4,
	    PA_BEFORE_ANALYSE = 2 ^ 5,
	    PA_ANALYSE = 2 ^ 6,
	    PA_AFTER_ANALYSE = 2 ^ 7,
	    PA_FREE = 2 ^ 8,
	    PA_ADDRFILTER = 2 ^ 9
	};
	enum ps_e { PS_CONTINUE, PS_STOP, PS_DISABLE, PS_ENABLE };

	/** This function is tested before every action. You can return a set of function
	  * flags to execute this functions of your plugin object.
	  */
	virtual int pa( void ) { return 0; }; // No actions.

	/** After adding the new plugin to the plugin list, this function is called to
	  * set all pointers to every list. So every plugin object can access all other
	  * objects in the system.
	  */
	virtual void setPointer( std::list< Filter * > * f, std::list< AddrFilter * > * d,
	                         std::list< Analyse * > * a, std::list< Report * > * r,
	                         std::list< Plugin * > * p );

	/** This function is executed if the Flag PA_BEFORE_PARAM set before any Parameters
	  * are read from the plugin object. Place here code to generate generic parameters,
	  * based on other objects in the system.
	  */
	virtual void beforeParam( void ) { };

	/** After reading all parameters, this function is called.
	  */
	virtual ps_e init( void ) { return PS_DISABLE; };

	/** This function is called before the current selected filter is running.
	  */
	virtual ps_e beforeFilter( Filter * fp ) { return PS_CONTINUE; };

	/** If you use this function, make sure that your plugin is the _only one_
	  * who use this. A call of this function should run the filter.
	  */
	virtual ps_e filter( void ) { return PS_CONTINUE; };

	/** This function is called after the current selected filter is done.
	  */
	virtual ps_e afterFilter( Filter * fp ) { return PS_CONTINUE; };

	/** This function is called before every analysis.
	  */
	virtual ps_e beforeAnalyse( Analyse * ap ) { return PS_CONTINUE; };

	/** Make sure that your plugin is the _only one_ use this function. A call
	  * should execute all selected analysis.
	  */
	virtual ps_e analyse( void ) { return PS_CONTINUE; };

	/** This function is called after every analysis.
	 */
	virtual ps_e afterAnalyse( Analyse * ap ) { return PS_CONTINUE; };

	/** Before everything is done, this function is called to clean perhaps
	  * someting.
	  */
	virtual ps_e free( void ) { return PS_CONTINUE; };

	/** This function is called from a filter object for every adress.
	  * It should call all necessary addrfilters and return the result summary.
	  */
	virtual bool addrFilter( std::string &addr ) { return false; };

	/** The virtual deconstructor.
	  */
	virtual ~Plugin();
};

#endif
