/*****************************************************************************/
/*****************************************************************************/
/**                                                                         **/
/**  Antenna Visualization Toolkit                                          **/
/**                                                                         **/
/**  Adrian Agogino  agogino@ece.utexas.edu                                 **/
/**  Ken Harker      kharker@cs.utexas.edu                                  **/
/**                                                                         **/
/**  May 1998                                                               **/
/**                                                                         **/
/*****************************************************************************/
/*****************************************************************************/


#ifndef VIS_FIELD_H
#define VIS_FIELD_H

#include "MyTypes.h"
#include "ant.h"
#include <GL/gl.h>
#include <GL/glu.h>


/*****************************************************************************/
/*****************************************************************************/
/**                                                                         **/
/**                             Definitions                                 **/
/**                                                                         **/
/*****************************************************************************/
/*****************************************************************************/


#define  MAX_ANTENNAS  5
#define  LINEAR        0
#define  RIGHT         1
#define  LEFT          2

 
/*****************************************************************************/
/*****************************************************************************/
/**                                                                         **/
/**                         Function Prototypes                             **/
/**                                                                         **/
/*****************************************************************************/
/*****************************************************************************/


void    PlotPoint(GLfloat, GLfloat, GLfloat);

void    DrawRFPowerDensityPoints(Ant *);
void    DrawPolarizationSensePoints(Ant *);
void    DrawPolarizationTiltPoints(Ant *);
void    DrawShowNullsPoints(Ant *);
void    DrawAxialRatioPoints(Ant *);

void    DrawRFPowerDensitySurface(Ant *);
void    DrawPolarizationSenseSurface(Ant *);
void    DrawPolarizationTiltSurface(Ant *);
void    DrawAxialRatioSurface(Ant *);
void    DrawShowNullsSurface(Ant *);

void    DrawRFPowerDensitySphere(Ant *);
void    DrawPolarizationSenseSphere(Ant *);
void    DrawPolarizationTiltSphere(Ant *);
void    DrawAxialRatioSphere(Ant *);
void    DrawShowNullsSphere(Ant *);


#endif


/*****************************************************************************/
/*****************************************************************************/
/**                                                                         **/
/**                           End of VisField.h                             **/
/**                                                                         **/
/*****************************************************************************/
/*****************************************************************************/
