/* Copyright (C) 2002, 2003, 2004, 2005 Jan Wedekind.
   This file is part of the recipe database application AnyMeal.

   AnyMeal is free software; you can redistribute it and/or modify it under
   the terms of the GNU GENERAL PUBLIC LICENSE as published by the Free
   Software Foundation; either version 2 of the License, or (at your option)
   any later version.

   AnyMeal is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTIBILITY or FITNESS
   FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
   details.

   You should have received a copy of the GNU General Public License along
   with AnyMeal; if not, contact one of the authors of this software. */
#include <cassert>
#include <stdlib.h>
#include "recipeListItem.hpp"

using namespace std;

RecipeListItem::RecipeListItem( QListView *parent, int _id,
                                const QString &_title, bool _selected ):
  QCheckListItem( parent, QString( "%1" ).arg( _id ), CheckBox ), id(_id)
{
  setTitle( _title );
  setOn( _selected );
}

int RecipeListItem::compare( QListViewItem *i, int col, bool ascending ) const
{
  int retVal;
  if ( col != 1 ) {
    double
      a = atof( key( col, ascending ) ),
      b = atof( i->key( col, ascending ) );
    if ( a < b )
      retVal = -1;
    else
      if ( a > b )
        retVal = 1;
      else
        retVal = 0;
  } else
    retVal = QCheckListItem::compare( i, col, ascending );
  return retVal;
}

void RecipeListItem::setId( int _id )
{
  setText( 0, QString( "%1" ).arg( _id ) );
  id = _id;
}

void RecipeListItem::setTitle( const QString &_title )
{
  setText( 1, _title );
}
