/* Copyright (C) 2002, 2003, 2004, 2005 Jan Wedekind.
   This file is part of the recipe database application AnyMeal.

   AnyMeal is free software; you can redistribute it and/or modify it under
   the terms of the GNU GENERAL PUBLIC LICENSE as published by the Free
   Software Foundation; either version 2 of the License, or (at your option)
   any later version.

   AnyMeal is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTIBILITY or FITNESS
   FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
   details.

   You should have received a copy of the GNU General Public License along
   with AnyMeal; if not, contact one of the authors of this software. */
#include <sstream>
#include <DOMSupport/DOMServices.hpp>
#include <framework/LocalFileInputSource.hpp>
#include <framework/MemBufInputSource.hpp>
#include <util/PlatformUtils.hpp>
#ifdef SIMPLEXPATH
#include <XPath/XPathEvaluator.hpp>
#include <DOMSupport/XalanDocumentPrefixResolver.hpp>
#else
#include <XPath/XPath.hpp>
#include <XPath/ElementPrefixResolverProxy.hpp>
#include <XPath/XPathProcessorImpl.hpp>
#endif
#include "strX.hpp"
#include "xmlDocument.hpp"

using namespace std;
// using namespace xercesc;
// using namespace xalanc;

// XALAN_USING_XERCES(InputSource);
// XALAN_USING_XERCES(XMLException);

XMLDocument::XMLDocument( const std::string &schemaURI ):
   theLiaison( theDOMSupport )
#ifndef SIMPLEXPATH
  , theExecutionContext( theEnvSupport, theDOMSupport, theXObjectFactory )
#endif
{
  theDOMSupport.setParserLiaison( &theLiaison );
  theLiaison.setErrorHandler( &xmlErrorHandler );
  if ( !schemaURI.empty() ) {
#ifndef NDEBUG
    cerr << "Specifying schema \"" << schemaURI << "\"." << endl;
#endif
    if ( schemaURI.find( ' ' ) < schemaURI.size() )
      theLiaison.setExternalSchemaLocation
        ( StrX<XMLCh,char>( schemaURI.c_str() ).getBuffer() );
    else
      theLiaison.setExternalNoNamespaceSchemaLocation
        ( StrX<XMLCh,char>( schemaURI.c_str() ).getBuffer() );
    theLiaison.setUseValidation( true );
  };
  theLiaison.setDoNamespaces( true );
};

void XMLDocument::load( const std::string &fileName ) throw (Error)
{
  // XALAN_USING_XERCES(LocalFileInputSource)
  try {
    LocalFileInputSource
      localFileInputSource( StrX<XMLCh,char>( fileName.c_str() ).getBuffer() );
    fromInputSource( localFileInputSource );
  } catch ( XMLException &exc ) {
    ERRORMACRO( false, Error, ,
                "Could not load XML file \"" << fileName << "\": "
                << ( StrX<char,XMLCh>( exc.getMessage() ).getBuffer() ) );
  };
};

void XMLDocument::save( const std::string & ) throw (Error)
{
  ERRORMACRO( false, Error, ,
              "Saving of xml-documents not implemented yet." );
}

void XMLDocument::fromString( const string &string ) throw (Error)
{
  // XALAN_USING_XERCES(MemBufInputSource);
  MemBufInputSource memBufInputSource
    ( (const XMLByte *)string.c_str(), string.size(),
      "XML string in memory" );
  fromInputSource( memBufInputSource );
}

void XMLDocument::fromInputSource( InputSource &inputSource ) throw (Error)
{
  document = theLiaison.parseXMLStream( inputSource );
  if ( xmlErrorHandler.getErrorOccurred() ) {
    ERRORMACRO( false, Error, ,
                "Parse error in XML file: "
                << xmlErrorHandler.getErrorMessage() );
  };
  assert( document != NULL );
}
